/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spelltree;

import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spell.base.SpellIcon;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTreeClass;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class SpellTree {
    public UUID id;
    public SpellNode root;
    public Component title;
    public ISpell icon;
    @Nullable
    public SpellTreeClass treeClass;

    public SpellTree(UUID id, SpellNode root, Component title, ISpell icon) {
        this.id = id;
        this.root = root;
        this.title = title;
        this.icon = icon;
        this.treeClass = null;
    }

    public SpellTree(UUID id, SpellNode root, Component title) {
        this(id, root, title, root.getSpell());
    }

    public UUID getId() {
        return this.id;
    }

    public SpellNode getRoot() {
        return this.root;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public ISpell getIconSpell() {
        return this.icon;
    }

    public SpellIcon getIcon() {
        return this.getIconSpell().getIcon();
    }

    public void setIcon(ISpell spell) {
        this.icon = spell;
    }

    public int getDepth(ISpell spell) {
        if (this.root == null) {
            return 0;
        }
        return this.find(1, this.root, spell);
    }

    private int find(int depth, SpellNode spellNode, ISpell spell) {
        if (spellNode.getSpell() == spell) {
            return depth;
        }
        ++depth;
        for (SpellNode child : spellNode.getChildren()) {
            int found = this.find(depth, child, spell);
            if (found == 0) continue;
            return found;
        }
        return 0;
    }

    public void forEach(Consumer<SpellNode> consumer) {
        if (this.root != null) {
            this.innerForEach(this.root, consumer);
        }
    }

    private void innerForEach(SpellNode spellNode, Consumer<SpellNode> consumer) {
        consumer.accept(spellNode);
        for (SpellNode child : spellNode.getChildren()) {
            this.innerForEach(child, consumer);
        }
    }

    public SpellTree copy() {
        return new SpellTree(this.id, this.innerDeepCopy(this.root), (Component)this.title.m_6881_(), this.icon);
    }

    private SpellNode innerDeepCopy(SpellNode original) {
        SpellNode copy = original.copy();
        for (SpellNode child : original.getChildren()) {
            SpellTree.connect(copy, this.innerDeepCopy(child));
        }
        return copy;
    }

    public static void connect(SpellNode parent, SpellNode child) {
        parent.addChild(child);
        child.setParent(parent);
    }

    public static Builder builder(UUID id, Supplier<ISpell> root, int levelCost, int requiredBookshelves, Component treeTitle) {
        return new Builder(id, root, levelCost, requiredBookshelves, treeTitle);
    }

    public static Builder builder(UUID id, ISpell root, int levelCost, int requiredBookshelves, Component treeTitle) {
        return new Builder(id, root, levelCost, requiredBookshelves, treeTitle);
    }

    public static Builder builder(UUID id, SpellNode root, Component treeTitle) {
        return new Builder(id, root, treeTitle);
    }

    public static class Builder {
        private UUID id;
        private Stack<SpellNode> stack;
        private SpellNode root;
        private Component title;
        private ISpell icon;

        private Builder(UUID id, SpellNode root, Component title) {
            this.id = id;
            this.stack = new Stack();
            this.root = root;
            this.title = title;
            this.icon = null;
            this.stack.push(this.root);
        }

        private Builder(UUID id, ISpell root, int levelCost, int requiredBookshelves, Component title) {
            this(id, new SpellNode(root, levelCost, requiredBookshelves), title);
        }

        public Builder(UUID id, Supplier<ISpell> root, int levelCost, int requiredBookshelves, Component title) {
            this(id, root.get(), levelCost, requiredBookshelves, title);
        }

        public Builder add(Supplier<ISpell> spell, int levelCost, int requiredBookshelves) {
            return this.add(spell.get(), levelCost, requiredBookshelves);
        }

        public Builder add(Supplier<ISpell> spell, int levelCost) {
            return this.add(spell.get(), levelCost, this.root.getRequiredBookshelves());
        }

        public Builder add(Supplier<ISpell> spell) {
            return this.add(spell, this.root.getLevelCost());
        }

        public Builder add(ISpell spell, int levelCost, int requiredBookshelves) {
            this.add(new SpellNode(spell, levelCost, requiredBookshelves));
            return this;
        }

        public Builder add(ISpell spell, int levelCost) {
            return this.add(spell, levelCost, this.root.getRequiredBookshelves());
        }

        public Builder add(ISpell spell) {
            return this.add(spell, this.root.getLevelCost());
        }

        public Builder add(SpellNode spellNode) {
            SpellTree.connect(this.stack.peek(), spellNode);
            this.stack.push(spellNode);
            return this;
        }

        public Builder leaf() {
            this.stack.pop();
            return this;
        }

        public Builder icon(ISpell spell) {
            this.icon = spell;
            return this;
        }

        public SpellTree finish() {
            return new SpellTree(this.id, this.root, this.title, this.icon != null ? this.icon : this.root.getSpell());
        }
    }
}

