/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import de.cas_ual_ty.spells.Spells;
import de.cas_ual_ty.spells.spell.ISpell;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.spelltree.SpellTreeClass;
import de.cas_ual_ty.spells.util.SpellsFileUtil;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class SpellTreeSerializer {
    private static byte TYPE_FINISH = 0;
    private static byte TYPE_SPELL = 1;
    private static byte TYPE_UP = (byte)2;

    public static void encodeTree(SpellTree spellTree, FriendlyByteBuf buf) {
        buf.m_130077_(spellTree.getId());
        buf.m_130083_(spellTree.getTitle());
        buf.writeRegistryId(Spells.SPELLS_REGISTRY.get(), (Object)spellTree.getIconSpell());
        SpellNode spellNode = spellTree.getRoot();
        SpellTreeSerializer.encodeNode(spellNode, buf);
        for (SpellNode child : spellNode.getChildren()) {
            SpellTreeSerializer.encodeTreeRec(child, buf);
        }
        buf.writeByte((int)TYPE_FINISH);
    }

    private static void encodeTreeRec(SpellNode spellNode, FriendlyByteBuf buf) {
        buf.writeByte((int)TYPE_SPELL);
        SpellTreeSerializer.encodeNode(spellNode, buf);
        for (SpellNode child : spellNode.getChildren()) {
            SpellTreeSerializer.encodeTreeRec(child, buf);
        }
        buf.writeByte((int)TYPE_UP);
    }

    private static void encodeNode(SpellNode spellNode, FriendlyByteBuf buf) {
        buf.writeRegistryId(Spells.SPELLS_REGISTRY.get(), (Object)spellNode.getSpell());
        buf.writeInt(spellNode.getLevelCost());
        buf.writeByte(spellNode.getRequiredBookshelves());
    }

    public static SpellTree decodeTree(FriendlyByteBuf buf) {
        byte next;
        UUID id = buf.m_130259_();
        Component title = buf.m_130238_();
        ISpell icon = (ISpell)buf.readRegistryId();
        SpellTree.Builder builder = SpellTree.builder(id, SpellTreeSerializer.decodeNode(buf), title);
        while ((next = buf.readByte()) != TYPE_FINISH) {
            if (next == TYPE_SPELL) {
                builder.add(SpellTreeSerializer.decodeNode(buf));
                continue;
            }
            if (next == TYPE_UP) {
                builder.leaf();
                continue;
            }
            throw new IllegalStateException();
        }
        return builder.icon(icon).finish();
    }

    public static SpellNode decodeNode(FriendlyByteBuf buf) {
        ISpell spell = (ISpell)buf.readRegistryId();
        int levelCost = buf.readInt();
        byte requiredBookshelves = buf.readByte();
        return new SpellNode(spell, levelCost, requiredBookshelves);
    }

    private static JsonObject nodeToJsonRec(SpellNode node) {
        JsonObject json = new JsonObject();
        json.addProperty("spell", SpellsUtil.getSpellKey(node.getSpell()).toString());
        json.addProperty("levelCost", (Number)node.getLevelCost());
        json.addProperty("requiredBookshelves", (Number)node.getRequiredBookshelves());
        JsonArray children = new JsonArray();
        node.getChildren().forEach(child -> children.add((JsonElement)SpellTreeSerializer.nodeToJsonRec(child)));
        json.add("children", (JsonElement)children);
        return json;
    }

    public static JsonObject treeToJson(SpellTree tree) {
        JsonObject json = new JsonObject();
        json.addProperty("id", tree.getId().toString());
        json.add("title", Component.Serializer.m_130716_((Component)tree.getTitle()));
        json.addProperty("icon_spell", SpellsUtil.getSpellKey(tree.getIconSpell()).toString());
        json.add("root_spell", (JsonElement)(tree.getRoot() != null ? SpellTreeSerializer.nodeToJsonRec(tree.getRoot()) : JsonNull.INSTANCE));
        return json;
    }

    private static SpellNode nodeFromJson(JsonObject json) {
        ISpell spell = SpellsFileUtil.jsonSpell(json, "spell");
        int levelCost = SpellsFileUtil.jsonInt(json, "levelCost");
        int requiredBookshelves = SpellsFileUtil.jsonInt(json, "requiredBookshelves");
        JsonArray children = SpellsFileUtil.jsonArray(json, "children");
        SpellNode node = new SpellNode(spell, levelCost, requiredBookshelves);
        children.forEach(e -> SpellTree.connect(node, SpellTreeSerializer.nodeFromJson(e.getAsJsonObject())));
        return node;
    }

    public static SpellTree treeFromJson(JsonObject json) {
        UUID id = UUID.fromString(SpellsFileUtil.jsonString(json, "id"));
        MutableComponent title = Component.Serializer.m_130691_((JsonElement)SpellsFileUtil.jsonElement(json, "title"));
        ISpell icon = SpellsFileUtil.jsonSpell(json, "icon_spell");
        SpellNode root = SpellTreeSerializer.nodeFromJson(SpellsFileUtil.jsonObject(json, "root_spell"));
        return new SpellTree(id, root, (Component)title, icon);
    }

    public static SpellTreeClass classFromJson(JsonObject json) {
        SpellTreeClass c = new SpellTreeClass();
        JsonArray modifiers = SpellsFileUtil.jsonArray(json, "modifiers");
        for (JsonElement eModifier : modifiers) {
            AttributeModifier.Operation operation;
            if (!eModifier.isJsonObject()) {
                throw new IllegalStateException();
            }
            JsonObject modifier = eModifier.getAsJsonObject();
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(SpellsFileUtil.jsonString(modifier, "attribute")));
            if (attribute == null) {
                throw new IllegalStateException(new NullPointerException());
            }
            double amount = SpellsFileUtil.jsonDouble(modifier, "amount");
            try {
                operation = AttributeModifier.Operation.m_22236_((int)SpellsFileUtil.jsonInt(modifier, "operation"));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            String name = SpellsFileUtil.jsonString(modifier, "name");
            UUID id = SpellsUtil.generateUUIDForClassAttribute(attribute, name);
            c.addModifier(attribute, new AttributeModifier(id, name, amount, operation));
        }
        return c;
    }

    public static JsonObject classToJson(SpellTreeClass c) {
        JsonObject json = new JsonObject();
        JsonArray modifiers = new JsonArray();
        for (Map.Entry<Attribute, AttributeModifier> entry : c.modifiers.entrySet()) {
            JsonObject modifier = new JsonObject();
            modifier.addProperty("attribute", ForgeRegistries.ATTRIBUTES.getKey((Object)entry.getKey()).toString());
            modifier.addProperty("amount", (Number)entry.getValue().m_22218_());
            modifier.addProperty("operation", (Number)entry.getValue().m_22217_().m_22235_());
            modifier.addProperty("name", entry.getValue().m_22214_());
            modifier.addProperty("id", SpellsUtil.generateUUIDForClassAttribute(entry.getKey(), c.getName()).toString());
            modifiers.add((JsonElement)modifier);
        }
        json.add("modifiers", (JsonElement)modifiers);
        return json;
    }
}

