/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.context.BuiltinTargetGroups;
import de.cas_ual_ty.spells.spell.context.BuiltinVariables;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DelayedSpellHolder
implements INBTSerializable<ListTag> {
    public final Entity holder;
    private LinkedList<DelayedSpell> spells;

    public DelayedSpellHolder(Entity holder) {
        this.holder = holder;
        this.spells = new LinkedList();
    }

    private void activate(DelayedSpell spell) {
        this.activate(spell, spell.activation, ctx -> {}, ctx -> {});
    }

    private void activate(DelayedSpell spell, String activation, Consumer<SpellContext> toContext, Consumer<SpellContext> fromContext) {
        SpellInstance s = spell.spell;
        if (s != null && !activation.isEmpty()) {
            Consumer<SpellContext> toContextExt = ctx -> {
                ctx.getOrCreateTargetGroup(BuiltinTargetGroups.HOLDER.targetGroup).addTargets((Target)Target.of(this.holder));
                ctx.setCtxVar((CtxVarType)CtxVarTypes.INT.get(), BuiltinVariables.DELAY_TIME.name, spell.getTime());
                ctx.setCtxVar((CtxVarType)CtxVarTypes.TAG.get(), BuiltinVariables.DELAY_TAG.name, spell.tag);
                if (spell.uuid != null) {
                    ctx.setCtxVar((CtxVarType)CtxVarTypes.STRING.get(), BuiltinVariables.DELAY_UUID.name, spell.uuid.toString());
                }
                toContext.accept((SpellContext)ctx);
            };
            s.run(this.holder.f_19853_, null, activation, true, toContextExt, fromContext);
        }
    }

    public void addDelayedSpell(SpellInstance spell, UUID uuid, String activation, int tickTime, CompoundTag tag, Map<String, String> map) {
        this.spells.add(new DelayedSpell(spell, uuid, activation, tickTime, tag, map));
    }

    public boolean hasDelayedSpell(UUID uuid) {
        return uuid == null ? false : this.spells.stream().anyMatch(s -> uuid.equals(s.uuid));
    }

    public boolean removeDelayedSpell(UUID uuid, boolean forceActivate) {
        if (uuid == null) {
            return false;
        }
        LinkedList<DelayedSpell> theSpells = this.spells;
        this.spells = new LinkedList();
        Iterator iterator = theSpells.iterator();
        for (DelayedSpell spell : theSpells) {
            if (uuid.equals(spell.uuid)) {
                if (forceActivate) {
                    this.activate(spell);
                }
                return true;
            }
            this.spells.add(spell);
        }
        return false;
    }

    public void activateEvent(String event, Consumer<SpellContext> toContext, Consumer<SpellContext> fromContext) {
        LinkedList<DelayedSpell> theSpells = this.spells;
        this.spells = new LinkedList();
        for (DelayedSpell spell : theSpells) {
            String activation = spell.eventsMap.getOrDefault(event, null);
            if (activation != null) {
                this.activate(spell, activation, toContext, fromContext);
            }
            this.spells.add(spell);
        }
    }

    public void tick() {
        LinkedList<DelayedSpell> theSpells = this.spells;
        this.spells = new LinkedList();
        for (DelayedSpell spell : theSpells) {
            if (spell.tick()) {
                this.activate(spell);
                continue;
            }
            this.spells.add(spell);
        }
    }

    public Entity getHolder() {
        return this.holder;
    }

    public ListTag serializeNBT() {
        Registry<Spell> spellRegistry = Spells.getRegistry((LevelAccessor)this.holder.f_19853_);
        ListTag tag = new ListTag();
        this.spells.stream().map(ds -> ds.serializeNBT(spellRegistry)).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public void deserializeNBT(ListTag nbt) {
        Registry<SpellTree> spellTreeRegistry = SpellTrees.getRegistry((LevelAccessor)this.holder.f_19853_);
        Registry<Spell> spellRegistry = Spells.getRegistry((LevelAccessor)this.holder.f_19853_);
        nbt.stream().filter(t -> t instanceof CompoundTag).map(t -> new DelayedSpell((CompoundTag)t, spellTreeRegistry, spellRegistry)).filter(s -> s.spell != null).forEach(this.spells::add);
    }

    public static LazyOptional<DelayedSpellHolder> getHolder(Entity entity) {
        return entity.getCapability(SpellsCapabilities.DELAYED_SPELL_HOLDER_CAPABILITY).cast();
    }

    public static class DelayedSpell {
        public final SpellInstance spell;
        public final UUID uuid;
        public final String activation;
        public final int tickTime;
        public final CompoundTag tag;
        public final Map<String, String> eventsMap;
        private int time;

        public DelayedSpell(SpellInstance spell, UUID uuid, String activation, int tickTime, CompoundTag tag, Map<String, String> eventsMap) {
            this.spell = spell;
            this.uuid = uuid;
            this.activation = activation;
            this.tickTime = tickTime;
            this.tag = tag;
            this.eventsMap = eventsMap;
            this.time = 0;
        }

        public DelayedSpell(CompoundTag tag, Registry<SpellTree> spellTreeRegistry, Registry<Spell> spellRegistry) {
            this.spell = SpellInstance.fromNbt(tag, spellTreeRegistry, spellRegistry);
            this.uuid = tag.m_128403_("uuid") ? tag.m_128342_("uuid") : null;
            this.activation = tag.m_128461_("activation");
            this.tickTime = tag.m_128451_("maxTime");
            this.tag = tag.m_128469_("tag");
            this.eventsMap = new HashMap<String, String>();
            CompoundTag map = tag.m_128469_("map");
            for (String key : map.m_128431_()) {
                this.eventsMap.put(key, map.m_128461_(key));
            }
            this.time = tag.m_128451_("time");
        }

        public boolean tick() {
            if (!this.spell.getSpell().m_203633_()) {
                return false;
            }
            return ++this.time >= this.tickTime;
        }

        public int getTime() {
            return this.time;
        }

        public CompoundTag serializeNBT(Registry<Spell> spellRegistry) {
            CompoundTag tag = new CompoundTag();
            this.spell.toNbt(tag, spellRegistry);
            if (this.uuid != null) {
                tag.m_128362_("uuid", this.uuid);
            }
            tag.m_128359_("activation", this.activation);
            tag.m_128405_("maxTime", this.tickTime);
            tag.m_128365_("tag", (Tag)this.tag);
            CompoundTag map = new CompoundTag();
            this.eventsMap.forEach((arg_0, arg_1) -> ((CompoundTag)map).m_128359_(arg_0, arg_1));
            tag.m_128365_("map", (Tag)map);
            tag.m_128405_("time", this.time);
            return tag;
        }
    }
}

