/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.network.ParticleEmitterSyncMessage;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleEmitterHolder
implements INBTSerializable<ListTag> {
    public final Entity holder;
    private LinkedList<ParticleEmitter> list;

    public ParticleEmitterHolder(Entity holder) {
        this.holder = holder;
        this.list = new LinkedList();
    }

    public void addParticleEmitter(ParticleEmitter emitter) {
        if (!this.holder.f_19853_.f_46443_) {
            this.sendSync(emitter);
        }
        this.list.add(emitter);
    }

    public void clear() {
        this.list.clear();
    }

    public void tick(boolean emit) {
        LinkedList<ParticleEmitter> newList = new LinkedList<ParticleEmitter>();
        for (ParticleEmitter e : this.list) {
            if (e.tick() && emit) {
                for (int i = 0; i < e.amount; ++i) {
                    Vec3 pos = this.holder.m_20182_().m_82549_(e.offset).m_82549_(e.motionSpread ? this.holder.m_20184_().m_82490_((double)i / (double)e.amount) : Vec3.f_82478_);
                    double x = pos.f_82479_ + (SpellsUtil.RANDOM.m_188500_() - 0.5) * e.spread;
                    double y = pos.f_82480_ + (SpellsUtil.RANDOM.m_188500_() - 0.5) * e.spread;
                    double z = pos.f_82481_ + (SpellsUtil.RANDOM.m_188500_() - 0.5) * e.spread;
                    this.holder.f_19853_.m_7106_(e.particle, x, y, z, 0.0, 0.0, 0.0);
                }
            }
            if (e.remove()) continue;
            newList.add(e);
        }
        this.list = newList;
    }

    public Entity getHolder() {
        return this.holder;
    }

    public ListTag serializeNBT() {
        Registry<Spell> spellRegistry = Spells.getRegistry((LevelAccessor)this.holder.f_19853_);
        ListTag tag = new ListTag();
        this.list.stream().map(ParticleEmitter::serializeNBT).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public void deserializeNBT(ListTag nbt) {
        nbt.stream().filter(t -> t instanceof CompoundTag).map(t -> new ParticleEmitter((CompoundTag)t)).filter(e -> e.particle != null).forEach(this.list::add);
    }

    public ParticleEmitterSyncMessage makeSyncMessage() {
        return new ParticleEmitterSyncMessage(this.holder.m_19879_(), true, this.list);
    }

    public void sendSync(ParticleEmitter emitter) {
        SpellsAndShields.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.holder), (Object)new ParticleEmitterSyncMessage(this.holder.m_19879_(), false, (List<ParticleEmitter>)ImmutableList.of((Object)emitter)));
    }

    public static LazyOptional<ParticleEmitterHolder> getHolder(Entity entity) {
        return entity.getCapability(SpellsCapabilities.PARTICLE_EMITTER_HOLDER_CAPABILITY).cast();
    }

    public static class ParticleEmitter {
        public final int duration;
        public final int delay;
        public final int amount;
        public final double spread;
        public final boolean motionSpread;
        public final Vec3 offset;
        public final ParticleOptions particle;
        private int time;

        public ParticleEmitter(int duration, int delay, int amount, double spread, boolean motionSpread, Vec3 offset, ParticleOptions particle, int time) {
            this.duration = duration;
            this.delay = delay;
            this.amount = amount;
            this.spread = spread;
            this.motionSpread = motionSpread;
            this.offset = offset;
            this.particle = particle;
            this.time = time;
        }

        public ParticleEmitter(int duration, int delay, int amount, double spread, boolean motionSpread, Vec3 offset, ParticleOptions particle) {
            this(duration, delay, amount, spread, motionSpread, offset, particle, duration);
        }

        public ParticleEmitter(CompoundTag tag) {
            this(tag.m_128451_("duration"), tag.m_128451_("delay"), tag.m_128451_("amount"), tag.m_128459_("spread"), tag.m_128471_("motionSpread"), new Vec3(tag.m_128459_("offX"), tag.m_128459_("offY"), tag.m_128459_("offZ")), (ParticleOptions)ParticleTypes.f_123791_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("particle")).get().map(Pair::getFirst, o -> null), tag.m_128451_("time"));
        }

        public boolean tick() {
            return this.time-- % this.delay == 0;
        }

        public boolean remove() {
            return this.time <= 0;
        }

        public int getTime() {
            return this.time;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("duration", this.duration);
            tag.m_128405_("delay", this.delay);
            tag.m_128405_("amount", this.amount);
            tag.m_128347_("spread", this.spread);
            tag.m_128379_("motionSpread", this.motionSpread);
            tag.m_128347_("offX", this.offset.f_82479_);
            tag.m_128347_("offY", this.offset.f_82480_);
            tag.m_128347_("offZ", this.offset.f_82481_);
            tag.m_128365_("particle", (Tag)ParticleTypes.f_123791_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.particle).get().map(t -> t, o -> new CompoundTag()));
            tag.m_128405_("time", this.time);
            return tag;
        }

        public void toByteBuf(FriendlyByteBuf buf) {
            buf.writeInt(this.duration);
            buf.writeShort(this.delay);
            buf.writeByte(this.amount);
            buf.writeFloat((float)this.spread);
            buf.writeBoolean(this.motionSpread);
            buf.writeFloat((float)this.offset.f_82479_);
            buf.writeFloat((float)this.offset.f_82480_);
            buf.writeFloat((float)this.offset.f_82481_);
            buf.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, (Object)this.particle.m_6012_());
            this.particle.m_7711_(buf);
            buf.writeInt(this.time);
        }

        public static <P extends ParticleOptions> ParticleEmitter fromByteBuf(FriendlyByteBuf buf) {
            int duration = buf.readInt();
            short delay = buf.readShort();
            byte amount = buf.readByte();
            double spread = buf.readFloat();
            boolean motionSpread = buf.readBoolean();
            Vec3 offset = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            ParticleType particleType = (ParticleType)buf.readRegistryId();
            ParticleOptions particle = particleType.m_123743_().m_6507_(particleType, buf);
            int time = buf.readInt();
            return new ParticleEmitter(duration, delay, amount, spread, motionSpread, offset, particle, time);
        }

        public String toString() {
            return "ParticleEmitter{duration=" + this.duration + ", delay=" + this.delay + ", amount=" + this.amount + ", spread=" + this.spread + ", motionSpread=" + this.motionSpread + ", offset=" + this.offset + ", particle=" + this.particle + ", time=" + this.time + "}";
        }
    }
}

