/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.network.SpellsSyncMessage;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spell.context.BuiltinEvents;
import de.cas_ual_ty.spells.spell.context.BuiltinVariables;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class SpellHolder
implements INBTSerializable<ListTag> {
    public static final int SPELL_SLOTS = 5;
    public static final String EMPTY_SLOT = "";
    protected final SpellInstance[] slots = new SpellInstance[5];
    protected final Player player;

    public SpellHolder(Player player) {
        this.player = player;
    }

    public int getSlots() {
        return 5;
    }

    public SpellInstance getSpell(int slot) {
        return this.slots[slot];
    }

    public void setSpell(int slot, @Nullable SpellInstance spell) {
        if (!this.player.f_19853_.f_46443_) {
            if (this.slots[slot] != null) {
                this.slots[slot].run(this.player.f_19853_, this.player, BuiltinEvents.ON_UNEQUIP.activation, ctx -> ctx.setCtxVar((CtxVarType)CtxVarTypes.INT.get(), BuiltinVariables.SPELL_SLOT.name, slot));
            }
            if (spell != null) {
                spell.run(this.player.f_19853_, this.player, BuiltinEvents.ON_EQUIP.activation, ctx -> ctx.setCtxVar((CtxVarType)CtxVarTypes.INT.get(), BuiltinVariables.SPELL_SLOT.name, slot));
            }
        }
        this.slots[slot] = spell;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void activateAll(String activation) {
        for (int i = 0; i < this.getSlots(); ++i) {
            SpellInstance s = this.getSpell(i);
            if (s == null) continue;
            int slot = i;
            s.run(this.player.f_19853_, this.player, activation, ctx -> ctx.setCtxVar((CtxVarType)CtxVarTypes.INT.get(), BuiltinVariables.SPELL_SLOT.name, slot));
        }
    }

    public int getAmountSpellEquipped(Spell spell) {
        int amount = 0;
        for (int i = 0; i < 5; ++i) {
            SpellInstance spellInstance = this.getSpell(i);
            if (spellInstance == null || spellInstance.getSpell().get() != spell) continue;
            ++amount;
        }
        return amount;
    }

    public void removeSpell(int slot) {
        this.setSpell(slot, null);
    }

    public void clear() {
        for (int i = 0; i < 5; ++i) {
            this.removeSpell(i);
        }
    }

    public SpellsSyncMessage makeSyncMessage() {
        Registry<Spell> registry = Spells.getRegistry((LevelAccessor)this.player.m_9236_());
        return new SpellsSyncMessage(this.player.m_19879_(), (ResourceLocation[])Arrays.stream(this.slots).map(s -> s != null ? (ResourceLocation)s.getSpell().m_203439_().map(ResourceKey::m_135782_, arg_0 -> ((Registry)registry).m_7981_(arg_0)) : null).toArray(ResourceLocation[]::new));
    }

    public ListTag serializeNBT() {
        Registry<Spell> spellRegistry = Spells.getRegistry((LevelAccessor)this.player.m_9236_());
        ListTag list = new ListTag();
        for (int i = 0; i < 5; ++i) {
            CompoundTag tag = new CompoundTag();
            if (this.slots[i] != null) {
                this.slots[i].toNbt(tag, spellRegistry);
            }
            list.add(i, (Tag)tag);
        }
        return list;
    }

    public void deserializeNBT(ListTag tag) {
        Registry<SpellTree> spellTreeRegistry = SpellTrees.getRegistry((LevelAccessor)this.player.m_9236_());
        Registry<Spell> spellRegistry = Spells.getRegistry((LevelAccessor)this.player.m_9236_());
        if (tag.m_7264_() != 10) {
            return;
        }
        for (int i = 0; i < 5 && i < tag.size(); ++i) {
            this.slots[i] = SpellInstance.fromNbt(tag.m_128728_(i), spellTreeRegistry, spellRegistry);
        }
    }

    public void sendSync() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SpellsAndShields.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)this.makeSyncMessage());
        }
    }

    public static LazyOptional<SpellHolder> getSpellHolder(Player player) {
        return player.getCapability(SpellsCapabilities.SPELLS_CAPABILITY).cast();
    }
}

