/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.capability.SpellsCapabilities;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SpellProgressionHolder
implements INBTSerializable<ListTag> {
    public static final String KEY_SPELL_STATUS = "spell_status";
    protected final Player player;
    protected final HashMap<SpellNodeId, SpellStatus> progression;

    public SpellProgressionHolder(Player player) {
        this.player = player;
        this.progression = new HashMap();
    }

    public boolean isSpellAvailable(SpellNodeId spell) {
        return this.getSpellStatus(spell) == SpellStatus.LEARNED;
    }

    public SpellStatus getSpellStatus(SpellNodeId spell) {
        return this.progression.getOrDefault(spell, SpellStatus.LOCKED);
    }

    public void setSpellStatus(SpellNodeId spell, SpellStatus spellStatus) {
        this.progression.put(spell, spellStatus);
    }

    public ListTag serializeNBT() {
        Registry<Spell> registry = Spells.getRegistry((LevelAccessor)this.player.m_9236_());
        ListTag list = new ListTag();
        for (Map.Entry<SpellNodeId, SpellStatus> entry : this.progression.entrySet()) {
            CompoundTag tag = new CompoundTag();
            entry.getKey().toNbt(tag);
            tag.m_128344_(KEY_SPELL_STATUS, (byte)entry.getValue().ordinal());
            list.add((Object)tag);
        }
        return list;
    }

    public void deserializeNBT(ListTag nbt) {
        this.progression.clear();
        if (nbt.m_7264_() != 10) {
            return;
        }
        Registry<Spell> registry = Spells.getRegistry((LevelAccessor)this.player.m_9236_());
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag = nbt.m_128728_(i);
            if (!tag.m_128441_(KEY_SPELL_STATUS) || tag.m_128423_(KEY_SPELL_STATUS).m_7060_() != 1) continue;
            SpellNodeId spellNodeId = SpellNodeId.fromNbt(tag);
            byte ordinal = tag.m_128445_(KEY_SPELL_STATUS);
            if (spellNodeId == null || ordinal < 0 || ordinal >= SpellStatus.values().length) continue;
            this.progression.put(spellNodeId, SpellStatus.values()[ordinal]);
        }
    }

    public HashMap<SpellNodeId, SpellStatus> getProgression() {
        return this.progression;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static LazyOptional<SpellProgressionHolder> getSpellProgressionHolder(Player player) {
        return player.getCapability(SpellsCapabilities.SPELL_PROGRESSION_CAPABILITY).cast();
    }
}

