/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.capability;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.SpellsConfig;
import de.cas_ual_ty.spells.capability.DelayedSpellHolder;
import de.cas_ual_ty.spells.capability.ExtraTagHolder;
import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.capability.ParticleEmitterHolder;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.spell.context.BuiltinEvents;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import java.util.LinkedList;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;

public class SpellsCapabilities {
    public static Capability<ManaHolder> MANA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ManaHolder>(){});
    public static Capability<SpellHolder> SPELLS_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<SpellHolder>(){});
    public static Capability<SpellProgressionHolder> SPELL_PROGRESSION_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<SpellProgressionHolder>(){});
    public static Capability<ExtraTagHolder> EXTRA_TAG_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ExtraTagHolder>(){});
    public static Capability<DelayedSpellHolder> DELAYED_SPELL_HOLDER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DelayedSpellHolder>(){});
    public static Capability<ParticleEmitterHolder> PARTICLE_EMITTER_HOLDER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ParticleEmitterHolder>(){});

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ManaHolder.class);
        event.register(SpellHolder.class);
        event.register(SpellProgressionHolder.class);
        event.register(ExtraTagHolder.class);
        event.register(DelayedSpellHolder.class);
        event.register(ParticleEmitterHolder.class);
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            ManaHolder manaHolder = new ManaHolder((LivingEntity)player);
            SpellsCapabilities.attachCapability(event, manaHolder, MANA_CAPABILITY, "mana_holder");
            SpellHolder spellHolder = new SpellHolder(player);
            SpellsCapabilities.attachCapability(event, spellHolder, SPELLS_CAPABILITY, "spell_holder");
            SpellProgressionHolder spellProgressionHolder = new SpellProgressionHolder(player);
            SpellsCapabilities.attachCapability(event, spellProgressionHolder, SPELL_PROGRESSION_CAPABILITY, "spell_progression_holder");
        }
        ExtraTagHolder extraTagHolder = new ExtraTagHolder();
        SpellsCapabilities.attachCapability(event, extraTagHolder, EXTRA_TAG_CAPABILITY, "extra_tag_holder");
        DelayedSpellHolder delayedSpellHolder = new DelayedSpellHolder((Entity)event.getObject());
        SpellsCapabilities.attachCapability(event, delayedSpellHolder, DELAYED_SPELL_HOLDER_CAPABILITY, "delayed_spell_holder");
        ParticleEmitterHolder particleEmitterHolder = new ParticleEmitterHolder((Entity)event.getObject());
        SpellsCapabilities.attachCapability(event, particleEmitterHolder, PARTICLE_EMITTER_HOLDER_CAPABILITY, "particle_emitter_holder");
    }

    private static <T extends Tag, C extends INBTSerializable<T>> void attachCapability(AttachCapabilitiesEvent<?> event, final C capData, final Capability<C> capability, String name) {
        final LazyOptional optional = LazyOptional.of(() -> capData);
        ICapabilitySerializable provider = new ICapabilitySerializable<T>(){

            public <S> LazyOptional<S> getCapability(Capability<S> cap, Direction side) {
                if (cap == capability) {
                    return optional.cast();
                }
                return LazyOptional.empty();
            }

            public T serializeNBT() {
                return capData.serializeNBT();
            }

            public void deserializeNBT(T tag) {
                capData.deserializeNBT(tag);
            }
        };
        event.addCapability(new ResourceLocation("spells_and_shields", name), (ICapabilityProvider)provider);
    }

    private static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        if (!event.isWasDeath()) {
            SpellProgressionHolder.getSpellProgressionHolder(event.getEntity()).ifPresent(current -> SpellProgressionHolder.getSpellProgressionHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT())));
            ManaHolder.getManaHolder((LivingEntity)event.getEntity()).ifPresent(current -> {
                ManaHolder.getManaHolder((LivingEntity)event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                current.sendSync();
            });
            SpellHolder.getSpellHolder(event.getEntity()).ifPresent(current -> {
                SpellHolder.getSpellHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                current.sendSync();
            });
            ExtraTagHolder.getHolder((Entity)event.getEntity()).ifPresent(current -> ExtraTagHolder.getHolder((Entity)event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT())));
            DelayedSpellHolder.getHolder((Entity)event.getEntity()).ifPresent(current -> DelayedSpellHolder.getHolder((Entity)event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT())));
            ParticleEmitterHolder.getHolder((Entity)event.getEntity()).ifPresent(current -> ParticleEmitterHolder.getHolder((Entity)event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT())));
        } else {
            SpellProgressionHolder.getSpellProgressionHolder(event.getEntity()).ifPresent(current -> {
                SpellProgressionHolder.getSpellProgressionHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                if (((Boolean)SpellsConfig.FORGET_SPELLS_ON_DEATH.get()).booleanValue()) {
                    for (SpellNodeId key : current.getProgression().keySet()) {
                        if (current.getSpellStatus(key) != SpellStatus.LEARNED) continue;
                        current.setSpellStatus(key, SpellStatus.FORGOTTEN);
                    }
                }
            });
            ManaHolder.getManaHolder((LivingEntity)event.getEntity()).ifPresent(manaHolder -> {
                if (((Boolean)SpellsConfig.RESPAWN_WITH_FULL_MANA.get()).booleanValue()) {
                    manaHolder.replenish(manaHolder.getMaxMana());
                }
                manaHolder.sendSync();
            });
            if (!((Boolean)SpellsConfig.CLEAR_SLOTS_ON_DEATH.get()).booleanValue() && !((Boolean)SpellsConfig.FORGET_SPELLS_ON_DEATH.get()).booleanValue()) {
                SpellHolder.getSpellHolder(event.getEntity()).ifPresent(current -> {
                    SpellHolder.getSpellHolder(event.getOriginal()).ifPresent(original -> current.deserializeNBT(original.serializeNBT()));
                    current.sendSync();
                    current.activateAll(BuiltinEvents.ON_EQUIP.activation);
                });
            }
        }
        event.getOriginal().invalidateCaps();
    }

    private static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ManaHolder.getManaHolder((LivingEntity)player2).ifPresent(ManaHolder::sendSync);
            SpellHolder.getSpellHolder((Player)player2).ifPresent(SpellHolder::sendSync);
        }
    }

    private static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ManaHolder.getManaHolder((LivingEntity)player2).ifPresent(ManaHolder::sendSync);
            SpellHolder.getSpellHolder((Player)player2).ifPresent(SpellHolder::sendSync);
        }
    }

    private static void playerChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ManaHolder.getManaHolder((LivingEntity)player2).ifPresent(ManaHolder::sendSync);
            SpellHolder.getSpellHolder((Player)player2).ifPresent(SpellHolder::sendSync);
        }
    }

    private static void startTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ParticleEmitterHolder.getHolder(event.getTarget()).ifPresent(particleEmitterHolder -> SpellsAndShields.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)particleEmitterHolder.makeSyncMessage()));
            Entity entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ManaHolder.getManaHolder(livingEntity).ifPresent(manaHolder -> SpellsAndShields.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)manaHolder.makeSyncMessage()));
                if (livingEntity instanceof Player) {
                    Player target = (Player)livingEntity;
                    SpellHolder.getSpellHolder(target).ifPresent(spellHolder -> SpellsAndShields.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)spellHolder.makeSyncMessage()));
                }
            }
        }
    }

    private static void levelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LinkedList<Entity> entities = new LinkedList<Entity>();
            for (Entity e2 : level2.m_8583_()) {
                if (e2 == null) continue;
                entities.add(e2);
            }
            entities.forEach(e -> {
                DelayedSpellHolder.getHolder(e).ifPresent(DelayedSpellHolder::tick);
                ParticleEmitterHolder.getHolder(e).ifPresent(h -> h.tick(false));
            });
        }
    }

    private static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.f_46443_) {
            ManaHolder.getManaHolder((LivingEntity)event.player).ifPresent(ManaHolder::tick);
        }
    }

    public static void registerEvents() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellsCapabilities::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, SpellsCapabilities::attachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerClone);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerRespawn);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerChangedDimensions);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::startTracking);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::levelTick);
        MinecraftForge.EVENT_BUS.addListener(SpellsCapabilities::playerTick);
    }
}

