/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.capability.ParticleEmitterHolder;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.client.SpellsClientUtil;
import de.cas_ual_ty.spells.client.progression.SpellProgressionScreen;
import de.cas_ual_ty.spells.network.ManaSyncMessage;
import de.cas_ual_ty.spells.network.ParticleEmitterSyncMessage;
import de.cas_ual_ty.spells.network.RunActionOnClientMessage;
import de.cas_ual_ty.spells.network.SpellProgressionSyncMessage;
import de.cas_ual_ty.spells.network.SpellsSyncMessage;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;

public class ClientMessageHandler {
    public static void handleManaSync(ManaSyncMessage msg) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(msg.entityId())) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ManaHolder.getManaHolder(livingEntity).ifPresent(manaHolder -> {
                if (manaHolder.changeTime == -1) {
                    manaHolder.setMana(msg.mana());
                    manaHolder.setExtraMana(msg.extraMana());
                    manaHolder.changeTime = 0;
                } else {
                    manaHolder.setMana(msg.mana());
                    manaHolder.setExtraMana(msg.extraMana());
                }
            });
        }
    }

    public static void handleSpellsSync(SpellsSyncMessage msg) {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(msg.entityId())) instanceof Player) {
            Player player = (Player)entity;
            Registry<Spell> registry = Spells.getRegistry((LevelAccessor)player.f_19853_);
            SpellHolder.getSpellHolder(player).ifPresent(spellHolder -> {
                for (int i = 0; i < spellHolder.getSlots() && i < msg.spells().length; ++i) {
                    if (msg.spells()[i] != null) {
                        spellHolder.setSpell(i, new SpellInstance((Holder<Spell>)registry.m_206081_(ResourceKey.m_135785_(Spells.REGISTRY_KEY, (ResourceLocation)msg.spells()[i]))));
                        continue;
                    }
                    spellHolder.setSpell(i, null);
                }
            });
        }
    }

    public static void handleSpellProgressionSync(SpellProgressionSyncMessage msg) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof SpellProgressionScreen) {
            SpellProgressionScreen screen2 = (SpellProgressionScreen)screen;
            ((SpellProgressionMenu)screen2.m_6262_()).spellTrees = msg.spellTrees();
            ((SpellProgressionMenu)screen2.m_6262_()).spellProgression = msg.map();
            screen2.spellTreesUpdated();
        }
    }

    public static void handleParticleEmitterSync(ParticleEmitterSyncMessage msg) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(msg.entityId());
        if (entity == null) {
            return;
        }
        ParticleEmitterHolder.getHolder(entity).ifPresent(holder -> {
            if (msg.clear()) {
                holder.clear();
            }
            msg.list().forEach(holder::addParticleEmitter);
        });
    }

    public static void handleSpellAction(RunActionOnClientMessage msg) {
        if (msg.action() != null) {
            msg.action().execute(SpellsClientUtil.getClientLevel(), SpellsClientUtil.getClientPlayer());
        }
    }
}

