/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScreenDebugHelper {
    public static void event(ScreenEvent.Render.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen s = (AbstractContainerScreen)screen;
            if (event.getScreen() instanceof InventoryScreen || event.getScreen() instanceof CreativeModeInventoryScreen) {
                ScreenDebugHelper.cross(event.getPoseStack(), s.f_96543_ / 2, s.f_96544_ / 2, -1, (Screen)s);
                ScreenDebugHelper.drawBounds(event.getPoseStack(), s);
                ScreenDebugHelper.cross(event.getPoseStack(), event.getMouseX(), event.getMouseY(), -16711936, (Screen)s);
                Font font = Minecraft.m_91087_().f_91062_;
                font.m_92883_(event.getPoseStack(), event.getMouseX() + "/" + event.getMouseY(), (float)event.getMouseX(), (float)event.getMouseY(), -1);
            }
        }
    }

    public static void hLine(PoseStack poseStack, int minX, int maxX, int y, int color) {
        if (maxX < minX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        GuiComponent.m_93172_((PoseStack)poseStack, (int)minX, (int)y, (int)(maxX + 1), (int)(y + 1), (int)color);
    }

    public static void vLine(PoseStack poseStack, int x, int minY, int maxY, int color) {
        if (maxY < minY) {
            int i = minY;
            minY = maxY;
            maxY = i;
        }
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)(minY + 1), (int)(x + 1), (int)maxY, (int)color);
    }

    public static void hLine(PoseStack poseStack, int y, int color, Screen screen) {
        ScreenDebugHelper.hLine(poseStack, 0, screen.f_96543_, y, color);
    }

    public static void vLine(PoseStack poseStack, int x, int color, Screen screen) {
        ScreenDebugHelper.vLine(poseStack, x, 0, screen.f_96544_, color);
    }

    public static void cross(PoseStack poseStack, int x, int y, int color, Screen screen) {
        ScreenDebugHelper.hLine(poseStack, y, color, screen);
        ScreenDebugHelper.vLine(poseStack, x, color, screen);
    }

    public static void drawBounds(PoseStack poseStack, AbstractContainerScreen screen) {
        ScreenDebugHelper.hLine(poseStack, screen.getGuiTop(), -16776961, (Screen)screen);
        ScreenDebugHelper.hLine(poseStack, screen.getGuiTop() + screen.getYSize(), -16776961, (Screen)screen);
        ScreenDebugHelper.vLine(poseStack, screen.getGuiLeft(), -65536, (Screen)screen);
        ScreenDebugHelper.vLine(poseStack, screen.getGuiLeft() + screen.getXSize(), -65536, (Screen)screen);
    }
}

