/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

public enum SlotsPosition {
    TL_DOWN(0),
    L(1),
    BL_UP(2),
    BL_RIGHT(3),
    B(4),
    BR_LEFT(5),
    BR_UP(6),
    R(7),
    TR_DOWN(8),
    TR_LEFT(9),
    T(10),
    TL_RIGHT(11),
    EDGE_TL_DOWN(12),
    EDGE_L(13),
    EDGE_BL_UP(14),
    EDGE_BL_RIGHT(15),
    EDGE_B(16),
    EDGE_BR_LEFT(17),
    EDGE_BR_UP(18),
    EDGE_R(19),
    EDGE_TR_DOWN(20),
    EDGE_TR_LEFT(21),
    EDGE_T(22),
    EDGE_TL_RIGHT(23);

    public static final int GROUP_AMT = 12;
    public final int id;
    public final boolean atScreenEdge;
    public final boolean isHorizontal;
    public final boolean isVertical;
    public final boolean isLeft;
    public final boolean isRight;
    public final boolean isTop;
    public final boolean isBottom;
    public final boolean isDownwards;
    public final boolean isUpwards;
    public final boolean isRightwards;
    public final boolean isLeftwards;
    public final boolean isCentered;

    private SlotsPosition(int id) {
        this.id = id;
        this.atScreenEdge = id >= 12;
        this.isVertical = (id %= 12) % 6 < 3;
        this.isHorizontal = !this.isVertical;
        this.isLeft = id <= 3 || id == 11;
        this.isRight = id >= 5 && id <= 9;
        this.isTop = id == 0 || id >= 8;
        this.isBottom = id >= 2 && id <= 6;
        this.isDownwards = id == 0 || id == 8;
        this.isUpwards = id == 2 || id == 6;
        this.isRightwards = id == 3 || id == 11;
        this.isLeftwards = id == 5 || id == 9;
        this.isCentered = id % 3 == 1;
    }

    public SlotsPosition transform() {
        if (this.id >= 12) {
            return SlotsPosition.fromId(this.id % 12);
        }
        return SlotsPosition.fromId(this.id + 12);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int startPositionX(int screenWidth, int screenHeight, int guiLeft, int guiTop, int guiWidth, int guiHeight, int frameWidth, int frameHeight, int frames, int margin) {
        if (this.atScreenEdge) {
            if (this.isVertical) {
                if (this.isLeft) {
                    return margin;
                }
                if (!this.isRight) return -1;
                return screenWidth - (frameWidth + margin);
            }
            if (this.isLeft) {
                return margin;
            }
            if (!this.isRight) return (screenWidth - frames * (frameWidth + margin) + margin) / 2;
            return screenWidth - frames * (frameWidth + margin);
        }
        if (this.isVertical) {
            if (this.isLeft) {
                return guiLeft - (frameWidth + margin);
            }
            if (!this.isRight) return -1;
            return guiLeft + guiWidth + margin;
        }
        if (this.isLeft) {
            return guiLeft;
        }
        if (!this.isRight) return guiLeft + (guiWidth - frames * (frameWidth + margin) + margin) / 2;
        return guiLeft + guiWidth - frames * (frameWidth + margin) + margin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int startPositionY(int screenWidth, int screenHeight, int guiLeft, int guiTop, int guiWidth, int guiHeight, int frameWidth, int frameHeight, int frames, int margin) {
        if (this.atScreenEdge) {
            if (this.isHorizontal) {
                if (this.isTop) {
                    return margin;
                }
                if (!this.isBottom) return -1;
                return screenHeight - (frameHeight + margin);
            }
            if (this.isTop) {
                return margin;
            }
            if (!this.isBottom) return (screenHeight - frames * (frameHeight + margin) + margin) / 2;
            return screenHeight - frames * (frameHeight + margin);
        }
        if (this.isHorizontal) {
            if (this.isTop) {
                return guiTop - (frameHeight + margin);
            }
            if (!this.isBottom) return -1;
            return guiTop + guiHeight + margin;
        }
        if (this.isTop) {
            return guiTop;
        }
        if (!this.isBottom) return guiTop + (guiHeight - frames * (frameHeight + margin) + margin) / 2;
        return guiTop + guiHeight - frames * (frameHeight + margin) + margin;
    }

    public int incrementX(int frameWidth, int frameHeight, int margin) {
        return this.isHorizontal ? frameWidth + margin : 0;
    }

    public int incrementY(int frameWidth, int frameHeight, int margin) {
        return this.isVertical ? frameHeight + margin : 0;
    }

    public static SlotsPosition fromId(int id) {
        return SlotsPosition.values()[id];
    }
}

