/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cas_ual_ty.spells.registers.SpellIconTypes;
import de.cas_ual_ty.spells.spell.icon.AdvancedSpellIcon;
import de.cas_ual_ty.spells.spell.icon.DefaultSpellIcon;
import de.cas_ual_ty.spells.spell.icon.ItemSpellIcon;
import de.cas_ual_ty.spells.spell.icon.LayeredSpellIcon;
import de.cas_ual_ty.spells.spell.icon.SizedSpellIcon;
import de.cas_ual_ty.spells.spell.icon.SpellIcon;
import de.cas_ual_ty.spells.spell.icon.SpellIconType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class SpellIconRegistry {
    private static final DefaultSpellIcon ERROR_FALLBACK = new DefaultSpellIcon((SpellIconType)SpellIconTypes.DEFAULT.get(), new ResourceLocation("spells_and_shields", "textures/spell/default_fallback.png"));
    public static final SpellIconRenderer<DefaultSpellIcon> DEFAULT_RENDERER = (icon, poseStack, width, height, x, y, partialTicks) -> {
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon.getTexture());
        RenderSystem.m_69478_();
        int offX = (width - 18) / 2;
        int offY = (height - 18) / 2;
        GuiComponent.m_93160_((PoseStack)poseStack, (int)(x + offX), (int)(y + offY), (int)18, (int)18, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        RenderSystem.m_69461_();
    };
    public static final SpellIconRenderer<SizedSpellIcon> SIZED_RENDERER = (icon, poseStack, width, height, x, y, partialTicks) -> {
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon.getTexture());
        RenderSystem.m_69478_();
        int offX = (width - icon.getSize()) / 2;
        int offY = (height - icon.getSize()) / 2;
        GuiComponent.m_93160_((PoseStack)poseStack, (int)(x + offX), (int)(y + offY), (int)icon.getSize(), (int)icon.getSize(), (float)0.0f, (float)0.0f, (int)icon.getSize(), (int)icon.getSize(), (int)icon.getSize(), (int)icon.getSize());
        RenderSystem.m_69461_();
    };
    public static final SpellIconRenderer<ItemSpellIcon> ITEM_RENDERER = (icon, poseStack, width, height, x, y, partialTicks) -> {
        RenderSystem.m_69478_();
        Minecraft.m_91087_().m_91291_().m_115203_(icon.getItem(), x + (width - 16) / 2, y + (width - 16) / 2);
        RenderSystem.m_69461_();
    };
    public static final SpellIconRenderer<AdvancedSpellIcon> ADVANCED_RENDERER = (icon, poseStack, width, height, x, y, partialTicks) -> {
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon.getTexture());
        RenderSystem.m_69478_();
        int offX = (width - icon.getWidth()) / 2 + icon.getOffsetX();
        int offY = (height - icon.getHeight()) / 2 + icon.getOffsetY();
        GuiComponent.m_93160_((PoseStack)poseStack, (int)(x + offX), (int)(y + offY), (int)icon.getWidth(), (int)icon.getHeight(), (float)icon.getU(), (float)icon.getV(), (int)icon.getWidth(), (int)icon.getHeight(), (int)icon.getTextureWidth(), (int)icon.getTextureHeight());
        RenderSystem.m_69461_();
    };
    public static final SpellIconRenderer<LayeredSpellIcon> LAYERED_RENDERER = (icon, poseStack, width, height, x, y, partialTicks) -> {
        for (SpellIcon i : icon.getList()) {
            SpellIconRegistry.render(i, poseStack, width, height, x, y, partialTicks);
        }
    };
    public static final SpellIconRenderer<DefaultSpellIcon> ERROR_FALLBACK_RENDERER = (icon, poseStack, width, height, x, y, partialTicks) -> DEFAULT_RENDERER.render(ERROR_FALLBACK, poseStack, width, height, x, y, partialTicks);
    private static Map<SpellIconType<?>, SpellIconRenderer<?>> rendererMap = new HashMap();

    public static <I extends SpellIcon> void register(SpellIconType<I> iconType, SpellIconRenderer<I> renderer) {
        rendererMap.put(iconType, renderer);
    }

    public static <I extends SpellIcon> void render(I icon, PoseStack poseStack, int frameWidth, int frameHeight, int x, int y, float partialTicks) {
        SpellIconRenderer<DefaultSpellIcon> renderer = rendererMap.getOrDefault(icon.type, ERROR_FALLBACK_RENDERER);
        renderer.render((DefaultSpellIcon)icon, poseStack, frameWidth, frameHeight, x, y, partialTicks);
    }

    public static interface SpellIconRenderer<I extends SpellIcon> {
        public void render(I var1, PoseStack var2, int var3, int var4, int var5, int var6, float var7);
    }
}

