/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SpellArgument
implements ArgumentType<Spell> {
    public static final SimpleCommandExceptionType UNKNOWN_SPELL = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.spell.id.invalid"));
    private final HolderLookup<Spell> spells;

    public SpellArgument(CommandBuildContext cbx) {
        this.spells = cbx.m_227133_(Spells.REGISTRY_KEY);
    }

    public static SpellArgument spell(CommandBuildContext cbx) {
        return new SpellArgument(cbx);
    }

    public Spell parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)reader);
        Optional spell = this.spells.m_213562_(ResourceKey.m_135785_(Spells.REGISTRY_KEY, (ResourceLocation)resourceLocation));
        return (Spell)((Holder)spell.orElseThrow(() -> ((SimpleCommandExceptionType)UNKNOWN_SPELL).create())).get();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining();
        this.spells.m_214062_().forEach(resourceKey -> {
            String spellStr = resourceKey.m_135782_().toString();
            if (spellStr.startsWith(s)) {
                builder.suggest(spellStr);
            }
        });
        return builder.buildFuture();
    }

    public static Spell getSpell(CommandContext<CommandSourceStack> context, String argument) {
        return (Spell)context.getArgument(argument, Spell.class);
    }
}

