/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.command.SpellArgument;
import de.cas_ual_ty.spells.command.SpellTreeArgument;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.SpellInstance;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;

public class SpellCommand {
    public static final String SPELLS_PROGRESSION_LEARN_SINGLE = "spells.progression.learn.success.single";
    public static final String SPELLS_PROGRESSION_LEARN_SINGLE_FAILED = "spells.progression.learn.failed.single";
    public static final String SPELLS_PROGRESSION_LEARN_MULTIPLE = "spells.progression.learn.success.multiple";
    public static final String SPELLS_PROGRESSION_LEARN_TREE_SINGLE = "spells.progression.learn_tree.success.single";
    public static final String SPELLS_PROGRESSION_LEARN_TREE_SINGLE_FAILED = "spells.progression.learn_tree.failed.single";
    public static final String SPELLS_PROGRESSION_LEARN_TREE_MULTIPLE = "spells.progression.learn_tree.success.multiple";
    public static final String SPELLS_PROGRESSION_LEARN_ALL_SINGLE = "spells.progression.learn_all.success.single";
    public static final String SPELLS_PROGRESSION_LEARN_ALL_SINGLE_FAILED = "spells.progression.learn_all.failed.single";
    public static final String SPELLS_PROGRESSION_LEARN_ALL_MULTIPLE = "spells.progression.learn_all.success.multiple";
    public static final String SPELLS_PROGRESSION_FORGET_SINGLE = "spells.progression.forget.success.single";
    public static final String SPELLS_PROGRESSION_FORGET_SINGLE_FAILED = "spells.progression.forget.failed.single";
    public static final String SPELLS_PROGRESSION_FORGET_MULTIPLE = "spells.progression.forget.success.multiple";
    public static final String SPELLS_PROGRESSION_FORGET_TREE_SINGLE = "spells.progression.forget_tree.success.single";
    public static final String SPELLS_PROGRESSION_FORGET_TREE_SINGLE_FAILED = "spells.progression.forget_tree.failed.single";
    public static final String SPELLS_PROGRESSION_FORGET_TREE_MULTIPLE = "spells.progression.forget_tree.success.multiple";
    public static final String SPELLS_PROGRESSION_FORGET_ALL_SINGLE = "spells.progression.forget_all.success.single";
    public static final String SPELLS_PROGRESSION_FORGET_ALL_SINGLE_FAILED = "spells.progression.forget_all.failed.single";
    public static final String SPELLS_PROGRESSION_FORGET_ALL_MULTIPLE = "spells.progression.forget_all.success.multiple";
    public static final String SPELLS_PROGRESSION_RESET_SINGLE = "spells.progression.reset.success.single";
    public static final String SPELLS_PROGRESSION_RESET_MULTIPLE = "spells.progression.reset.success.multiple";
    public static final String SPELLS_SLOT_REMOVE_SINGLE = "spells.slot.remove.success.single";
    public static final String SPELLS_SLOT_REMOVE_MULTIPLE = "spells.slot.remove.success.multiple";
    public static final String SPELLS_SLOT_SET_DIRECT_SINGLE = "spells.slot.set.direct.success.single";
    public static final String SPELLS_SLOT_SET_DIRECT_MULTIPLE = "spells.slot.set.direct.success.multiple";
    public static final String SPELLS_SLOT_SET_SINGLE = "spells.slot.set.success.single";
    public static final String SPELLS_SLOT_SET_MULTIPLE = "spells.slot.set.success.multiple";
    public static final String SPELLS_SLOT_CLEAR_SINGLE = "spells.slot.clear.success.single";
    public static final String SPELLS_SLOT_CLEAR_MULTIPLE = "spells.slot.clear.success.multiple";
    public static final String UNKNOWN_NODE = "spells.node.failed";
    public static final String ARG_TARGETS = "targets";
    public static final String ARG_SPELL = "spell";
    public static final String ARG_SPELL_TREE = "spell_tree";
    public static final String ARG_NODE_ID = "node_id";
    public static final String ARG_SLOT = "slot";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext cbx) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spells").requires(css -> css.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"progression").then(Commands.m_82127_((String)"learn").then(((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_SPELL_TREE, (ArgumentType)SpellTreeArgument.spellTree(cbx)).then(Commands.m_82129_((String)ARG_NODE_ID, (ArgumentType)IntegerArgumentType.integer((int)1)).executes(SpellCommand::spellsProgressionLearn))).then(Commands.m_82129_((String)"all", (ArgumentType)StringArgumentType.string()).executes(SpellCommand::spellsProgressionLearnTree)))).then(Commands.m_82129_((String)"all", (ArgumentType)StringArgumentType.string()).executes(SpellCommand::spellsProgressionLearnAll))))).then(Commands.m_82127_((String)"forget").then(((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_SPELL_TREE, (ArgumentType)SpellTreeArgument.spellTree(cbx)).then(Commands.m_82129_((String)ARG_SPELL, (ArgumentType)SpellArgument.spell(cbx)).executes(SpellCommand::spellsProgressionForget))).then(Commands.m_82129_((String)"all", (ArgumentType)StringArgumentType.string()).executes(SpellCommand::spellsProgressionForgetTree)))).then(Commands.m_82129_((String)"all", (ArgumentType)StringArgumentType.string()).executes(SpellCommand::spellsProgressionForgetAll))))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).executes(SpellCommand::spellsProgressionReset))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"slots").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)ARG_SLOT, (ArgumentType)IntegerArgumentType.integer((int)0, (int)5)).then(Commands.m_82127_((String)"direct").then(Commands.m_82129_((String)ARG_SPELL, (ArgumentType)SpellArgument.spell(cbx)).executes(SpellCommand::spellsSlotSetDirect)))).then(Commands.m_82129_((String)ARG_SPELL_TREE, (ArgumentType)SpellTreeArgument.spellTree(cbx)).then(Commands.m_82129_((String)ARG_NODE_ID, (ArgumentType)IntegerArgumentType.integer()).executes(SpellCommand::spellsSlotSet))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)ARG_SLOT, (ArgumentType)IntegerArgumentType.integer((int)0, (int)5)).executes(SpellCommand::spellsSlotRemove))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)ARG_TARGETS, (ArgumentType)EntityArgument.m_91470_()).executes(SpellCommand::spellsSlotClear)))));
    }

    private static int setOneOfTree(CommandContext<CommandSourceStack> context, SpellStatus status, String singleKey, String singleFailedKey, String multipleKey) throws CommandSyntaxException {
        int nodeId;
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        SpellTree spellTree = SpellTreeArgument.getSpellTree(context, ARG_SPELL_TREE);
        SpellNode node = spellTree.findNode(nodeId = IntegerArgumentType.getInteger(context, (String)ARG_NODE_ID));
        if (node == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)UNKNOWN_NODE, (Object[])new Object[]{spellTree.getTitle(), nodeId}));
            return 0;
        }
        boolean single = players.size() == 1;
        AtomicBoolean changed = new AtomicBoolean(false);
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> {
            if (spellProgressionHolder.getSpellStatus(node.getNodeId()) != status) {
                changed.set(true);
            }
            spellProgressionHolder.setSpellStatus(node.getNodeId(), status);
        }));
        if (players.size() == 1) {
            if (changed.get()) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)singleKey, (Object[])new Object[]{node.getSpellDirect().getTitle(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)singleFailedKey, (Object[])new Object[]{node.getSpellDirect().getTitle(), ((ServerPlayer)players.iterator().next()).m_5446_()}));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)multipleKey, (Object[])new Object[]{node.getSpellDirect().getTitle(), players.size()}), true);
        }
        return players.size();
    }

    private static int setAllOfTree(CommandContext<CommandSourceStack> context, SpellStatus status, String singleKey, String singleFailedKey, String multipleKey) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        SpellTree spellTree = SpellTreeArgument.getSpellTree(context, ARG_SPELL_TREE);
        boolean single = players.size() == 1;
        AtomicInteger changed = new AtomicInteger(0);
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> spellTree.forEach(node -> {
            if (single && spellProgressionHolder.getSpellStatus(node.getNodeId()) != status) {
                changed.getAndIncrement();
            }
            spellProgressionHolder.setSpellStatus(node.getNodeId(), status);
        })));
        if (players.size() == 1) {
            if (changed.get() > 0) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)singleKey, (Object[])new Object[]{spellTree.getTitle(), ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)singleFailedKey, (Object[])new Object[]{spellTree.getTitle(), ((ServerPlayer)players.iterator().next()).m_5446_()}));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)multipleKey, (Object[])new Object[]{spellTree.getTitle(), players.size()}), true);
        }
        return players.size();
    }

    private static int setForAllTrees(CommandContext<CommandSourceStack> context, SpellStatus status, String singleKey, String singleFailedKey, String multipleKey) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        Registry<SpellTree> registry = SpellTrees.getRegistry((LevelAccessor)((CommandSourceStack)context.getSource()).m_81372_());
        int totalTrees = registry.m_13562_();
        AtomicInteger totalSpells = new AtomicInteger(0);
        registry.forEach(tree -> tree.forEach(node -> totalSpells.getAndIncrement()));
        boolean single = players.size() == 1;
        AtomicInteger learned = new AtomicInteger(0);
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> registry.forEach(spellTree -> spellTree.forEach(spellNode -> {
            if (single && spellProgressionHolder.getSpellStatus(spellNode.getNodeId()) != status) {
                learned.getAndIncrement();
            }
            spellProgressionHolder.setSpellStatus(spellNode.getNodeId(), status);
        }))));
        if (single) {
            if (learned.get() > 0) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)singleKey, (Object[])new Object[]{learned.get(), totalTrees, ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)singleFailedKey, (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)multipleKey, (Object[])new Object[]{totalSpells, totalTrees, players.size()}), true);
        }
        return players.size();
    }

    private static int spellsProgressionLearn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return SpellCommand.setOneOfTree(context, SpellStatus.LEARNED, SPELLS_PROGRESSION_LEARN_SINGLE, SPELLS_PROGRESSION_LEARN_SINGLE_FAILED, SPELLS_PROGRESSION_LEARN_MULTIPLE);
    }

    private static int spellsProgressionLearnTree(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return SpellCommand.setAllOfTree(context, SpellStatus.LEARNED, SPELLS_PROGRESSION_LEARN_TREE_SINGLE, SPELLS_PROGRESSION_LEARN_TREE_SINGLE_FAILED, SPELLS_PROGRESSION_LEARN_TREE_MULTIPLE);
    }

    private static int spellsProgressionLearnAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return SpellCommand.setForAllTrees(context, SpellStatus.LEARNED, SPELLS_PROGRESSION_LEARN_ALL_SINGLE, SPELLS_PROGRESSION_LEARN_ALL_SINGLE_FAILED, SPELLS_PROGRESSION_LEARN_ALL_MULTIPLE);
    }

    private static int spellsProgressionForget(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return SpellCommand.setOneOfTree(context, SpellStatus.FORGOTTEN, SPELLS_PROGRESSION_FORGET_SINGLE, SPELLS_PROGRESSION_FORGET_SINGLE_FAILED, SPELLS_PROGRESSION_FORGET_MULTIPLE);
    }

    private static int spellsProgressionForgetTree(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return SpellCommand.setAllOfTree(context, SpellStatus.FORGOTTEN, SPELLS_PROGRESSION_FORGET_TREE_SINGLE, SPELLS_PROGRESSION_FORGET_TREE_SINGLE_FAILED, SPELLS_PROGRESSION_FORGET_TREE_MULTIPLE);
    }

    private static int spellsProgressionForgetAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return SpellCommand.setForAllTrees(context, SpellStatus.FORGOTTEN, SPELLS_PROGRESSION_FORGET_ALL_SINGLE, SPELLS_PROGRESSION_FORGET_ALL_SINGLE_FAILED, SPELLS_PROGRESSION_FORGET_ALL_MULTIPLE);
    }

    private static int spellsProgressionReset(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        players.stream().map(SpellProgressionHolder::getSpellProgressionHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellProgressionHolder -> {
            spellProgressionHolder.getProgression().clear();
            SpellHolder.getSpellHolder(spellProgressionHolder.getPlayer()).ifPresent(spellHolder -> {
                spellHolder.clear();
                spellHolder.sendSync();
            });
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_RESET_SINGLE, (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_PROGRESSION_RESET_MULTIPLE, (Object[])new Object[]{players.size()}), true);
        }
        return 0;
    }

    private static int spellsSlotSetDirect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        int slot = IntegerArgumentType.getInteger(context, (String)ARG_SLOT);
        Spell spell = SpellArgument.getSpell(context, ARG_SPELL);
        players.stream().map(SpellHolder::getSpellHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellHolder -> {
            spellHolder.setSpell(slot, new SpellInstance((Holder<Spell>)Holder.m_205709_((Object)spell)));
            spellHolder.sendSync();
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_SET_DIRECT_SINGLE, (Object[])new Object[]{slot, ((ServerPlayer)players.iterator().next()).m_5446_(), spell.getTitle()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_SET_DIRECT_MULTIPLE, (Object[])new Object[]{slot, players.size(), spell.getTitle()}), true);
        }
        return players.size();
    }

    private static int spellsSlotSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int nodeId;
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        int slot = IntegerArgumentType.getInteger(context, (String)ARG_SLOT);
        SpellTree spellTree = SpellTreeArgument.getSpellTree(context, ARG_SPELL_TREE);
        SpellNode spellNode = spellTree.findNode(nodeId = IntegerArgumentType.getInteger(context, (String)ARG_NODE_ID));
        if (spellNode == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)UNKNOWN_NODE, (Object[])new Object[]{spellTree.getTitle(), nodeId}));
            return 0;
        }
        players.stream().map(SpellHolder::getSpellHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellHolder -> {
            spellHolder.setSpell(slot, spellNode.getSpellInstance());
            spellHolder.sendSync();
        }));
        Spell spell = spellNode.getSpellDirect();
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_SET_SINGLE, (Object[])new Object[]{slot, ((ServerPlayer)players.iterator().next()).m_5446_(), spell.getTitle(), spellTree.getTitle()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_SET_MULTIPLE, (Object[])new Object[]{slot, players.size(), spell.getTitle(), spellTree.getTitle()}), true);
        }
        return players.size();
    }

    private static int spellsSlotRemove(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        int slot = IntegerArgumentType.getInteger(context, (String)ARG_SLOT);
        players.stream().map(SpellHolder::getSpellHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellHolder -> {
            spellHolder.setSpell(slot, null);
            spellHolder.sendSync();
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_REMOVE_SINGLE, (Object[])new Object[]{slot, ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_REMOVE_MULTIPLE, (Object[])new Object[]{slot, players.size()}), true);
        }
        return players.size();
    }

    private static int spellsSlotClear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(context, (String)ARG_TARGETS);
        if (players.isEmpty()) {
            return 0;
        }
        players.stream().map(SpellHolder::getSpellHolder).forEach(lazyOptional -> lazyOptional.ifPresent(spellHolder -> {
            spellHolder.clear();
            spellHolder.sendSync();
        }));
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_CLEAR_SINGLE, (Object[])new Object[]{((ServerPlayer)players.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)SPELLS_SLOT_CLEAR_MULTIPLE, (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }
}

