/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SpellTreeArgument
implements ArgumentType<SpellTree> {
    public static final SimpleCommandExceptionType UNKNOWN_SPELL_TREE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.spell_tree.id.invalid"));
    private final HolderLookup<SpellTree> spellTrees;

    public SpellTreeArgument(CommandBuildContext cbx) {
        this.spellTrees = cbx.m_227133_(SpellTrees.REGISTRY_KEY);
    }

    public static SpellTreeArgument spellTree(CommandBuildContext cbx) {
        return new SpellTreeArgument(cbx);
    }

    public SpellTree parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)reader);
        Optional spell = this.spellTrees.m_213562_(ResourceKey.m_135785_(SpellTrees.REGISTRY_KEY, (ResourceLocation)resourceLocation));
        return (SpellTree)((Holder)spell.orElseThrow(() -> ((SimpleCommandExceptionType)UNKNOWN_SPELL_TREE).create())).get();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String s = builder.getRemaining();
        this.spellTrees.m_214062_().forEach(resourceKey -> {
            String spellStr = resourceKey.m_135782_().toString();
            if (spellStr.startsWith(s)) {
                builder.suggest(spellStr);
            }
        });
        return builder.buildFuture();
    }

    public static SpellTree getSpellTree(CommandContext<CommandSourceStack> context, String argument) {
        return (SpellTree)context.getArgument(argument, SpellTree.class);
    }
}

