/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DocsGen
implements DataProvider {
    public static final Map<String, String> PREFIX_MAP = new HashMap<String, String>();
    private static final File ROOT = new File("./docsgen");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected DataGenerator gen;
    protected String modId;
    protected ExistingFileHelper exFileHelper;
    protected RegistryAccess registryAccess;
    protected RegistryOps<JsonElement> registryOps;

    public DocsGen(DataGenerator gen, String modId, ExistingFileHelper exFileHelper) {
        this.gen = gen;
        this.modId = modId;
        this.exFileHelper = exFileHelper;
        this.registryAccess = RegistryAccess.m_206197_();
        this.registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)this.registryAccess);
    }

    public static void generateSingleFiles(String modId) {
        ROOT.mkdirs();
        SpellsAndShields.LOGGER.info("Generated reduced json files for docs in: " + ROOT.getAbsolutePath());
        for (Map.Entry entry : SpellActionTypes.REGISTRY.get().getEntries()) {
            ResourceLocation rl = ((ResourceKey)entry.getKey()).m_135782_();
            if (!rl.m_135827_().equals(modId)) continue;
            SpellActionType type = (SpellActionType)entry.getValue();
            DocsGen.createFile(rl, type);
        }
    }

    public static void generateBigFile(String modId) {
        ROOT.mkdirs();
        File full = new File(ROOT, modId + ".md");
        SpellsAndShields.LOGGER.info("Generated big file containing reduced json entries for docs in: " + full.getAbsolutePath());
        try (FileWriter fw = new FileWriter(full);){
            for (Map.Entry entry : SpellActionTypes.REGISTRY.get().getEntries()) {
                ResourceLocation rl = ((ResourceKey)entry.getKey()).m_135782_();
                if (!rl.m_135827_().equals(modId)) continue;
                SpellActionType type = (SpellActionType)entry.getValue();
                DocsGen.create(rl, type, fw);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static <A extends SpellAction> void createFile(ResourceLocation rl, SpellActionType<A> type) {
        File folder = new File(ROOT, rl.m_135827_());
        folder.mkdir();
        File f = new File(folder, rl.m_135815_() + ".md");
        try (FileWriter fw = new FileWriter(f);){
            DocsGen.create(rl, type, fw);
        }
        catch (IOException | RuntimeException ex) {
            SpellsAndShields.LOGGER.error("Failed to generate doc for " + rl);
        }
    }

    private static <A extends SpellAction> void create(ResourceLocation rl, SpellActionType<A> type, FileWriter fw) throws IOException {
        Codec<A> codec = type.getCodec();
        if (codec instanceof MapCodec.MapCodecCodec) {
            MapCodec.MapCodecCodec mapCodecCodec = (MapCodec.MapCodecCodec)codec;
            fw.write(10);
            fw.write("***\n");
            fw.write(10);
            fw.write("### `" + rl.m_135815_() + "` Type\n");
            fw.write(10);
            fw.write("ABCDE Text WIP\n");
            fw.write(10);
            fw.write("JSON Format:\n");
            fw.write("```jsonc\n");
            fw.write("{\n");
            LinkedList keys = new LinkedList();
            mapCodecCodec.codec().keys((DynamicOps)JsonOps.INSTANCE).map(JsonElement::getAsString).forEach(key -> {
                if (!keys.contains(key) && !key.equals("activation")) {
                    keys.add(key);
                }
            });
            fw.write("  \"type\": \"" + rl.toString() + "\"" + (keys.isEmpty() ? "\n" : ",\n"));
            fw.write("  \"activation\": String" + (keys.isEmpty() ? "\n" : ",\n"));
            fw.write(keys.stream().map(key -> "  \"" + key + "\": " + PREFIX_MAP.entrySet().stream().filter(e -> key.contains((CharSequence)e.getKey())).map(Map.Entry::getValue).findFirst().orElse("ABCDE")).collect(Collectors.joining(",\n")) + "\n");
            fw.write("}\n");
            fw.write("```\n");
            fw.write("Elements:\n");
            fw.write(keys.stream().map(key -> "- `" + key + "`: ABCDE.").collect(Collectors.joining("\n")) + "\n");
        }
    }

    public void m_213708_(CachedOutput pOutput) throws IOException {
        DocsGen.generateSingleFiles(this.modId);
        DocsGen.generateBigFile(this.modId);
    }

    public String m_6055_() {
        return "Spells & Shields Docs";
    }
}

