/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.datagen;

import de.cas_ual_ty.spells.client.SpellKeyBindings;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.registers.BuiltinRegistries;
import de.cas_ual_ty.spells.registers.RequirementTypes;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementType;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.LanguageProvider;

public class LangGen
extends LanguageProvider {
    public static final String PERMANENT_EFFECT_NAME = "Perm. %s";
    public static final String PERMANENT_EFFECT_DESC = "Applies the %s effect while this spell is equipped.";
    public static final String TEMPORARY_EFFECT_NAME = "Temp. %s";
    public static final String TEMPORARY_EFFECT_DESC = "Applies the %s effect for a short period of time.";
    public static final String TOGGLE_EFFECT_NAME = "Toggle %s";
    public static final String TOGGLE_EFFECT_DESC = "Toggles the %s effect and burns mana (per 5 seconds) while it is active.";
    public static final String PERMANENT_SPELL_NAME = "Perm. %s";
    public static final String PERMANENT_SPELL_DESC = "Applies the following effect while this spell is equipped: %s";
    public static final String TEMPORARY_SPELL_NAME = "Temp. %s";
    public static final String TEMPORARY_SPELL_DESC = "Applies the following effect for a short period of time: %s";
    public static final String TOGGLE_SPELL_NAME = "Toggle %s";
    public static final String TOGGLE_SPELL_DESC = "Toggles the following effect and burns mana (per 5 seconds) while it is active: %s";

    public LangGen(DataGenerator dataGen, String locale) {
        super(dataGen, "spells_and_shields", locale);
    }

    protected void addTranslations() {
        this.addAttribute((Supplier<? extends Attribute>)BuiltinRegistries.MAX_MANA_ATTRIBUTE, "Max Mana");
        this.addAttribute((Supplier<? extends Attribute>)BuiltinRegistries.MANA_REGENERATION_ATTRIBUTE, "Mana Regeneration");
        this.add("enchantment.spells_and_shields.type." + BuiltinRegistries.SHIELD_ENCHANTMENT_CATEGORY.name().toLowerCase(), "shields");
        this.add("enchantment.spells_and_shields.type." + BuiltinRegistries.SWORD_OR_AXE_ENCHANTMENT_CATEGORY.name().toLowerCase(), "axes, swords");
        this.addEnchantment((Supplier<? extends Enchantment>)BuiltinRegistries.MAGIC_PROTECTION_ENCHANTMENT, "Magic Protection", "Reduces magic damage.");
        this.addEnchantment((Supplier<? extends Enchantment>)BuiltinRegistries.MANA_BLADE_ENCHANTMENT, "Mana Blade", "Consumes mana to increase damage.");
        this.addEnchantment((Supplier<? extends Enchantment>)BuiltinRegistries.MANA_SHIELD_ENCHANTMENT, "Mana Shield", "WIP");
        this.addEnchantment((Supplier<? extends Enchantment>)BuiltinRegistries.MAX_MANA_ENCHANTMENT, "Maximum Mana", "Increases your maximum mana while worn. More potent on chestplates and leggings than helmets and boots.");
        this.addEnchantment((Supplier<? extends Enchantment>)BuiltinRegistries.MANA_REGENERATION_ENCHANTMENT, "Mana Regeneration", "Increases your mana regeneration while worn. More potent on chestplates and leggings than helmets and boots.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.INSTANT_MANA_EFFECT, "Instant Mana", "Replenishes mana; higher levels increase the effect potency.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.MANA_BOMB_EFFECT, "Mana Bomb", "Burns mana; higher levels increase the effect potency.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.REPLENISHMENT_EFFECT, "Replenishment", "Replenishes mana over time; higher levels make mana be replenished quicker.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.LEAKING_MOB_EFFECT, "Leaking", "Burns mana over time; higher levels burn more mana.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.MANA_BOOST_EFFECT, "Mana Boost", "Increases maximum mana; higher levels give more additional mana bottles.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.EXTRA_MANA_EFFECT, "Extra Mana", "Adds burnable mana bottles (which can't be replenished); higher levels give more extra mana.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.SILENCE_EFFECT, "Silence", "No spells can be used while this effect is active.");
        this.addEffect((Supplier<? extends MobEffect>)BuiltinRegistries.MAGIC_IMMUNE_EFFECT, "Magic Immune", "Makes you ignore any magic damage.");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.INSTANT_MANA, "Instant Mana");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.STRONG_INSTANT_MANA, "Instant Mana");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.MANA_BOMB, "Mana Bomb");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.STRONG_MANA_BOMB, "Mana Bomb");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.LONG_REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.STRONG_REPLENISHMENT, "Replenishment");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.LEAKING, "Leaking");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.LONG_LEAKING, "Leaking");
        this.addPotion((Supplier<? extends Potion>)BuiltinRegistries.STRONG_LEAKING, "Leaking");
        this.add("key.spells_and_shields.categories.spell_slots", "Spells & Shields");
        for (int i = 0; i < 5; ++i) {
            this.add(SpellKeyBindings.key(i), "Spell Slot " + (i + 1));
        }
        this.addRequirement((Supplier<? extends RequirementType<?>>)RequirementTypes.BOOKSHELVES, "%s/%s Bookshelves");
        this.addRequirement((Supplier<? extends RequirementType<?>>)RequirementTypes.ADVANCEMENT, "Advancement: %s");
        this.addRequirement((Supplier<? extends RequirementType<?>>)RequirementTypes.ADVANCEMENT, ".error", "Unknown Advancement (config error): %s");
        this.addRequirement((Supplier<? extends RequirementType<?>>)RequirementTypes.ITEM, "%s (Not Consumed)");
        this.addRequirement((Supplier<? extends RequirementType<?>>)RequirementTypes.ITEM, ".consumed", "%s (Consumed)");
        this.addRequirement((Supplier<? extends RequirementType<?>>)RequirementTypes.ITEM, ".multiple", "%sx %s (Not Consumed)");
        this.addRequirement((Supplier<? extends RequirementType<?>>)RequirementTypes.ITEM, ".consumed.multiple", "%sx %s (Consumed)");
        this.add(SpellProgressionMenu.TITLE.getString(), "Spell Progression");
        this.add("spells.progression.learn.success.single", "Spell '%s' has been learned by %s");
        this.add("spells.progression.learn.failed.single", "Spell '%s' was already learned by %s");
        this.add("spells.progression.learn.success.multiple", "Spell '%s' has been learned by %s players");
        this.add("spells.progression.learn_tree.success.single", "Spell tree '%s' has been learned by %s");
        this.add("spells.progression.learn_tree.failed.single", "Spell tree '%s' was already learned by %s");
        this.add("spells.progression.learn_tree.success.multiple", "Spell tree '%s' has been learned by %s players");
        this.add("spells.progression.learn_all.success.single", "All %s unlearned spells in %s spell trees have been learned by %s");
        this.add("spells.progression.learn_all.failed.single", "%s already learned all %s spells in %s spell trees");
        this.add("spells.progression.learn_all.success.multiple", "All %s spells in %s spell trees have been learned by %s players");
        this.add("spells.progression.forget.success.single", "Spell '%s' has been forgotten by %s");
        this.add("spells.progression.forget.failed.single", "Spell '%s' was already forgotten by %s");
        this.add("spells.progression.forget.success.multiple", "Spell '%s' has been forgotten by %s players");
        this.add("spells.progression.forget_tree.success.single", "Spell tree '%s' was forgotten by %s");
        this.add("spells.progression.forget_tree.failed.single", "Not a single spell in spell tree '%s' was learned by %s");
        this.add("spells.progression.forget_tree.success.multiple", "Spell tree 's%' have been forgotten by %s players");
        this.add("spells.progression.forget_all.success.single", "All %s learned spells in %s spell trees have been forgotten by %s");
        this.add("spells.progression.forget_all.failed.single", "%s has never learned a single spell");
        this.add("spells.progression.forget_all.success.multiple", "All %s spells have been forgotten by %s players");
        this.add("spells.progression.reset.success.single", "Cleared all learned spells of %s");
        this.add("spells.progression.reset.success.multiple", "Cleared all learned spells of %s players");
        this.add("spells.slot.remove.success.single", "Cleared active spell in slot %s of %s");
        this.add("spells.slot.remove.success.multiple", "Cleared active spell in slot %s of %s players");
        this.add("spells.slot.set.direct.success.single", "Set active spell in slot %s of %s to '%s'");
        this.add("spells.slot.set.direct.success.multiple", "Set active spell in slot %s of %s players to '%s'");
        this.add("spells.slot.set.success.single", "Set active spell in slot %s of %s to '%s' from spell tree '%s'");
        this.add("spells.slot.set.success.multiple", "Set active spell in slot %s of %s players to '%s' from spell tree '%s'");
        this.add("spells.slot.clear.success.single", "Cleared active spells of %s");
        this.add("spells.slot.clear.success.multiple", "Cleared active spells of %s players");
        this.add("spells.node.failed", "Spell tree '%s' does not have a spell node '%s'");
        this.add("spell_progression.learn", "Learn");
        this.add("spell_progression.equip", "Equip");
        this.add("spell_progression.unavailable", "Unavailable");
        this.add("spell_progression.choose", "Choose a Slot");
        this.add("spell_tree.spells_and_shields.nether", "Nether");
        this.add("spell_tree.spells_and_shields.ocean", "Ocean");
        this.add("spell_tree.spells_and_shields.mining", "Mining");
        this.add("spell_tree.spells_and_shields.movement", "Movement");
        this.add("spell_tree.spells_and_shields.end", "End");
        this.add("spell.generic.title.item_requirement.hand", "Item Requirement (In Your Hand):");
        this.add("spell.generic.title.item_cost.hand", "Item Costs (Hand):");
        this.add("spell.generic.title.item_cost.mainhand", "Item Costs (Mainhand):");
        this.add("spell.generic.title.item_cost.offhand", "Item Costs (Offhand):");
        this.add("spell.generic.title.item_cost.inventory", "Item Costs (Inventory):");
        this.add("spell.generic.item_cost", "- %sx %s");
        this.add("spell.generic.item_cost.single", "- %s");
        this.add("spell.generic.item_cost.text", "- %s");
        this.add(Spells.KEY_LEAP, "Leap");
        this.add(Spells.KEY_LEAP_DESC, "Leap forward.");
        this.add(Spells.KEY_SUMMON_ANIMAL, "Summon Animal");
        this.add(Spells.KEY_SUMMON_ANIMAL_DESC, "Create life based on the item in your hand.");
        this.add(Spells.KEY_FIRE_BALL, "Fire Ball");
        this.add(Spells.KEY_FIRE_BALL_DESC, "Shoot a fire ball forward.");
        this.add(Spells.KEY_BLAST_SMELT, "Blast Smelt");
        this.add(Spells.KEY_BLAST_SMELT_DESC, "Works like an instant blast furnace on the item in your hand.");
        this.add(Spells.KEY_BLAST_SMELT_DESC_COST, "Any item that goes into a blast furnace");
        this.add(Spells.KEY_TRANSFER_MANA, "Transfer Mana");
        this.add(Spells.KEY_BLOW_ARROW, "Blow Arrow");
        this.add(Spells.KEY_BLOW_ARROW_DESC, "Shoot a projectile from your hand without a bow.");
        this.add(Spells.KEY_HEALTH_BOOST, "Health Boost");
        this.add(Spells.KEY_HEALTH_BOOST_DESC, "Increases your maximum health.");
        this.add(Spells.KEY_MANA_BOOST, "Mana Boost");
        this.add(Spells.KEY_MANA_BOOST_DESC, "Increases your maximum mana.");
        this.add(Spells.KEY_WATER_LEAP, "Water Leap");
        this.add(Spells.KEY_WATER_LEAP_DESC, "Leap forward like a dolphin (must be underwater).");
        this.add(Spells.KEY_PERMANENT_AQUA_AFFINITY, "Perm. %s".formatted("Aqua Affinity"));
        this.add(Spells.KEY_PERMANENT_AQUA_AFFINITY_DESC, PERMANENT_EFFECT_DESC.formatted("Mine underwater with full speed."));
        this.add(Spells.KEY_WATER_WHIP, "Water Whip");
        this.add(Spells.KEY_WATER_WHIP_DESC, "Shoots water out of the water bucket in your hand. The water returns and the bucket refills if you hold it on return");
        this.add(Spells.KEY_POTION_SHOT, "Potion Shot");
        this.add(Spells.KEY_POTION_SHOT_DESC, "Shoots the contents of the potion in your hand forward.");
        this.add(Spells.KEY_PERMANENT_FROST_WALKER, "Perm. %s".formatted("Frost Walker"));
        this.add(Spells.KEY_PERMANENT_FROST_WALKER_DESC, PERMANENT_SPELL_DESC.formatted("Walk on water by turning the blocks you walk on into ice."));
        this.add(Spells.KEY_TEMPORARY_FROST_WALKER, "Temp. %s".formatted("Frost Walker"));
        this.add(Spells.KEY_TEMPORARY_FROST_WALKER_DESC, TEMPORARY_SPELL_DESC.formatted("Walk on water by turning the blocks you walk on into ice."));
        this.add(Spells.KEY_TOGGLE_FROST_WALKER, "Toggle %s".formatted("Frost Walker"));
        this.add(Spells.KEY_TOGGLE_FROST_WALKER_DESC, TOGGLE_SPELL_DESC.formatted("Walk on water by turning the blocks you walk on into ice."));
        this.add(Spells.KEY_JUMP, "Jump");
        this.add(Spells.KEY_JUMP_DESC, "High jump. Be aware of fall damage.");
        this.add(Spells.KEY_MANA_SOLES, "Mana Soles");
        this.add(Spells.KEY_MANA_SOLES_DESC, "Consumes mana to reduce or cancel fall damage.");
        this.add(Spells.KEY_FIRE_CHARGE, "Fire Charge");
        this.add(Spells.KEY_FIRE_CHARGE_DESC, "Shoot a fire charge forward instantly.");
        this.add(Spells.KEY_PRESSURIZE, "Pressurize");
        this.add(Spells.KEY_PRESSURIZE_DESC, "Knock back every entity around you and remove any fluid.");
        this.add(Spells.KEY_INSTANT_MINE, "Instant Mine");
        this.add(Spells.KEY_INSTANT_MINE_DESC, "Breaks the block you are looking at using the tool in your hand.");
        this.add(Spells.KEY_INSTANT_MINE_DESC_REQUIREMENT, "The tool to break the block with");
        this.add(Spells.KEY_SPIT_METAL, "Spit Metal");
        this.add(Spells.KEY_SPIT_METAL_DESC, "Spit a nugget that deals damage (from your hand).");
        this.add(Spells.KEY_FLAMETHROWER, "Flamethrower");
        this.add(Spells.KEY_FLAMETHROWER_DESC, "Breath flames from your mouth setting everything on fire.");
        this.add(Spells.KEY_PERMANENT_LAVA_WALKER, "Perm. %s".formatted("Lava Walker"));
        this.add(Spells.KEY_PERMANENT_LAVA_WALKER_DESC, PERMANENT_SPELL_DESC.formatted("Walk on lava by turning the blocks you walk on into obsidian."));
        this.add(Spells.KEY_TEMPORARY_LAVA_WALKER, "Temp. %s".formatted("Lava Walker"));
        this.add(Spells.KEY_TEMPORARY_LAVA_WALKER_DESC, TEMPORARY_SPELL_DESC.formatted("Walk on lava by turning the blocks you walk on into obsidian."));
        this.add(Spells.KEY_TOGGLE_LAVA_WALKER, "Toggle %s".formatted("Lava Walker"));
        this.add(Spells.KEY_TOGGLE_LAVA_WALKER_DESC, TOGGLE_SPELL_DESC.formatted("Walk on lava by turning the blocks you walk on into obsidian."));
        this.add(Spells.KEY_SILENCE_TARGET, "Silence Target");
        this.add(Spells.KEY_SILENCE_TARGET_DESC, "Silence the target you are looking at within a certain range.");
        this.add(Spells.KEY_RANDOM_TELEPORT, "Random Teleport");
        this.add(Spells.KEY_RANDOM_TELEPORT_DESC, "Randomly teleport away. This spell can fail.");
        this.add(Spells.KEY_FORCED_TELEPORT, "Forced Teleport");
        this.add(Spells.KEY_FORCED_TELEPORT_DESC, "Randomly teleport the target you are looking at away. This spell can fail.");
        this.add(Spells.KEY_TELEPORT, "Teleport");
        this.add(Spells.KEY_TELEPORT_DESC, "Teleport to where you are looking at.");
        this.add(Spells.KEY_LIGHTNING_STRIKE, "Lightning Strike");
        this.add(Spells.KEY_LIGHTNING_STRIKE_DESC, "Summon a lightning strike where you are looking at. The target must see skylight.");
        this.add(Spells.KEY_DRAIN_FLAME, "Drain Flame");
        this.add(Spells.KEY_DRAIN_FLAME_DESC, "Drain fire to convert it into mana regeneration. The fire must be infinite (eg. on top of Netherrack) for this to work.");
        this.add(Spells.KEY_GROWTH, "Growth");
        this.add(Spells.KEY_GROWTH_DESC, "Apply the effect of Bonemeal to plants around you.");
        this.add(Spells.KEY_GHAST, "Ghast");
        this.add(Spells.KEY_GHAST_DESC, "Shoot a fire charge forward, like a Ghast.");
        this.add(Spells.KEY_ENDER_ARMY, "Ender Army");
        this.add(Spells.KEY_ENDER_ARMY_DESC, "Make all Endermen close to the target you are looking at attack said target.");
        this.add(Spells.KEY_EVOKER_FANGS, "Evoker Fangs");
        this.add(Spells.KEY_EVOKER_FANGS_DESC, "Summon Fangs forward like an Evoker.");
        this.add(Spells.KEY_POCKET_ROCKET, "Pocket Rocket");
        this.add(Spells.KEY_POCKET_ROCKET_DESC, "Fire a bunch of Firework Rockets in a row to boost Elytra flight.");
        this.add(Spells.KEY_PERMANENT_REPLENISHMENT, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_REPLENISHMENT_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_REPLENISHMENT, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_REPLENISHMENT_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_REPLENISHMENT, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_REPLENISHMENT_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_MAGIC_IMMUNE, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_MAGIC_IMMUNE_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_MAGIC_IMMUNE, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_MAGIC_IMMUNE_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_MAGIC_IMMUNE, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_MAGIC_IMMUNE_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_SPEED, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_SPEED_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_SPEED, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_SPEED_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_SPEED, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_SPEED_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_JUMP_BOOST, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_JUMP_BOOST_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_JUMP_BOOST, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_JUMP_BOOST_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_JUMP_BOOST, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_JUMP_BOOST_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_DOLPHINS_GRACE, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_DOLPHINS_GRACE_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_DOLPHINS_GRACE, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_DOLPHINS_GRACE_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_DOLPHINS_GRACE, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_DOLPHINS_GRACE_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_WATER_BREATHING, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_WATER_BREATHING_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_WATER_BREATHING, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_WATER_BREATHING_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_WATER_BREATHING, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_WATER_BREATHING_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_SLOW_FALLING, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_SLOW_FALLING_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_SLOW_FALLING, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_SLOW_FALLING_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_SLOW_FALLING, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_SLOW_FALLING_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_HASTE, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_HASTE_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_HASTE, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_HASTE_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_HASTE, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_HASTE_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_REGENERATION, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_REGENERATION_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_REGENERATION, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_REGENERATION_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_REGENERATION, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_REGENERATION_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_FIRE_RESISTANCE, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_FIRE_RESISTANCE_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_FIRE_RESISTANCE, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_FIRE_RESISTANCE_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_FIRE_RESISTANCE, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_FIRE_RESISTANCE_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_NIGHT_VISION, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_NIGHT_VISION_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_NIGHT_VISION, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_NIGHT_VISION_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_NIGHT_VISION, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_NIGHT_VISION_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_STRENGTH, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_STRENGTH_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_STRENGTH, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_STRENGTH_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_STRENGTH, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_STRENGTH_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_RESISTANCE, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_RESISTANCE_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_RESISTANCE, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_RESISTANCE_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_RESISTANCE, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_RESISTANCE_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_INVISIBILITY, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_INVISIBILITY_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_INVISIBILITY, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_INVISIBILITY_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_INVISIBILITY, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_INVISIBILITY_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_GLOWING, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_GLOWING_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_GLOWING, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_GLOWING_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_GLOWING, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_GLOWING_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_LUCK, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_LUCK_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_LUCK, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_LUCK_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_LUCK, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_LUCK_DESC, TOGGLE_EFFECT_DESC);
        this.add(Spells.KEY_PERMANENT_CONDUIT_POWER, "Perm. %s");
        this.add(Spells.KEY_PERMANENT_CONDUIT_POWER_DESC, PERMANENT_EFFECT_DESC);
        this.add(Spells.KEY_TEMPORARY_CONDUIT_POWER, "Temp. %s");
        this.add(Spells.KEY_TEMPORARY_CONDUIT_POWER_DESC, TEMPORARY_EFFECT_DESC);
        this.add(Spells.KEY_TOGGLE_CONDUIT_POWER, "Toggle %s");
        this.add(Spells.KEY_TOGGLE_CONDUIT_POWER_DESC, TOGGLE_EFFECT_DESC);
    }

    public void addAttribute(Supplier<? extends Attribute> key, String name) {
        this.add(key.get().m_22087_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name, String desc) {
        super.addEnchantment(key, name);
        this.add(key.get().m_44704_() + ".desc", desc);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name, String desc) {
        super.addEffect(key, name);
        this.add(key.get().m_19481_() + ".description", desc);
    }

    public void addPotion(Supplier<? extends Potion> key, String name) {
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)key.get()), "Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)key.get()), "Splash Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)key.get()), "Lingering Potion of " + name);
        this.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_), (Potion)key.get()), "Arrow of " + name);
    }

    public void addRequirement(Supplier<? extends RequirementType<?>> requirement, String desc) {
        this.addRequirement(requirement, "", desc);
    }

    public void addRequirement(Supplier<? extends RequirementType<?>> requirement, String suffix, String desc) {
        Object inst = requirement.get().makeInstance();
        String descriptionId = ((Requirement)inst).getDescriptionId();
        this.add(descriptionId + suffix, desc);
    }

    public String m_6055_() {
        return "Spells & Shields Lang File";
    }
}

