/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.datagen;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;

public class SpellTreesGen
implements DataProvider {
    protected Map<ResourceLocation, SpellTree> spellTrees;
    protected DataGenerator gen;
    protected String modId;
    protected ExistingFileHelper exFileHelper;
    protected RegistryAccess registryAccess;
    protected RegistryOps<JsonElement> registryOps;
    protected Registry<Spell> registry;

    public SpellTreesGen(DataGenerator gen, String modId, ExistingFileHelper exFileHelper) {
        this.gen = gen;
        this.modId = modId;
        this.exFileHelper = exFileHelper;
        this.registryAccess = RegistryAccess.m_206197_();
        this.registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)this.registryAccess);
        this.spellTrees = new HashMap<ResourceLocation, SpellTree>();
        this.registry = (Registry)this.registryOps.m_206826_(Spells.REGISTRY_KEY).orElseThrow();
    }

    public void addSpellTree(String key, SpellTree spellTree) {
        this.addSpellTree(new ResourceLocation(this.modId, key), spellTree);
    }

    public void addSpellTree(ResourceLocation key, SpellTree spellTree) {
        this.spellTrees.put(key, spellTree);
    }

    public void addSpellTrees() {
        this.addSpellTree("nether", SpellTrees.fireTree(this::spellRef));
        this.addSpellTree("ocean", SpellTrees.waterTree(this::spellRef));
        this.addSpellTree("mining", SpellTrees.earthTree(this::spellRef));
        this.addSpellTree("movement", SpellTrees.airTree(this::spellRef));
        this.addSpellTree("end", SpellTrees.enderTree(this::spellRef));
    }

    protected Holder<Spell> spellRef(ResourceLocation spell) {
        return Holder.Reference.m_205766_(this.registry, (ResourceKey)ResourceKey.m_135785_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)spell));
    }

    public void m_213708_(CachedOutput pOutput) throws IOException {
        this.addSpellTrees();
        JsonCodecProvider provider = JsonCodecProvider.forDatapackRegistry((DataGenerator)this.gen, (ExistingFileHelper)this.exFileHelper, (String)this.modId, this.registryOps, SpellTrees.REGISTRY_KEY, this.spellTrees);
        provider.m_213708_(pOutput);
    }

    public String m_6055_() {
        return "Spells & Shields Spell Trees Files";
    }
}

