/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.cas_ual_ty.spells.registers.BuiltinRegistries;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.action.ai.SetMobTargetAction;
import de.cas_ual_ty.spells.spell.action.attribute.GetEntityExtraTagAction;
import de.cas_ual_ty.spells.spell.action.attribute.GetEntityEyePositionAction;
import de.cas_ual_ty.spells.spell.action.attribute.GetEntityPositionDirectionMotionAction;
import de.cas_ual_ty.spells.spell.action.attribute.GetEntityTypeAction;
import de.cas_ual_ty.spells.spell.action.attribute.GetEntityUUIDAction;
import de.cas_ual_ty.spells.spell.action.attribute.GetPositionAction;
import de.cas_ual_ty.spells.spell.action.control.ActivateAction;
import de.cas_ual_ty.spells.spell.action.control.BooleanActivationAction;
import de.cas_ual_ty.spells.spell.action.control.BranchAction;
import de.cas_ual_ty.spells.spell.action.control.DeactivateAction;
import de.cas_ual_ty.spells.spell.action.control.JumpAction;
import de.cas_ual_ty.spells.spell.action.control.LabelAction;
import de.cas_ual_ty.spells.spell.action.delayed.AddDelayedSpellAction;
import de.cas_ual_ty.spells.spell.action.delayed.CheckHasDelayedSpellAction;
import de.cas_ual_ty.spells.spell.action.delayed.RemoveDelayedSpellAction;
import de.cas_ual_ty.spells.spell.action.effect.AddAttributeModifierAction;
import de.cas_ual_ty.spells.spell.action.effect.ApplyEntityExtraTagAction;
import de.cas_ual_ty.spells.spell.action.effect.ApplyMobEffectAction;
import de.cas_ual_ty.spells.spell.action.effect.ApplyPotionEffectAction;
import de.cas_ual_ty.spells.spell.action.effect.RemoveAttributeModifierAction;
import de.cas_ual_ty.spells.spell.action.effect.ResetFallDistanceAction;
import de.cas_ual_ty.spells.spell.action.effect.SetMotionAction;
import de.cas_ual_ty.spells.spell.action.effect.SetOnFireAction;
import de.cas_ual_ty.spells.spell.action.effect.SourcedDamageAction;
import de.cas_ual_ty.spells.spell.action.effect.SourcedKnockbackAction;
import de.cas_ual_ty.spells.spell.action.effect.SpawnEntityAction;
import de.cas_ual_ty.spells.spell.action.effect.TeleportToAction;
import de.cas_ual_ty.spells.spell.action.fx.ParticleEmitterAction;
import de.cas_ual_ty.spells.spell.action.fx.PlaySoundAction;
import de.cas_ual_ty.spells.spell.action.fx.SpawnParticlesAction;
import de.cas_ual_ty.spells.spell.action.item.ConsumeItemAction;
import de.cas_ual_ty.spells.spell.action.item.ConsumePlayerItemsAction;
import de.cas_ual_ty.spells.spell.action.item.GetItemAttributesAction;
import de.cas_ual_ty.spells.spell.action.item.GetItemTagAction;
import de.cas_ual_ty.spells.spell.action.item.GiveItemAction;
import de.cas_ual_ty.spells.spell.action.item.ItemEqualsAction;
import de.cas_ual_ty.spells.spell.action.item.MainhandItemTargetAction;
import de.cas_ual_ty.spells.spell.action.item.OffhandItemTargetAction;
import de.cas_ual_ty.spells.spell.action.item.OverrideItemAction;
import de.cas_ual_ty.spells.spell.action.item.PlayerHasItemsAction;
import de.cas_ual_ty.spells.spell.action.item.UseItemAction;
import de.cas_ual_ty.spells.spell.action.item.UseItemOnBlocksAction;
import de.cas_ual_ty.spells.spell.action.level.CubeBlockTargetsAction;
import de.cas_ual_ty.spells.spell.action.level.GetBlockAction;
import de.cas_ual_ty.spells.spell.action.level.GetBlockAttributesAction;
import de.cas_ual_ty.spells.spell.action.level.GetFluidAction;
import de.cas_ual_ty.spells.spell.action.level.OffsetBlockAction;
import de.cas_ual_ty.spells.spell.action.level.PlayerHarvestBlockAction;
import de.cas_ual_ty.spells.spell.action.level.PositionToTargetAction;
import de.cas_ual_ty.spells.spell.action.level.RemoveBlockAction;
import de.cas_ual_ty.spells.spell.action.level.SetBlockAction;
import de.cas_ual_ty.spells.spell.action.level.TickBlockAction;
import de.cas_ual_ty.spells.spell.action.mana.BurnManaAction;
import de.cas_ual_ty.spells.spell.action.mana.GetManaAction;
import de.cas_ual_ty.spells.spell.action.mana.HasManaAction;
import de.cas_ual_ty.spells.spell.action.mana.ManaCheckAction;
import de.cas_ual_ty.spells.spell.action.mana.ReplenishManaAction;
import de.cas_ual_ty.spells.spell.action.mana.SimpleManaCheckAction;
import de.cas_ual_ty.spells.spell.action.target.ClearTargetsAction;
import de.cas_ual_ty.spells.spell.action.target.CopyTargetsAction;
import de.cas_ual_ty.spells.spell.action.target.EntityUUIDTargetAction;
import de.cas_ual_ty.spells.spell.action.target.GetTargetGroupSizeAction;
import de.cas_ual_ty.spells.spell.action.target.HomeAction;
import de.cas_ual_ty.spells.spell.action.target.LookAtTargetAction;
import de.cas_ual_ty.spells.spell.action.target.MovePlayerTargetsAction;
import de.cas_ual_ty.spells.spell.action.target.PickTargetAction;
import de.cas_ual_ty.spells.spell.action.target.RangedEntityTargetsAction;
import de.cas_ual_ty.spells.spell.action.target.ShootAction;
import de.cas_ual_ty.spells.spell.action.variable.PutVarAction;
import de.cas_ual_ty.spells.spell.compiler.Compiler;
import de.cas_ual_ty.spells.spell.context.BuiltinEvents;
import de.cas_ual_ty.spells.spell.context.BuiltinTargetGroups;
import de.cas_ual_ty.spells.spell.context.BuiltinVariables;
import de.cas_ual_ty.spells.spell.icon.AdvancedSpellIcon;
import de.cas_ual_ty.spells.spell.icon.DefaultSpellIcon;
import de.cas_ual_ty.spells.spell.icon.ItemSpellIcon;
import de.cas_ual_ty.spells.spell.icon.LayeredSpellIcon;
import de.cas_ual_ty.spells.spell.icon.SpellIcon;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SpellsGen
implements DataProvider {
    public static final ResourceLocation PERMANENT_ICON_RL = new ResourceLocation("spells_and_shields", "textures/spell/permanent.png");
    public static final ResourceLocation TEMPORARY_ICON_RL = new ResourceLocation("spells_and_shields", "textures/spell/temporary.png");
    public static final ResourceLocation TOGGLE_ICON_RL = new ResourceLocation("spells_and_shields", "textures/spell/toggle.png");
    public static final String KEY_HAND_ITEM_REQUIREMENT_TITLE = "spell.generic.title.item_requirement.hand";
    public static final String KEY_HAND_ITEM_COST_TITLE = "spell.generic.title.item_cost.hand";
    public static final String KEY_MAINHAND_ITEM_COST_TITLE = "spell.generic.title.item_cost.mainhand";
    public static final String KEY_OFFHAND_ITEM_COST_TITLE = "spell.generic.title.item_cost.offhand";
    public static final String KEY_INVENTORY_ITEM_COST_TITLE = "spell.generic.title.item_cost.inventory";
    public static final String KEY_ITEM_COST = "spell.generic.item_cost";
    public static final String KEY_ITEM_COST_SINGLE = "spell.generic.item_cost.single";
    public static final String KEY_ITEM_COST_TEXT = "spell.generic.item_cost.text";
    protected Map<ResourceLocation, Spell> spells;
    protected DataGenerator gen;
    protected String modId;
    protected ExistingFileHelper exFileHelper;
    protected RegistryAccess registryAccess;
    protected RegistryOps<JsonElement> registryOps;
    public static final CtxVarType<Integer> INT = (CtxVarType)CtxVarTypes.INT.get();
    public static final CtxVarType<Double> DOUBLE = (CtxVarType)CtxVarTypes.DOUBLE.get();
    public static final CtxVarType<Vec3> VEC3 = (CtxVarType)CtxVarTypes.VEC3.get();
    public static final CtxVarType<BlockPos> BLOCK_POS = (CtxVarType)CtxVarTypes.BLOCK_POS.get();
    public static final CtxVarType<Boolean> BOOLEAN = (CtxVarType)CtxVarTypes.BOOLEAN.get();
    public static final CtxVarType<CompoundTag> TAG = (CtxVarType)CtxVarTypes.TAG.get();
    public static final CtxVarType<String> STRING = (CtxVarType)CtxVarTypes.STRING.get();
    public final DynamicCtxVar<Boolean> TRUE = BOOLEAN.immediate(true);
    public final DynamicCtxVar<Boolean> FALSE = BOOLEAN.immediate(false);
    public final DynamicCtxVar<Vec3> ZERO_VEC3 = VEC3.immediate(Vec3.f_82478_);
    public final DynamicCtxVar<CompoundTag> EMPTY_TAG = TAG.immediate(new CompoundTag());

    public SpellsGen(DataGenerator gen, String modId, ExistingFileHelper exFileHelper) {
        this.gen = gen;
        this.modId = modId;
        this.exFileHelper = exFileHelper;
        this.registryAccess = RegistryAccess.m_206197_();
        this.registryOps = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)this.registryAccess);
        this.spells = new HashMap<ResourceLocation, Spell>();
    }

    public void dummy(ResourceLocation rl) {
        this.dummy(rl, Spells.key(rl), Spells.descKey(rl));
    }

    public void dummy(ResourceLocation rl, String key, String descKey) {
        this.dummy(rl, key, descKey, DefaultSpellIcon.make(new ResourceLocation(this.modId, "textures/spell/" + rl.m_135815_() + ".png")));
    }

    public void dummy(ResourceLocation rl, String key, String descKey, SpellIcon icon) {
        this.addSpell(rl, new Spell(icon, (Component)Component.m_237115_((String)key), 0.0f).addTooltip((Component)Component.m_237115_((String)descKey)).addTooltip((Component)Component.m_237113_((String)"In Development").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC)));
    }

    public void addSpell(String key, Spell spell) {
        this.addSpell(new ResourceLocation(this.modId, key), spell);
    }

    public void addSpell(ResourceLocation key, Spell spell) {
        this.spells.put(key, spell);
    }

    public void addPermanentEffectSpell(ResourceLocation rl, String key, String descKey, MobEffect mobEffect, int duration, int amplifier) {
        MutableComponent component = mobEffect.m_19482_().m_6881_();
        if (amplifier > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + amplifier))});
        }
        ResourceLocation mobEffectRL = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        String uuidCode = " uuid_from_string('permanent' + '%s' + %s) ".formatted(new Object[]{mobEffectRL.m_135815_(), BuiltinVariables.SPELL_SLOT});
        Spell spell = new Spell((SpellIcon)LayeredSpellIcon.make(List.of(DefaultSpellIcon.make(new ResourceLocation(mobEffectRL.m_135827_(), "textures/mob_effect/" + mobEffectRL.m_135815_() + ".png")), DefaultSpellIcon.make(PERMANENT_ICON_RL))), (Component)Component.m_237110_((String)key, (Object[])new Object[]{component}), 0.0f).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ON_EQUIP, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ON_UNEQUIP, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make("apply", "player", (Object)BuiltinTargetGroups.HOLDER)).addAction(PutVarAction.makeString((Object)BuiltinEvents.ON_EQUIP, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.makeString((Object)BuiltinEvents.ON_UNEQUIP, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.moveString("apply", (Object)BuiltinVariables.DELAY_UUID, "uuid")).addAction(ActivateAction.make((Object)BuiltinEvents.ON_EQUIP, "apply")).addAction(ActivateAction.make((Object)BuiltinEvents.ON_UNEQUIP, "remove")).addAction(RemoveDelayedSpellAction.make("remove", "player", STRING.reference("uuid"), BOOLEAN.immediate(false))).addAction(ActivateAction.make("apply", "renew")).addAction(ApplyMobEffectAction.make("apply", "player", STRING.reference("mob_effect"), INT.reference("duration+1"), INT.reference("amplifier"), BOOLEAN.reference("ambient"), BOOLEAN.reference("visible"), BOOLEAN.reference("show_icon"))).addAction(AddDelayedSpellAction.make("renew", "player", "apply", INT.reference("duration"), STRING.reference("uuid"), this.EMPTY_TAG, new HashMap<String, String>())).addParameter(STRING, "mob_effect", ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect).toString()).addParameter(INT, "duration", duration).addParameter(INT, "amplifier", amplifier).addParameter(BOOLEAN, "ambient", false).addParameter(BOOLEAN, "visible", false).addParameter(BOOLEAN, "show_icon", true).addEventHook((Object)BuiltinEvents.ON_EQUIP).addEventHook((Object)BuiltinEvents.ON_UNEQUIP).addTooltip((Component)Component.m_237110_((String)descKey, (Object[])new Object[]{component.m_6881_().m_130940_(mobEffect.m_19483_().m_19497_())}));
        if (!mobEffect.m_19485_().isEmpty()) {
            spell.addTooltip((Component)Component.m_237119_());
            spell.addTooltip((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Map.Entry e : mobEffect.m_19485_().entrySet()) {
                Attribute attribute = (Attribute)e.getKey();
                AttributeModifier.Operation op = ((AttributeModifier)e.getValue()).m_22217_();
                double value = ((AttributeModifier)e.getValue()).m_22218_();
                double d = op != AttributeModifier.Operation.MULTIPLY_BASE && op != AttributeModifier.Operation.MULTIPLY_TOTAL ? value : value * 100.0;
                if (value > 0.0) {
                    spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.plus." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d), component.m_6881_()}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(value < 0.0)) continue;
                spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.take." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d *= -1.0), component.m_6881_()}).m_130940_(ChatFormatting.RED));
            }
        }
        this.addSpell(rl, spell);
    }

    public void addTemporaryEffectSpell(ResourceLocation rl, String key, String descKey, MobEffect mobEffect, float manaCost, int duration, int amplifier) {
        MutableComponent component = mobEffect.m_19482_().m_6881_();
        if (amplifier > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + amplifier))});
        }
        ResourceLocation mobEffectRL = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        String uuidCode = " uuid_from_string('toggle' + '%s' + %s) ".formatted(new Object[]{mobEffectRL.m_135815_(), BuiltinVariables.SPELL_SLOT});
        Spell spell = new Spell((SpellIcon)LayeredSpellIcon.make(List.of(DefaultSpellIcon.make(new ResourceLocation(mobEffectRL.m_135827_(), "textures/mob_effect/" + mobEffectRL.m_135815_() + ".png")), DefaultSpellIcon.make(TEMPORARY_ICON_RL))), (Component)Component.m_237110_((String)key, (Object[])new Object[]{component}), manaCost).addAction(ManaCheckAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ApplyMobEffectAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, STRING.reference("mob_effect"), INT.reference("duration+1"), INT.reference("amplifier"), BOOLEAN.reference("ambient"), BOOLEAN.reference("visible"), BOOLEAN.reference("show_icon"))).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11911_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_12436_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(STRING, "mob_effect", ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect).toString()).addParameter(INT, "duration", duration).addParameter(INT, "amplifier", amplifier).addParameter(BOOLEAN, "ambient", false).addParameter(BOOLEAN, "visible", false).addParameter(BOOLEAN, "show_icon", true).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237110_((String)descKey, (Object[])new Object[]{component.m_6881_().m_130940_(mobEffect.m_19483_().m_19497_())}));
        if (!mobEffect.m_19485_().isEmpty()) {
            spell.addTooltip((Component)Component.m_237119_());
            spell.addTooltip((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Map.Entry e : mobEffect.m_19485_().entrySet()) {
                Attribute attribute = (Attribute)e.getKey();
                AttributeModifier.Operation op = ((AttributeModifier)e.getValue()).m_22217_();
                double value = ((AttributeModifier)e.getValue()).m_22218_();
                double d = op != AttributeModifier.Operation.MULTIPLY_BASE && op != AttributeModifier.Operation.MULTIPLY_TOTAL ? value : value * 100.0;
                if (value > 0.0) {
                    spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.plus." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d), component.m_6881_()}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(value < 0.0)) continue;
                spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.take." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d *= -1.0), component.m_6881_()}).m_130940_(ChatFormatting.RED));
            }
        }
        this.addSpell(rl, spell);
    }

    public void addToggleEffectSpell(ResourceLocation rl, String key, String descKey, MobEffect mobEffect, float manaCost, int duration, int amplifier) {
        MutableComponent component = mobEffect.m_19482_().m_6881_();
        if (amplifier > 0) {
            component = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + amplifier))});
        }
        ResourceLocation mobEffectRL = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        String uuidCode = " uuid_from_string('toggle' + '%s' + %s) ".formatted(new Object[]{mobEffectRL.m_135815_(), BuiltinVariables.SPELL_SLOT});
        Spell spell = new Spell((SpellIcon)LayeredSpellIcon.make(List.of(DefaultSpellIcon.make(new ResourceLocation(mobEffectRL.m_135827_(), "textures/mob_effect/" + mobEffectRL.m_135815_() + ".png")), DefaultSpellIcon.make(TOGGLE_ICON_RL))), (Component)Component.m_237110_((String)key, (Object[])new Object[]{component}), manaCost).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ACTIVE, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ON_UNEQUIP, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make("apply", "player", (Object)BuiltinTargetGroups.HOLDER)).addAction(PutVarAction.makeString((Object)BuiltinEvents.ACTIVE, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.makeString((Object)BuiltinEvents.ON_UNEQUIP, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.moveString("apply", (Object)BuiltinVariables.DELAY_UUID, "uuid")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "apply")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "remove")).addAction(ActivateAction.make((Object)BuiltinEvents.ON_UNEQUIP, "remove")).addAction(CheckHasDelayedSpellAction.make("remove", "player", STRING.reference("uuid"))).addAction(DeactivateAction.make("remove", "apply")).addAction(RemoveDelayedSpellAction.make("remove", "player", STRING.reference("uuid"), BOOLEAN.immediate(false))).addAction(PlaySoundAction.make("remove", "player", SoundEvents.f_12436_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(ManaCheckAction.make("apply", "player", Compiler.compileString(" (" + BuiltinVariables.MANA_COST + " * duration) / 100 ", DOUBLE))).addAction(ActivateAction.make("apply", "renew")).addAction(ApplyMobEffectAction.make("apply", "player", STRING.reference("mob_effect"), INT.reference("duration+1"), INT.reference("amplifier"), BOOLEAN.reference("ambient"), BOOLEAN.reference("visible"), BOOLEAN.reference("show_icon"))).addAction(AddDelayedSpellAction.make("renew", "player", "apply", INT.reference("duration"), STRING.reference("uuid"), this.EMPTY_TAG, new HashMap<String, String>())).addAction(ActivateAction.make("apply", "sound")).addAction(ActivateAction.make("apply", "anti_sound")).addAction(DeactivateAction.make((Object)BuiltinEvents.ACTIVE, "anti_sound")).addAction(DeactivateAction.make("anti_sound", "sound")).addAction(PlaySoundAction.make("sound", "player", SoundEvents.f_11911_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(STRING, "mob_effect", ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect).toString()).addParameter(INT, "duration", duration).addParameter(INT, "amplifier", amplifier).addParameter(BOOLEAN, "ambient", false).addParameter(BOOLEAN, "visible", false).addParameter(BOOLEAN, "show_icon", true).addEventHook((Object)BuiltinEvents.ACTIVE).addEventHook((Object)BuiltinEvents.ON_UNEQUIP).addTooltip((Component)Component.m_237110_((String)descKey, (Object[])new Object[]{component.m_6881_().m_130940_(mobEffect.m_19483_().m_19497_())}));
        if (!mobEffect.m_19485_().isEmpty()) {
            spell.addTooltip((Component)Component.m_237119_());
            spell.addTooltip((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Map.Entry e : mobEffect.m_19485_().entrySet()) {
                Attribute attribute = (Attribute)e.getKey();
                AttributeModifier.Operation op = ((AttributeModifier)e.getValue()).m_22217_();
                double value = ((AttributeModifier)e.getValue()).m_22218_();
                double d = op != AttributeModifier.Operation.MULTIPLY_BASE && op != AttributeModifier.Operation.MULTIPLY_TOTAL ? value : value * 100.0;
                if (value > 0.0) {
                    spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.plus." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d), component.m_6881_()}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(value < 0.0)) continue;
                spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.take." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d *= -1.0), component.m_6881_()}).m_130940_(ChatFormatting.RED));
            }
        }
        this.addSpell(rl, spell);
    }

    public void addPermanentAttributeSpell(ResourceLocation rl, String key, String descKey, SpellIcon spellIcon, Attribute attribute, AttributeModifier.Operation op, double value) {
        MutableComponent component = Component.m_237115_((String)attribute.m_22087_());
        ResourceLocation attributeRL = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute);
        String opString = SpellsUtil.operationToString(op);
        String uuidCode = " uuid_from_string('attribute' + '%s' + %s + %s + %s) ".formatted(new Object[]{attributeRL.m_135815_(), BuiltinVariables.SPELL_SLOT, "operation", "value"});
        Spell spell = new Spell((SpellIcon)LayeredSpellIcon.make(List.of(spellIcon, DefaultSpellIcon.make(PERMANENT_ICON_RL))), (Component)Component.m_237110_((String)key, (Object[])new Object[]{component}), 0.0f).addAction(AddAttributeModifierAction.make((Object)BuiltinEvents.ON_EQUIP, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(attribute, ForgeRegistries.ATTRIBUTES), Compiler.compileString(uuidCode, STRING), STRING.immediate(attributeRL.m_135815_()), DOUBLE.immediate(value), STRING.immediate(opString))).addAction(RemoveAttributeModifierAction.make((Object)BuiltinEvents.ON_UNEQUIP, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(attribute, ForgeRegistries.ATTRIBUTES), Compiler.compileString(uuidCode, STRING))).addParameter(DOUBLE, "value", value).addParameter(STRING, "operation", opString).addEventHook((Object)BuiltinEvents.ON_EQUIP).addEventHook((Object)BuiltinEvents.ON_UNEQUIP).addTooltip((Component)Component.m_237110_((String)descKey, (Object[])new Object[]{component.m_6881_().m_130940_(ChatFormatting.BLUE)}));
        spell.addTooltip((Component)Component.m_237119_());
        spell.addTooltip((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
        double d = op != AttributeModifier.Operation.MULTIPLY_BASE && op != AttributeModifier.Operation.MULTIPLY_TOTAL ? value : value * 100.0;
        if (value > 0.0) {
            spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.plus." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d), component.m_6881_()}).m_130940_(ChatFormatting.BLUE));
        } else if (value < 0.0) {
            spell.addTooltip((Component)Component.m_237110_((String)("attribute.modifier.take." + op.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d *= -1.0), component.m_6881_()}).m_130940_(ChatFormatting.RED));
        }
        this.addSpell(rl, spell);
    }

    public void addPermanentWalkerSpell(ResourceLocation rl, String key, String descKey, String icon, FluidType from, BlockState to, boolean tick) {
        ResourceLocation fromRL = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)from);
        ResourceLocation toRL = ForgeRegistries.BLOCKS.getKey((Object)to.m_60734_());
        String uuidCode = " uuid_from_string('permanent_walker' + '%s' + %s) ".formatted(new Object[]{rl.toString(), BuiltinVariables.SPELL_SLOT});
        Spell spell = new Spell((SpellIcon)LayeredSpellIcon.make(List.of(DefaultSpellIcon.make(new ResourceLocation(this.modId, "textures/spell/" + icon + ".png")), DefaultSpellIcon.make(PERMANENT_ICON_RL))), key, 0.0f).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ON_EQUIP, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ON_UNEQUIP, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make("apply", "player", (Object)BuiltinTargetGroups.HOLDER)).addAction(PutVarAction.makeString((Object)BuiltinEvents.ON_EQUIP, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.makeString((Object)BuiltinEvents.ON_UNEQUIP, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.moveString("apply", (Object)BuiltinVariables.DELAY_UUID, "uuid")).addAction(ActivateAction.make((Object)BuiltinEvents.ON_EQUIP, "apply")).addAction(ActivateAction.make((Object)BuiltinEvents.ON_UNEQUIP, "remove")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ON_EQUIP, INT.immediate(0), (Object)"time")).addAction(PutVarAction.makeInt((Object)"apply", Compiler.compileString(" get_nbt_int(" + BuiltinVariables.DELAY_TAG + ", 'time') ", INT), (Object)"time")).addAction(RemoveDelayedSpellAction.make("remove", "player", STRING.reference("uuid"), BOOLEAN.immediate(false))).addAction(DeactivateAction.make("remove", "apply")).addAction(PlaySoundAction.make("remove", "player", SoundEvents.f_12436_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(ActivateAction.make("apply", "renew")).addAction(OffsetBlockAction.make("apply", "player", "above", this.ZERO_VEC3)).addAction(GetBlockAction.make("apply", "above", "", "", "is_air")).addAction(BooleanActivationAction.make("apply", "apply", BOOLEAN.reference(" is_air "), BOOLEAN.immediate(false), BOOLEAN.immediate(true))).addAction(OffsetBlockAction.make("apply", "player", "below", VEC3.immediate(new Vec3(0.0, -1.0, 0.0)))).addAction(CubeBlockTargetsAction.make("apply", "below", "blocks", Compiler.compileString(" vec3(-rect_radius, 0, -rect_radius) ", VEC3), Compiler.compileString(" vec3(rect_radius, 0, rect_radius) ", VEC3))).addAction(LabelAction.make("apply", "loop")).addAction(ClearTargetsAction.make("apply", "block")).addAction(PickTargetAction.make("apply", "block", "blocks", true, false)).addAction(GetFluidAction.make("apply", "block", "fluid_id", "", "", "is_source")).addAction(BooleanActivationAction.make("apply", "do_apply", BOOLEAN.reference(" is_source && fluid_id == '" + fromRL.toString() + "' "), BOOLEAN.immediate(true), BOOLEAN.immediate(true))).addAction(SetBlockAction.make("do_apply", "block", STRING.reference("block_to"), TAG.reference("block_state_to")));
        if (tick) {
            spell.addAction(TickBlockAction.make("apply", "block", Compiler.compileString(" next_int(60) + 60 ", INT)));
        }
        spell.addAction(GetTargetGroupSizeAction.make("apply", "blocks", "size")).addAction(BranchAction.make("apply", "loop", Compiler.compileString(" size > 0 ", BOOLEAN))).addAction(ActivateAction.make("apply", "sound")).addAction(ActivateAction.make("apply", "anti_sound")).addAction(DeactivateAction.make((Object)BuiltinEvents.ON_EQUIP, "anti_sound")).addAction(DeactivateAction.make("anti_sound", "sound")).addAction(PlaySoundAction.make("sound", "player", SoundEvents.f_11911_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(AddDelayedSpellAction.make("renew", "player", "apply", INT.reference("refresh_rate"), STRING.reference("uuid"), Compiler.compileString(" put_nbt_int(new_tag(), 'time', time + refresh_rate) ", TAG), new HashMap<String, String>())).addParameter(INT, "refresh_rate", 2).addParameter(STRING, "block_from", fromRL.toString()).addParameter(STRING, "block_to", toRL.toString()).addParameter(TAG, "block_state_to", SpellsUtil.stateToTag(to)).addParameter(INT, "rect_radius", 3).addEventHook((Object)BuiltinEvents.ON_EQUIP).addEventHook((Object)BuiltinEvents.ON_UNEQUIP).addTooltip((Component)Component.m_237115_((String)descKey));
        this.addSpell(rl, spell);
    }

    public void addTemporaryWalkerSpell(ResourceLocation rl, String key, String descKey, String icon, FluidType from, BlockState to, float manaCost, boolean tick, int duration) {
        ResourceLocation fromRL = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)from);
        ResourceLocation toRL = ForgeRegistries.BLOCKS.getKey((Object)to.m_60734_());
        String uuidCode = " uuid_from_string('temporary_walker' + '%s' + %s) ".formatted(new Object[]{rl.toString(), BuiltinVariables.SPELL_SLOT});
        Spell spell = new Spell((SpellIcon)LayeredSpellIcon.make(List.of(DefaultSpellIcon.make(new ResourceLocation(this.modId, "textures/spell/" + icon + ".png")), DefaultSpellIcon.make(TEMPORARY_ICON_RL))), key, manaCost).addAction(ManaCheckAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ACTIVE, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make("apply", "player", (Object)BuiltinTargetGroups.HOLDER)).addAction(PutVarAction.makeString((Object)BuiltinEvents.ACTIVE, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.moveString("apply", (Object)BuiltinVariables.DELAY_UUID, "uuid")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, INT.immediate(0), (Object)"time")).addAction(PutVarAction.makeInt((Object)"apply", Compiler.compileString(" get_nbt_int(" + BuiltinVariables.DELAY_TAG + ", 'time') ", INT), (Object)"time")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "apply")).addAction(ActivateAction.make("apply", "remove")).addAction(BooleanActivationAction.make("apply", "renew", Compiler.compileString(" time < duration ", BOOLEAN), BOOLEAN.immediate(true), BOOLEAN.immediate(false))).addAction(DeactivateAction.make("renew", "remove")).addAction(PlaySoundAction.make("remove", "player", SoundEvents.f_12436_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(OffsetBlockAction.make("apply", "player", "above", this.ZERO_VEC3)).addAction(GetBlockAction.make("apply", "above", "", "", "is_air")).addAction(BooleanActivationAction.make("apply", "apply", BOOLEAN.reference(" is_air "), BOOLEAN.immediate(false), BOOLEAN.immediate(true))).addAction(OffsetBlockAction.make("apply", "player", "below", VEC3.immediate(new Vec3(0.0, -1.0, 0.0)))).addAction(CubeBlockTargetsAction.make("apply", "below", "blocks", Compiler.compileString(" vec3(-rect_radius, 0, -rect_radius) ", VEC3), Compiler.compileString(" vec3(rect_radius, 0, rect_radius) ", VEC3))).addAction(LabelAction.make("apply", "loop")).addAction(ClearTargetsAction.make("apply", "block")).addAction(PickTargetAction.make("apply", "block", "blocks", true, false)).addAction(GetFluidAction.make("apply", "block", "fluid_id", "", "", "is_source")).addAction(BooleanActivationAction.make("apply", "do_apply", BOOLEAN.reference(" is_source && fluid_id == '" + fromRL.toString() + "' "), BOOLEAN.immediate(true), BOOLEAN.immediate(true))).addAction(SetBlockAction.make("do_apply", "block", STRING.reference("block_to"), TAG.reference("block_state_to")));
        if (tick) {
            spell.addAction(TickBlockAction.make("apply", "block", Compiler.compileString(" next_int(60) + 60 ", INT)));
        }
        spell.addAction(GetTargetGroupSizeAction.make("apply", "blocks", "size")).addAction(BranchAction.make("apply", "loop", Compiler.compileString(" size > 0 ", BOOLEAN))).addAction(ActivateAction.make("apply", "sound")).addAction(ActivateAction.make("apply", "anti_sound")).addAction(DeactivateAction.make((Object)BuiltinEvents.ACTIVE, "anti_sound")).addAction(DeactivateAction.make("anti_sound", "sound")).addAction(PlaySoundAction.make("sound", "player", SoundEvents.f_11911_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(AddDelayedSpellAction.make("renew", "player", "apply", INT.reference("refresh_rate"), STRING.reference("uuid"), Compiler.compileString(" put_nbt_int(new_tag(), 'time', time + refresh_rate) ", TAG), new HashMap<String, String>())).addParameter(INT, "duration", duration).addParameter(INT, "refresh_rate", 2).addParameter(STRING, "block_from", fromRL.toString()).addParameter(STRING, "block_to", toRL.toString()).addParameter(TAG, "block_state_to", SpellsUtil.stateToTag(to)).addParameter(INT, "rect_radius", 3).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)descKey));
        this.addSpell(rl, spell);
    }

    public void addToggleWalkerSpell(ResourceLocation rl, String key, String descKey, String icon, FluidType from, BlockState to, float manaCost, boolean tick) {
        ResourceLocation fromRL = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)from);
        ResourceLocation toRL = ForgeRegistries.BLOCKS.getKey((Object)to.m_60734_());
        String uuidCode = " uuid_from_string('toggle_walker' + '%s' + %s) ".formatted(new Object[]{rl.toString(), BuiltinVariables.SPELL_SLOT});
        Spell spell = new Spell((SpellIcon)LayeredSpellIcon.make(List.of(DefaultSpellIcon.make(new ResourceLocation(this.modId, "textures/spell/" + icon + ".png")), DefaultSpellIcon.make(TOGGLE_ICON_RL))), key, manaCost).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ACTIVE, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make((Object)BuiltinEvents.ON_UNEQUIP, "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make("apply", "player", (Object)BuiltinTargetGroups.HOLDER)).addAction(PutVarAction.makeString((Object)BuiltinEvents.ACTIVE, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.makeString((Object)BuiltinEvents.ON_UNEQUIP, Compiler.compileString(uuidCode, STRING), (Object)"uuid")).addAction(PutVarAction.moveString("apply", (Object)BuiltinVariables.DELAY_UUID, "uuid")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "apply")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "remove")).addAction(CheckHasDelayedSpellAction.make("remove", "player", STRING.reference("uuid"))).addAction(ActivateAction.make((Object)BuiltinEvents.ON_UNEQUIP, "remove")).addAction(RemoveDelayedSpellAction.make("remove", "player", STRING.reference("uuid"), BOOLEAN.immediate(false))).addAction(DeactivateAction.make("remove", "apply")).addAction(PlaySoundAction.make("remove", "player", SoundEvents.f_12436_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(ManaCheckAction.make("apply", "player", Compiler.compileString(" (" + BuiltinVariables.MANA_COST + " * refresh_rate) / 100 ", DOUBLE))).addAction(ActivateAction.make("apply", "renew")).addAction(OffsetBlockAction.make("apply", "player", "above", this.ZERO_VEC3)).addAction(GetBlockAction.make("apply", "above", "", "", "is_air")).addAction(BooleanActivationAction.make("apply", "apply", BOOLEAN.reference(" is_air "), BOOLEAN.immediate(false), BOOLEAN.immediate(true))).addAction(OffsetBlockAction.make("apply", "player", "below", VEC3.immediate(new Vec3(0.0, -1.0, 0.0)))).addAction(CubeBlockTargetsAction.make("apply", "below", "blocks", Compiler.compileString(" vec3(-rect_radius, 0, -rect_radius) ", VEC3), Compiler.compileString(" vec3(rect_radius, 0, rect_radius) ", VEC3))).addAction(LabelAction.make("apply", "loop")).addAction(ClearTargetsAction.make("apply", "block")).addAction(PickTargetAction.make("apply", "block", "blocks", true, false)).addAction(GetFluidAction.make("apply", "block", "fluid_id", "", "", "is_source")).addAction(BooleanActivationAction.make("apply", "do_apply", BOOLEAN.reference(" is_source && fluid_id == '" + fromRL.toString() + "' "), BOOLEAN.immediate(true), BOOLEAN.immediate(true))).addAction(SetBlockAction.make("do_apply", "block", STRING.reference("block_to"), TAG.reference("block_state_to")));
        if (tick) {
            spell.addAction(TickBlockAction.make("apply", "block", Compiler.compileString(" next_int(60) + 60 ", INT)));
        }
        spell.addAction(GetTargetGroupSizeAction.make("apply", "blocks", "size")).addAction(BranchAction.make("apply", "loop", Compiler.compileString(" size > 0 ", BOOLEAN))).addAction(ActivateAction.make("apply", "sound")).addAction(ActivateAction.make("apply", "anti_sound")).addAction(DeactivateAction.make((Object)BuiltinEvents.ACTIVE, "anti_sound")).addAction(DeactivateAction.make("anti_sound", "sound")).addAction(PlaySoundAction.make("sound", "player", SoundEvents.f_11911_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(AddDelayedSpellAction.make("renew", "player", "apply", INT.reference("refresh_rate"), STRING.reference("uuid"), this.EMPTY_TAG, new HashMap<String, String>())).addParameter(INT, "refresh_rate", 2).addParameter(STRING, "block_from", fromRL.toString()).addParameter(STRING, "block_to", toRL.toString()).addParameter(TAG, "block_state_to", SpellsUtil.stateToTag(to)).addParameter(INT, "rect_radius", 3).addEventHook((Object)BuiltinEvents.ACTIVE).addEventHook((Object)BuiltinEvents.ON_UNEQUIP).addTooltip((Component)Component.m_237115_((String)descKey));
        this.addSpell(rl, spell);
    }

    protected void addSpells() {
        this.dummy(Spells.DUMMY);
        this.addSpell(Spells.LEAP, new Spell(this.modId, "leap", Spells.KEY_LEAP, 5.0f).addParameter(DOUBLE, "speed", 2.5).addAction(SimpleManaCheckAction.make((Object)BuiltinEvents.ACTIVE)).addAction(ResetFallDistanceAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER)).addAction(GetEntityPositionDirectionMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "", "look", "")).addAction(PutVarAction.makeVec3((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" (normalize(look + vec3(0, -get_y(look), 0))) * speed ", VEC3), (Object)"direction")).addAction(SetMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, Compiler.compileString(" vec3(get_x(direction), max(0.5, get_y(look) + 0.5), get_z(direction)) ", VEC3))).addAction(SpawnParticlesAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, (ParticleOptions)ParticleTypes.f_123759_, INT.immediate(4), DOUBLE.immediate(0.1))).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11893_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_LEAP_DESC)));
        CompoundTag childTag = new CompoundTag();
        childTag.m_128405_("Age", -24000);
        CompoundTag animalsTag = new CompoundTag();
        animalsTag.m_128359_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42579_).toString(), ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20557_).toString());
        animalsTag.m_128359_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42581_).toString(), ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20555_).toString());
        animalsTag.m_128359_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42485_).toString(), ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20510_).toString());
        animalsTag.m_128359_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42658_).toString(), ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20520_).toString());
        CompoundTag amountsTag = new CompoundTag();
        animalsTag.m_128405_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42579_).toString(), 8);
        animalsTag.m_128405_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42581_).toString(), 8);
        animalsTag.m_128405_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42485_).toString(), 8);
        animalsTag.m_128405_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42658_).toString(), 8);
        this.addSpell(Spells.SUMMON_ANIMAL, new Spell(this.modId, "summon_animal", Spells.KEY_SUMMON_ANIMAL, 4.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "cow")).addAction(MainhandItemTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "item")).addAction(GetItemAttributesAction.make((Object)BuiltinEvents.ACTIVE, "item", "item_id", "amount", "", "")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "spawn", Compiler.compileString(" nbt_contains(animals, item_id) && nbt_contains(amounts, item_id) && amount >= (!item_costs() ? 1 : get_nbt_int(amounts, item_id)) ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "offhand")).addAction(DeactivateAction.make("spawn", "offhand")).addAction(ClearTargetsAction.make("offhand", "item")).addAction(OffhandItemTargetAction.make("offhand", (Object)BuiltinTargetGroups.OWNER, "item")).addAction(BooleanActivationAction.make("offhand", "spawn", Compiler.compileString(" nbt_contains(animals, item_id) && nbt_contains(amounts, item_id) && amount >= get_nbt_int(amounts, item_id) ", BOOLEAN), this.TRUE, this.FALSE)).addAction(SpawnEntityAction.make("spawn", "baby", SpellsUtil.objectToString(EntityType.f_20520_, ForgeRegistries.ENTITY_TYPES), (Object)BuiltinTargetGroups.OWNER, Compiler.compileString(" -direction ", VEC3), this.ZERO_VEC3, TAG.immediate(childTag))).addAction(BurnManaAction.make("spawn", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("spawn", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumeItemAction.make("consume", "item", Compiler.compileString(" get_nbt_int(amounts, item_id) ", INT))).addAction(SpawnParticlesAction.make("spawn", (Object)BuiltinTargetGroups.OWNER, (ParticleOptions)ParticleTypes.f_123813_, INT.immediate(3), DOUBLE.immediate(0.4))).addAction(PlaySoundAction.make("spawn", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11752_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(TAG, "animals", animalsTag).addParameter(TAG, "amounts", amountsTag).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_SUMMON_ANIMAL_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42579_, 8))).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42581_, 8))).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42485_, 8))).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42658_, 8))));
        this.addSpell(Spells.FIRE_BALL, new Spell(this.modId, "fire_ball", Spells.KEY_FIRE_BALL, 5.0f).addParameter(DOUBLE, "speed", 2.5).addParameter(INT, "fire_seconds", 2).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "consume", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42593_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "consume")).addAction(ActivateAction.make("consume", "shoot")).addAction(BurnManaAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("consume", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.FALSE, this.TRUE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42593_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(ShootAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, DOUBLE.immediate(3.0), DOUBLE.immediate(0.0), INT.immediate(200), "on_block_hit", "on_entity_hit", "on_timeout", "projectile")).addAction(PlaySoundAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11705_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(ParticleEmitterAction.make("shoot", "projectile", INT.immediate(200), INT.immediate(2), INT.immediate(3), DOUBLE.immediate(0.2), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123755_)).addAction(ParticleEmitterAction.make("shoot", "projectile", INT.immediate(200), INT.immediate(4), INT.immediate(1), DOUBLE.immediate(0.0), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123756_)).addAction(ParticleEmitterAction.make("shoot", "projectile", INT.immediate(200), INT.immediate(4), INT.immediate(2), DOUBLE.immediate(0.1), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123762_)).addAction(ParticleEmitterAction.make("shoot", "projectile", INT.immediate(200), INT.immediate(4), INT.immediate(2), DOUBLE.immediate(0.1), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123744_)).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(SourcedDamageAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, DOUBLE.immediate(2.0), (Object)BuiltinTargetGroups.PROJECTILE)).addAction(SetOnFireAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, INT.reference("fire_seconds"))).addAction(ActivateAction.make("on_entity_hit", "fx")).addAction(ActivateAction.make("on_block_hit", "fx")).addAction(ActivateAction.make("on_timeout", "fx")).addAction(PlaySoundAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, SoundEvents.f_11705_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(SpawnParticlesAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, (ParticleOptions)ParticleTypes.f_123755_, INT.immediate(3), DOUBLE.immediate(0.2))).addAction(SpawnParticlesAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, (ParticleOptions)ParticleTypes.f_123756_, INT.immediate(1), DOUBLE.immediate(0.2))).addAction(SpawnParticlesAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, (ParticleOptions)ParticleTypes.f_123762_, INT.immediate(2), DOUBLE.immediate(0.1))).addAction(SpawnParticlesAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, (ParticleOptions)ParticleTypes.f_123744_, INT.immediate(2), DOUBLE.immediate(0.1))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_FIRE_BALL_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42593_))));
        CompoundTag blastRecipes = SpellsGen.blastFurnaceRecipes();
        this.addSpell(Spells.BLAST_SMELT, new Spell(this.modId, "blast_smelt", Spells.KEY_BLAST_SMELT, 4.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(MainhandItemTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "item")).addAction(GetItemAttributesAction.make((Object)BuiltinEvents.ACTIVE, "item", "item_id", "amount", "", "")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "smelt", Compiler.compileString(" nbt_contains(recipes, item_id) ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "offhand")).addAction(DeactivateAction.make("smelt", "offhand")).addAction(ClearTargetsAction.make("offhand", "item")).addAction(OffhandItemTargetAction.make("offhand", (Object)BuiltinTargetGroups.OWNER, "item")).addAction(BooleanActivationAction.make("offhand", "smelt", Compiler.compileString(" nbt_contains(recipes, item_id) ", BOOLEAN), this.TRUE, this.FALSE)).addAction(BurnManaAction.make("smelt", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("smelt", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumeItemAction.make("consume", "item", INT.immediate(1))).addAction(GiveItemAction.make("smelt", (Object)BuiltinTargetGroups.OWNER, INT.immediate(1), INT.immediate(0), this.EMPTY_TAG, Compiler.compileString(" get_nbt_string(recipes, item_id) ", STRING))).addParameter(TAG, "recipes", blastRecipes).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_BLAST_SMELT_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.textItemCostComponent((Component)Component.m_237115_((String)Spells.KEY_BLAST_SMELT_DESC_COST), 1)));
        this.addSpell(Spells.TRANSFER_MANA, new Spell(this.modId, "transfer_mana", Spells.KEY_TRANSFER_MANA, 4.0f).addParameter(DOUBLE, "speed", 2.5).addParameter(DOUBLE, "range", 25.0).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(LookAtTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("range"), 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, "looked_at_block", "looked_at_entity", "looked_at_nothing")).addAction(BurnManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(HomeAction.make("looked_at_entity", (Object)BuiltinTargetGroups.OWNER, (Object)BuiltinTargetGroups.ENTITY_HIT, DOUBLE.immediate(3.0), INT.immediate(200), "on_block_hit", "on_entity_hit", "on_timeout", "")).addAction(PlaySoundAction.make("looked_at_entity", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11775_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(ReplenishManaAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ActivateAction.make("on_entity_hit", "fx")).addAction(ActivateAction.make("on_block_hit", "fx")).addAction(ActivateAction.make("on_timeout", "fx")).addAction(PlaySoundAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, SoundEvents.f_11775_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(SpawnParticlesAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, (ParticleOptions)ParticleTypes.f_123795_, INT.immediate(3), DOUBLE.immediate(0.2))).addAction(SpawnParticlesAction.make("fx", (Object)BuiltinTargetGroups.HIT_POSITION, (ParticleOptions)ParticleTypes.f_123759_, INT.immediate(2), DOUBLE.immediate(0.2))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_TRANSFER_MANA_DESC)));
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("crit", true);
        tag.m_128405_("pickup", 1);
        this.addSpell(Spells.BLOW_ARROW, new Spell(this.modId, "blow_arrow", Spells.KEY_BLOW_ARROW, 5.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(PutVarAction.makeCompoundTag((Object)BuiltinEvents.ACTIVE, tag, (Object)"tag")).addAction(GetEntityUUIDAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "uuid")).addAction(PutVarAction.makeCompoundTag((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" put_nbt_uuid(tag, 'Owner', uuid) ", TAG), (Object)"tag")).addAction(GetEntityPositionDirectionMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "", "direction", "")).addAction(GetEntityEyePositionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "position")).addAction(MainhandItemTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "item")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "shoot")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "potion")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "spectral")).addAction(ItemEqualsAction.make("shoot", "item", new ItemStack((ItemLike)Items.f_42412_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(ItemEqualsAction.make("potion", "item", new ItemStack((ItemLike)Items.f_42738_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(GetItemTagAction.make("potion", "item", "potion_tag")).addAction(PutVarAction.makeCompoundTag((Object)"potion", Compiler.compileString(" put_nbt_string(tag, 'Potion', get_nbt_string(potion_tag, 'Potion')) ", TAG), (Object)"tag")).addAction(ActivateAction.make("potion", "shoot")).addAction(BurnManaAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(SpawnEntityAction.make("shoot", "arrow", SpellsUtil.objectToString(EntityType.f_20548_, ForgeRegistries.ENTITY_TYPES), "position", VEC3.reference("direction"), Compiler.compileString(" 3 * direction ", VEC3), TAG.reference("tag"))).addAction(PlaySoundAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11687_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(ItemEqualsAction.make("spectral", "item", new ItemStack((ItemLike)Items.f_42737_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(HasManaAction.make("spectral", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(SpawnEntityAction.make("spectral", "arrow", SpellsUtil.objectToString(EntityType.f_20478_, ForgeRegistries.ENTITY_TYPES), "position", VEC3.reference("direction"), Compiler.compileString(" 3 * direction ", VEC3), TAG.reference("tag"))).addAction(PlaySoundAction.make("spectral", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11687_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(ActivateAction.make("shoot", "consume")).addAction(ActivateAction.make("spectral", "consume")).addAction(BooleanActivationAction.make("consume", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.FALSE, this.TRUE)).addAction(ConsumeItemAction.make("consume", "item", INT.immediate(1))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_BLOW_ARROW_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42412_))).addTooltip(SpellsGen.itemCostComponent(Items.f_42738_)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42737_))));
        this.addPermanentAttributeSpell(Spells.HEALTH_BOOST, Spells.KEY_HEALTH_BOOST, Spells.KEY_HEALTH_BOOST_DESC, DefaultSpellIcon.make(new ResourceLocation("textures/mob_effect/" + ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19616_).m_135815_() + ".png")), Attributes.f_22276_, AttributeModifier.Operation.ADDITION, 4.0);
        this.addPermanentAttributeSpell(Spells.MANA_BOOST, Spells.KEY_MANA_BOOST, Spells.KEY_MANA_BOOST_DESC, DefaultSpellIcon.make(new ResourceLocation("spells_and_shields", "textures/mob_effect/" + BuiltinRegistries.MANA_BOOST_EFFECT.getId().m_135815_() + ".png")), (Attribute)BuiltinRegistries.MAX_MANA_ATTRIBUTE.get(), AttributeModifier.Operation.ADDITION, 4.0);
        this.addSpell(Spells.WATER_LEAP, new Spell(this.modId, "water_leap", Spells.KEY_WATER_LEAP, 5.0f).addParameter(DOUBLE, "speed", 2.5).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(GetEntityEyePositionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "eye_pos")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "feet_block", "", "")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, "eye_pos", "eye_block", "", "")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinEvents.ACTIVE, Compiler.compileString(" feet_block == '" + ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_49990_).toString() + "' && eye_block == '" + ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_49990_).toString() + "' ", BOOLEAN), this.FALSE, this.TRUE)).addAction(BurnManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ResetFallDistanceAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER)).addAction(GetEntityPositionDirectionMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "", "look", "")).addAction(PutVarAction.makeVec3((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" (normalize(look + vec3(0, -get_y(look), 0))) * speed ", VEC3), (Object)"direction")).addAction(SetMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, Compiler.compileString(" vec3(get_x(direction), max(0.5, get_y(look) + 0.5), get_z(direction)) ", VEC3))).addAction(SpawnParticlesAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, (ParticleOptions)ParticleTypes.f_123759_, INT.immediate(4), DOUBLE.immediate(0.1))).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11893_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_WATER_LEAP_DESC)));
        ResourceLocation hasteRL = ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19598_);
        ResourceLocation waterBreathingRL = ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19608_);
        this.addSpell(Spells.PERMANENT_AQUA_AFFINITY, new Spell((SpellIcon)LayeredSpellIcon.make(List.of(DefaultSpellIcon.make(new ResourceLocation(hasteRL.m_135827_(), "textures/mob_effect/" + hasteRL.m_135815_() + ".png")), DefaultSpellIcon.make(new ResourceLocation(waterBreathingRL.m_135827_(), "textures/mob_effect/" + waterBreathingRL.m_135815_() + ".png")))), Spells.KEY_PERMANENT_AQUA_AFFINITY, 0.0f).addAction(GetEntityEyePositionAction.make((Object)BuiltinEvents.PLAYER_BREAK_SPEED, (Object)BuiltinTargetGroups.OWNER, "eye_pos")).addAction(GetBlockAction.make((Object)BuiltinEvents.PLAYER_BREAK_SPEED, "eye_pos", "block_type", "", "")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.PLAYER_BREAK_SPEED, "boost", Compiler.compileString(" block_type == '" + ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_49990_) + "' ", BOOLEAN), this.TRUE, this.TRUE)).addAction(PutVarAction.makeDouble((Object)"boost", Compiler.compileString(" new_speed * 5 ", DOUBLE), (Object)"new_speed")).addEventHook((Object)BuiltinEvents.PLAYER_BREAK_SPEED).addTooltip((Component)Component.m_237115_((String)Spells.KEY_PERMANENT_AQUA_AFFINITY_DESC)));
        this.addSpell(Spells.WATER_WHIP, new Spell(this.modId, "water_whip", Spells.KEY_WATER_WHIP, 5.0f).addParameter(DOUBLE, "damage", 10.0).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(MainhandItemTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "item")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "shoot")).addAction(ItemEqualsAction.make("shoot", "item", new ItemStack((ItemLike)Items.f_42447_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "offhand")).addAction(DeactivateAction.make("shoot", "offhand")).addAction(ClearTargetsAction.make("offhand", "item")).addAction(OffhandItemTargetAction.make("offhand", (Object)BuiltinTargetGroups.OWNER, "item")).addAction(ActivateAction.make("offhand", "shoot")).addAction(ItemEqualsAction.make("shoot", "item", new ItemStack((ItemLike)Items.f_42447_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(GetItemAttributesAction.make("shoot", "item", "item", "amount", "damage", "item_tag")).addAction(BooleanActivationAction.make("shoot", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(OverrideItemAction.make("consume", "item", INT.reference("amount"), INT.reference("damage"), TAG.reference("item_tag"), SpellsUtil.objectToString(Items.f_42446_, ForgeRegistries.ITEMS))).addAction(GetEntityUUIDAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, "owner_uuid_return")).addAction(PutVarAction.makeCompoundTag((Object)"shoot", Compiler.compileString(" put_nbt_uuid(new_tag(), 'owner_uuid_return', owner_uuid_return) ", TAG), (Object)"tag")).addAction(BurnManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ShootAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, DOUBLE.immediate(1.0), DOUBLE.immediate(0.0), INT.immediate(100), "on_block_hit", "on_entity_hit", "on_timeout", "projectile")).addAction(ParticleEmitterAction.make("shoot", "projectile", INT.immediate(100), INT.immediate(1), INT.immediate(5), DOUBLE.immediate(0.5), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123804_)).addAction(ApplyEntityExtraTagAction.make("shoot", "projectile", TAG.reference("tag"))).addAction(PlaySoundAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11778_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(SourcedDamageAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, DOUBLE.immediate(10.0), (Object)BuiltinTargetGroups.PROJECTILE)).addAction(CopyTargetsAction.make("on_entity_hit", "position", (Object)BuiltinTargetGroups.HIT_POSITION)).addAction(ActivateAction.make("on_entity_hit", "return")).addAction(CopyTargetsAction.make("on_block_hit", "position", (Object)BuiltinTargetGroups.HIT_POSITION)).addAction(ActivateAction.make("on_block_hit", "return")).addAction(CopyTargetsAction.make("on_timeout", "position", (Object)BuiltinTargetGroups.PROJECTILE)).addAction(ActivateAction.make("on_timeout", "return")).addAction(GetEntityExtraTagAction.make("return", (Object)BuiltinTargetGroups.PROJECTILE, "tag")).addAction(EntityUUIDTargetAction.make("return", "return_target", Compiler.compileString(" get_nbt_uuid(tag, 'owner_uuid_return') ", STRING))).addAction(HomeAction.make("return", "position", "return_target", DOUBLE.immediate(1.0), INT.immediate(100), "dummy_block_hit", "on_entity_hit_return", "dummy_timeout", "projectile")).addAction(ParticleEmitterAction.make("return", "projectile", INT.immediate(100), INT.immediate(1), INT.immediate(5), DOUBLE.immediate(0.1), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123804_)).addAction(ApplyEntityExtraTagAction.make("return", "projectile", TAG.reference("tag"))).addAction(GetEntityTypeAction.make("on_entity_hit_return", (Object)BuiltinTargetGroups.ENTITY_HIT, "", "", "is_player")).addAction(GetEntityUUIDAction.make("on_entity_hit_return", (Object)BuiltinTargetGroups.ENTITY_HIT, "hit_uuid")).addAction(GetEntityExtraTagAction.make("on_entity_hit_return", (Object)BuiltinTargetGroups.PROJECTILE, "tag")).addAction(BooleanActivationAction.make("on_entity_hit_return", "refill", Compiler.compileString(" is_player && (hit_uuid == get_nbt_uuid(tag, 'owner_uuid_return')) ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MainhandItemTargetAction.make("refill", (Object)BuiltinTargetGroups.ENTITY_HIT, "item")).addAction(ActivateAction.make("refill", "do_refill")).addAction(ItemEqualsAction.make("do_refill", "item", new ItemStack((ItemLike)Items.f_42446_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(ActivateAction.make("refill", "refill_offhand")).addAction(DeactivateAction.make("do_refill", "refill_offhand")).addAction(ClearTargetsAction.make("refill_offhand", "item")).addAction(OffhandItemTargetAction.make("refill_offhand", (Object)BuiltinTargetGroups.ENTITY_HIT, "item")).addAction(ActivateAction.make("refill_offhand", "do_refill")).addAction(ItemEqualsAction.make("do_refill", "item", new ItemStack((ItemLike)Items.f_42446_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(GetItemAttributesAction.make("do_refill", "item", "item", "amount", "damage", "item_tag")).addAction(OverrideItemAction.make("do_refill", "item", INT.immediate(1), INT.reference("amount"), TAG.reference("item_tag"), SpellsUtil.objectToString(Items.f_42447_, ForgeRegistries.ITEMS))).addAction(GiveItemAction.make("do_refill", "item", Compiler.compileString(" amount - 1 ", INT), INT.reference("amount"), TAG.reference("item_tag"), SpellsUtil.objectToString(Items.f_42446_, ForgeRegistries.ITEMS))).addAction(PlaySoundAction.make("do_refill", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11781_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_WATER_WHIP_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42447_))));
        this.addSpell(Spells.POTION_SHOT, new Spell(this.modId, "potion_shot", Spells.KEY_POTION_SHOT, 5.0f).addParameter(DOUBLE, "damage", 10.0).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(MainhandItemTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "item")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "shoot")).addAction(ItemEqualsAction.make("shoot", "item", new ItemStack((ItemLike)Items.f_42589_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "offhand")).addAction(DeactivateAction.make("shoot", "offhand")).addAction(ClearTargetsAction.make("offhand", "item")).addAction(OffhandItemTargetAction.make("offhand", (Object)BuiltinTargetGroups.OWNER, "item")).addAction(ActivateAction.make("offhand", "shoot")).addAction(ItemEqualsAction.make("shoot", "item", new ItemStack((ItemLike)Items.f_42589_), this.TRUE, INT.immediate(1), INT.immediate(-1))).addAction(GetItemAttributesAction.make("shoot", "item", "item", "amount", "damage", "item_tag")).addAction(BooleanActivationAction.make("shoot", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(OverrideItemAction.make("consume", "item", INT.reference("amount"), INT.reference("damage"), TAG.reference("item_tag"), SpellsUtil.objectToString(Items.f_42590_, ForgeRegistries.ITEMS))).addAction(PutVarAction.makeCompoundTag((Object)"shoot", Compiler.compileString(" put_nbt_string(new_tag(), 'Potion', get_nbt_string(item_tag, 'Potion')) ", TAG), (Object)"tag")).addAction(BurnManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ShootAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, DOUBLE.immediate(2.0), DOUBLE.immediate(0.0), INT.immediate(100), "", "on_entity_hit", "", "projectile")).addAction(ApplyEntityExtraTagAction.make("shoot", "projectile", TAG.reference("tag"))).addAction(PlaySoundAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11769_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(GetEntityExtraTagAction.make("on_entity_hit", (Object)BuiltinTargetGroups.PROJECTILE, "tag")).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(ApplyPotionEffectAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, Compiler.compileString(" get_nbt_string(tag, 'Potion') ", STRING))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_POTION_SHOT_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(Items.f_42589_)));
        this.addPermanentWalkerSpell(Spells.PERMANENT_FROST_WALKER, Spells.KEY_PERMANENT_FROST_WALKER, Spells.KEY_PERMANENT_FROST_WALKER_DESC, "frost_walker", Fluids.f_76193_.getFluidType(), Blocks.f_50449_.m_49966_(), true);
        this.addTemporaryWalkerSpell(Spells.TEMPORARY_FROST_WALKER, Spells.KEY_TEMPORARY_FROST_WALKER, Spells.KEY_TEMPORARY_FROST_WALKER_DESC, "frost_walker", Fluids.f_76193_.getFluidType(), Blocks.f_50449_.m_49966_(), 16.0f, true, 400);
        this.addToggleWalkerSpell(Spells.TOGGLE_FROST_WALKER, Spells.KEY_TOGGLE_FROST_WALKER, Spells.KEY_TOGGLE_FROST_WALKER_DESC, "frost_walker", Fluids.f_76193_.getFluidType(), Blocks.f_50449_.m_49966_(), 5.0f, true);
        this.addSpell(Spells.JUMP, new Spell(this.modId, "jump", Spells.KEY_JUMP, 5.0f).addParameter(DOUBLE, "speed", 1.5).addAction(SimpleManaCheckAction.make((Object)BuiltinEvents.ACTIVE)).addAction(ResetFallDistanceAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER)).addAction(GetEntityPositionDirectionMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "", "", "motion")).addAction(SetMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, Compiler.compileString(" vec3(0, get_y(motion) + speed, 0) ", VEC3))).addAction(SpawnParticlesAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, (ParticleOptions)ParticleTypes.f_123759_, INT.immediate(4), DOUBLE.immediate(0.1))).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11893_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_JUMP_DESC)));
        this.addSpell(Spells.MANA_SOLES, new Spell(this.modId, "mana_soles", Spells.KEY_MANA_SOLES, 0.0f).addAction(BooleanActivationAction.make((Object)BuiltinEvents.LIVING_HURT, "reduce", Compiler.compileString(" damage_type == '" + DamageSource.f_19315_.m_19385_() + "' ", BOOLEAN), this.TRUE, this.TRUE)).addAction(GetManaAction.make("reduce", (Object)BuiltinTargetGroups.OWNER, "mana")).addAction(PutVarAction.makeDouble((Object)"reduce", Compiler.compileString(" min(mana, damage_amount) ", DOUBLE), (Object)"reduce_amount")).addAction(PutVarAction.makeBoolean((Object)"reduce", Compiler.compileString(" " + BuiltinVariables.EVENT_IS_CANCELED.toString() + " || (reduce_amount >= damage_amount) ", BOOLEAN), (Object)BuiltinVariables.EVENT_IS_CANCELED)).addAction(BurnManaAction.make("reduce", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("reduce_amount"))).addAction(PutVarAction.makeDouble((Object)"reduce", Compiler.compileString(" damage_amount - reduce_amount ", DOUBLE), (Object)"damage_amount")).addEventHook((Object)BuiltinEvents.LIVING_HURT).addTooltip((Component)Component.m_237115_((String)Spells.KEY_MANA_SOLES_DESC)));
        this.addSpell(Spells.FIRE_CHARGE, new Spell((SpellIcon)ItemSpellIcon.make(new ItemStack((ItemLike)Items.f_42613_)), Spells.KEY_FIRE_CHARGE, 5.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "consume", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42613_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "consume")).addAction(ActivateAction.make("consume", "shoot")).addAction(BurnManaAction.make("consume", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("consume", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.FALSE, this.TRUE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42613_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(GetEntityUUIDAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, "uuid")).addAction(GetEntityPositionDirectionMotionAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, "", "direction", "")).addAction(PutVarAction.makeCompoundTag((Object)"shoot", Compiler.compileString(" put_nbt_uuid(new_tag(), 'Owner', uuid) ", TAG), (Object)"tag")).addAction(PutVarAction.makeCompoundTag((Object)"shoot", Compiler.compileString(" put_nbt_vec3(tag, 'power', direction * 2.0 * 0.1) ", TAG), (Object)"tag")).addAction(GetEntityEyePositionAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, "position")).addAction(SpawnEntityAction.make("shoot", "fire_charge", SpellsUtil.objectToString(EntityType.f_20463_, ForgeRegistries.ENTITY_TYPES), "position", VEC3.reference("direction"), this.ZERO_VEC3, TAG.reference("tag"))).addAction(PlaySoundAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11705_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_FIRE_CHARGE_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42613_))));
        this.addSpell(Spells.PRESSURIZE, new Spell(this.modId, "pressurize", Spells.KEY_PRESSURIZE, 4.0f).addAction(SimpleManaCheckAction.make((Object)BuiltinEvents.ACTIVE)).addAction(RangedEntityTargetsAction.make((Object)BuiltinEvents.ACTIVE, "targets", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("range"))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", "targets", "")).addAction(SourcedKnockbackAction.make((Object)BuiltinEvents.ACTIVE, "targets", DOUBLE.reference("knockback_strength"), (Object)BuiltinTargetGroups.OWNER)).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_12320_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(SpawnParticlesAction.make((Object)BuiltinEvents.ACTIVE, "targets", (ParticleOptions)ParticleTypes.f_123759_, INT.immediate(3), DOUBLE.immediate(0.5))).addParameter(DOUBLE, "range", 6.0).addParameter(DOUBLE, "knockback_strength", 3.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_PRESSURIZE_DESC)));
        this.addSpell(Spells.INSTANT_MINE, new Spell(this.modId, "instant_mine", Spells.KEY_INSTANT_MINE, 4.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(LookAtTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("range"), 0.0f, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, "on_block_hit", "", "")).addAction(PlayerHarvestBlockAction.make("on_block_hit", (Object)BuiltinTargetGroups.OWNER, (Object)BuiltinTargetGroups.BLOCK_HIT, Direction.UP)).addAction(GetBlockAction.make("on_block_hit", (Object)BuiltinTargetGroups.BLOCK_HIT, "", "", "is_air")).addAction(BooleanActivationAction.make("on_block_hit", "burn_mana", BOOLEAN.reference("is_air"), this.TRUE, this.FALSE)).addAction(BurnManaAction.make("burn_mana", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addParameter(DOUBLE, "range", 4.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_INSTANT_MINE_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_REQUIREMENT_TITLE)).addTooltip(SpellsGen.textItemCostComponent((Component)Component.m_237115_((String)Spells.KEY_INSTANT_MINE_DESC_REQUIREMENT), 1)));
        CompoundTag metalMap = new CompoundTag();
        metalMap.m_128347_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42749_).toString(), (double)Tiers.IRON.m_6631_());
        metalMap.m_128347_(ForgeRegistries.ITEMS.getKey((Object)Items.f_42587_).toString(), (double)Tiers.GOLD.m_6631_());
        this.addSpell(Spells.SPIT_METAL, new Spell(this.modId, "spit_metal", Spells.KEY_SPIT_METAL, 4.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(MainhandItemTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "item")).addAction(GetItemAttributesAction.make((Object)BuiltinEvents.ACTIVE, "item", "item_id", "amount", "", "")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "offhand")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "shoot", Compiler.compileString(" nbt_contains(item_damage_map, item_id) ", BOOLEAN), this.TRUE, this.FALSE)).addAction(DeactivateAction.make("shoot", "offhand")).addAction(ClearTargetsAction.make("offhand", "item")).addAction(OffhandItemTargetAction.make("offhand", (Object)BuiltinTargetGroups.OWNER, "item")).addAction(GetItemAttributesAction.make("offhand", "item", "item_id", "amount", "", "")).addAction(BooleanActivationAction.make("offhand", "shoot", Compiler.compileString(" nbt_contains(item_damage_map, item_id) ", BOOLEAN), this.TRUE, this.FALSE)).addAction(BurnManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ShootAction.make("shoot", (Object)BuiltinTargetGroups.OWNER, DOUBLE.immediate(2.0), DOUBLE.immediate(0.0), INT.immediate(100), "", "on_entity_hit", "", "projectile")).addAction(PutVarAction.makeDouble((Object)"shoot", Compiler.compileString(" base_damage + get_nbt_double(item_damage_map, item_id) ", DOUBLE), (Object)"damage")).addAction(ApplyEntityExtraTagAction.make("shoot", "projectile", Compiler.compileString(" put_nbt_double(new_tag(), 'damage', damage) ", TAG))).addAction(BooleanActivationAction.make("shoot", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumeItemAction.make("consume", "item", INT.immediate(1))).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_12098_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(GetEntityExtraTagAction.make("on_entity_hit", (Object)BuiltinTargetGroups.PROJECTILE, "damage_tag")).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(SourcedDamageAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, Compiler.compileString(" get_nbt_double(damage_tag, 'damage') ", DOUBLE), (Object)BuiltinTargetGroups.PROJECTILE)).addParameter(DOUBLE, "base_damage", 8.0).addParameter(TAG, "item_damage_map", metalMap).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_SPIT_METAL_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42749_))).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42587_))));
        this.addSpell(Spells.FLAMETHROWER, new Spell(this.modId, "flamethrower", Spells.KEY_FLAMETHROWER, 7.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42613_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "success")).addAction(ActivateAction.make("success", "shoot")).addAction(CopyTargetsAction.make("success", "player", (Object)BuiltinTargetGroups.OWNER)).addAction(BurnManaAction.make("success", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("success", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42613_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(CopyTargetsAction.make("on_timeout", "player", (Object)BuiltinTargetGroups.HOLDER)).addAction(PutVarAction.makeInt((Object)"on_timeout", Compiler.compileString(" get_nbt_int(" + BuiltinVariables.DELAY_TAG + ", 'repetitions') ", INT), (Object)"repetitions")).addAction(ActivateAction.make("on_timeout", "shoot")).addAction(LabelAction.make("shoot", "loop")).addAction(BooleanActivationAction.make("shoot", "do_shoot", Compiler.compileString(" shots_per_repetition > 0 ", BOOLEAN), this.TRUE, this.TRUE)).addAction(ShootAction.make("do_shoot", "player", DOUBLE.immediate(2.0), DOUBLE.reference("inaccuracy"), INT.immediate(20), "on_block_hit", "on_entity_hit", "", "projectile")).addAction(ParticleEmitterAction.make("do_shoot", "projectile", INT.immediate(20), INT.immediate(4), INT.immediate(1), DOUBLE.immediate(0.0), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123756_)).addAction(ParticleEmitterAction.make("do_shoot", "projectile", INT.immediate(20), INT.immediate(1), INT.immediate(1), DOUBLE.immediate(0.0), this.TRUE, this.ZERO_VEC3, (ParticleOptions)ParticleTypes.f_123762_)).addAction(PutVarAction.makeInt((Object)"do_shoot", Compiler.compileString(" shots_per_repetition - 1 ", INT), (Object)"shots_per_repetition")).addAction(JumpAction.make("do_shoot", "loop")).addAction(BooleanActivationAction.make("shoot", "repeat", Compiler.compileString(" repetitions > 1 ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlaySoundAction.make("shoot", "player", SoundEvents.f_11705_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(AddDelayedSpellAction.make("repeat", "player", "on_timeout", INT.reference("repetition_delay"), STRING.immediate(""), Compiler.compileString(" put_nbt_int(new_tag(), 'repetitions', repetitions - 1) ", TAG), new HashMap<String, String>())).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(SetOnFireAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, INT.reference("fire_seconds"))).addParameter(INT, "fire_seconds", 10).addParameter(INT, "shots_per_repetition", 3).addParameter(INT, "repetitions", 5).addParameter(INT, "repetition_delay", 4).addParameter(DOUBLE, "inaccuracy", 15.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_FLAMETHROWER_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42593_))));
        this.addPermanentWalkerSpell(Spells.PERMANENT_LAVA_WALKER, Spells.KEY_PERMANENT_LAVA_WALKER, Spells.KEY_PERMANENT_LAVA_WALKER_DESC, "lava_walker", Fluids.f_76195_.getFluidType(), Blocks.f_50080_.m_49966_(), false);
        this.addTemporaryWalkerSpell(Spells.TEMPORARY_LAVA_WALKER, Spells.KEY_TEMPORARY_LAVA_WALKER, Spells.KEY_TEMPORARY_LAVA_WALKER_DESC, "lava_walker", Fluids.f_76195_.getFluidType(), Blocks.f_50080_.m_49966_(), 16.0f, false, 400);
        this.addToggleWalkerSpell(Spells.TOGGLE_LAVA_WALKER, Spells.KEY_TOGGLE_LAVA_WALKER, Spells.KEY_TOGGLE_LAVA_WALKER_DESC, "lava_walker", Fluids.f_76195_.getFluidType(), Blocks.f_50080_.m_49966_(), 5.0f, false);
        this.addSpell(Spells.SILENCE_TARGET, new Spell((SpellIcon)DefaultSpellIcon.make(new ResourceLocation(BuiltinRegistries.SILENCE_EFFECT.getId().m_135827_(), "textures/mob_effect/" + BuiltinRegistries.SILENCE_EFFECT.getId().m_135815_() + ".png")), Spells.KEY_SILENCE_TARGET, 5.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "bypass")).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_151049_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(BooleanActivationAction.make("bypass", (Object)BuiltinEvents.ACTIVE, Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(LookAtTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("target_range"), 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, "", "on_entity_hit", "")).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(GetTargetGroupSizeAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "target_size")).addAction(BooleanActivationAction.make("no_pvp", "fail", Compiler.compileString(" target_size <= 0 ", BOOLEAN), this.TRUE, this.FALSE)).addAction(DeactivateAction.make("fail", "on_entity_hit")).addAction(BurnManaAction.make("on_entity_hit", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("on_entity_hit", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_151049_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(ApplyMobEffectAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, STRING.immediate(BuiltinRegistries.SILENCE_EFFECT.getId().toString()), INT.reference("silence_seconds"), INT.immediate(0), this.FALSE, this.TRUE, this.TRUE)).addAction(PlaySoundAction.make("on_entity_hit", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_144052_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(PlaySoundAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, SoundEvents.f_144050_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(SpawnParticlesAction.make("on_entity_hit", (Object)BuiltinTargetGroups.HIT_POSITION, (ParticleOptions)ParticleTypes.f_123759_, INT.immediate(3), DOUBLE.immediate(0.2))).addEventHook((Object)BuiltinEvents.ACTIVE).addParameter(DOUBLE, "range", 20.0).addParameter(INT, "silence_seconds", 15).addTooltip((Component)Component.m_237115_((String)Spells.KEY_SILENCE_TARGET_DESC)));
        this.addSpell(Spells.RANDOM_TELEPORT, new Spell(this.modId, "random_teleport", Spells.KEY_RANDOM_TELEPORT, 5.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "bypass")).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42730_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(BooleanActivationAction.make("bypass", (Object)BuiltinEvents.ACTIVE, Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, INT.reference("max_attempts"), (Object)"attempts")).addAction(LabelAction.make((Object)BuiltinEvents.ACTIVE, "loop")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "below")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "feet")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "head")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, INT.reference("max_inner_attempts"), (Object)"inner_attempts")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" random_double() * 2 * range - range ", DOUBLE), (Object)"x")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" min(" + BuiltinVariables.MAX_BLOCK_HEIGHT + ", max(" + BuiltinVariables.MIN_BLOCK_HEIGHT + ", random_double() * 2 * range - range)) ", DOUBLE), (Object)"y")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" random_double() * 2 * range - range ", DOUBLE), (Object)"z")).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "below", Compiler.compileString(" vec3(x, y, z) ", VEC3))).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "below", "feet", VEC3.immediate(new Vec3(0.0, 1.0, 0.0)))).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "feet", "head", VEC3.immediate(new Vec3(0.0, 1.0, 0.0)))).addAction(LabelAction.make((Object)BuiltinEvents.ACTIVE, "inner_loop")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, "below", "", "", "below_is_air")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, "feet", "", "", "feet_is_air")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, "head", "", "", "head_is_air")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !below_is_air && feet_is_air && head_is_air ", BOOLEAN), this.TRUE, this.TRUE)).addAction(DeactivateAction.make("success", (Object)BuiltinEvents.ACTIVE)).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "below")).addAction(PickTargetAction.make((Object)BuiltinEvents.ACTIVE, "below", "feet", true, false)).addAction(PickTargetAction.make((Object)BuiltinEvents.ACTIVE, "feet", "head", true, false)).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "feet", "head", VEC3.immediate(new Vec3(0.0, 1.0, 0.0)))).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" inner_attempts - 1 ", INT), (Object)"inner_attempts")).addAction(BranchAction.make((Object)BuiltinEvents.ACTIVE, "inner_loop", Compiler.compileString(" inner_attempts > 0 ", BOOLEAN))).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" attempts - 1 ", INT), (Object)"attempts")).addAction(BranchAction.make((Object)BuiltinEvents.ACTIVE, "loop", Compiler.compileString(" attempts > 0 ", BOOLEAN))).addAction(BurnManaAction.make("success", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("success", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42730_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(GetPositionAction.make("success", "feet", "feet_pos")).addAction(PutVarAction.makeDouble((Object)"success", Compiler.compileString(" get_y(feet_pos) - floor(get_y(feet_pos))", DOUBLE), (Object)"feet_pos_floor")).addAction(OffsetBlockAction.make("success", "feet", "teleport_position", Compiler.compileString("vec3(0, -feet_pos_floor, 0)", VEC3))).addAction(PlaySoundAction.make("success", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11852_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(TeleportToAction.make("success", (Object)BuiltinTargetGroups.OWNER, "teleport_position")).addAction(PlaySoundAction.make("success", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11852_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(PlaySoundAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11850_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(INT, "max_attempts", 10).addParameter(INT, "max_inner_attempts", 10).addParameter(DOUBLE, "range", 32.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_RANDOM_TELEPORT_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42730_))));
        this.addSpell(Spells.FORCED_TELEPORT, new Spell(this.modId, "forced_teleport", Spells.KEY_FORCED_TELEPORT, 10.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "bypass")).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42730_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(BooleanActivationAction.make("bypass", (Object)BuiltinEvents.ACTIVE, Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(LookAtTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("target_range"), 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, "fail", "on_entity_hit", "fail")).addAction(CopyTargetsAction.make("on_entity_hit", "player", (Object)BuiltinTargetGroups.ENTITY_HIT)).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(GetTargetGroupSizeAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "target_size")).addAction(BooleanActivationAction.make("no_pvp", "fail", Compiler.compileString(" target_size <= 0 ", BOOLEAN), this.TRUE, this.FALSE)).addAction(DeactivateAction.make("fail", (Object)BuiltinEvents.ACTIVE)).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, INT.reference("max_attempts"), (Object)"attempts")).addAction(LabelAction.make((Object)BuiltinEvents.ACTIVE, "loop")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "below")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "feet")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "head")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, INT.reference("max_inner_attempts"), (Object)"inner_attempts")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" random_double() * 2 * teleport_range - teleport_range ", DOUBLE), (Object)"x")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" min(" + BuiltinVariables.MAX_BLOCK_HEIGHT + ", max(" + BuiltinVariables.MIN_BLOCK_HEIGHT + ", random_double() * 2 * teleport_range - teleport_range)) ", DOUBLE), (Object)"y")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" random_double() * 2 * teleport_range - teleport_range ", DOUBLE), (Object)"z")).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "player", "below", Compiler.compileString(" vec3(x, y, z) ", VEC3))).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "below", "feet", VEC3.immediate(new Vec3(0.0, 1.0, 0.0)))).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "feet", "head", VEC3.immediate(new Vec3(0.0, 1.0, 0.0)))).addAction(LabelAction.make((Object)BuiltinEvents.ACTIVE, "inner_loop")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, "below", "", "", "below_is_air")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, "feet", "", "", "feet_is_air")).addAction(GetBlockAction.make((Object)BuiltinEvents.ACTIVE, "head", "", "", "head_is_air")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !below_is_air && feet_is_air && head_is_air ", BOOLEAN), this.TRUE, this.TRUE)).addAction(DeactivateAction.make("success", (Object)BuiltinEvents.ACTIVE)).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "below")).addAction(PickTargetAction.make((Object)BuiltinEvents.ACTIVE, "below", "feet", true, false)).addAction(PickTargetAction.make((Object)BuiltinEvents.ACTIVE, "feet", "head", true, false)).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "feet", "head", VEC3.immediate(new Vec3(0.0, 1.0, 0.0)))).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" inner_attempts - 1 ", INT), (Object)"inner_attempts")).addAction(BranchAction.make((Object)BuiltinEvents.ACTIVE, "inner_loop", Compiler.compileString(" inner_attempts > 0 ", BOOLEAN))).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" attempts - 1 ", INT), (Object)"attempts")).addAction(BranchAction.make((Object)BuiltinEvents.ACTIVE, "loop", Compiler.compileString(" attempts > 0 ", BOOLEAN))).addAction(BurnManaAction.make("success", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("success", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42730_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(GetPositionAction.make("success", "feet", "feet_pos")).addAction(PutVarAction.makeDouble((Object)"success", Compiler.compileString(" get_y(feet_pos) - floor(get_y(feet_pos))", DOUBLE), (Object)"feet_pos_floor")).addAction(OffsetBlockAction.make("success", "feet", "teleport_position", Compiler.compileString("vec3(0, -feet_pos_floor, 0)", VEC3))).addAction(PlaySoundAction.make("success", "player", SoundEvents.f_11852_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(TeleportToAction.make("success", "player", "teleport_position")).addAction(PlaySoundAction.make("success", "player", SoundEvents.f_11852_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(PlaySoundAction.make("fail", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11850_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(INT, "max_attempts", 10).addParameter(INT, "max_inner_attempts", 10).addParameter(DOUBLE, "teleport_range", 32.0).addParameter(DOUBLE, "target_range", 32.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_FORCED_TELEPORT_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42730_))));
        this.addSpell(Spells.TELEPORT, new Spell(this.modId, "teleport", Spells.KEY_TELEPORT, 10.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42730_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "success")).addAction(LookAtTargetAction.make("success", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("range"), 0.5f, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, "on_block_hit", "on_entity_hit", "on_miss")).addAction(CopyTargetsAction.make("on_entity_hit", "teleport_position", (Object)BuiltinTargetGroups.ENTITY_HIT)).addAction(ActivateAction.make("on_entity_hit", "teleport")).addAction(OffsetBlockAction.make("on_block_hit", (Object)BuiltinTargetGroups.BLOCK_HIT, "teleport_position", VEC3.immediate(new Vec3(0.0, 0.5, 0.0)))).addAction(ActivateAction.make("on_block_hit", "teleport")).addAction(CopyTargetsAction.make("on_miss", "teleport_position", (Object)BuiltinTargetGroups.HIT_POSITION)).addAction(ActivateAction.make("on_miss", "teleport")).addAction(BurnManaAction.make("teleport", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("teleport", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42730_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(PlaySoundAction.make("teleport", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11852_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(TeleportToAction.make("teleport", (Object)BuiltinTargetGroups.OWNER, "teleport_position")).addAction(PlaySoundAction.make("teleport", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11852_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(DOUBLE, "range", 32.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_TELEPORT_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42730_))));
        this.addSpell(Spells.LIGHTNING_STRIKE, new Spell(this.modId, "lightning_strike", Spells.KEY_LIGHTNING_STRIKE, 8.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "bypass")).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_151052_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(BooleanActivationAction.make("bypass", (Object)BuiltinEvents.ACTIVE, Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(LookAtTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("target_range"), 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, "", "on_entity_hit", "")).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(GetTargetGroupSizeAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "target_size")).addAction(BooleanActivationAction.make("no_pvp", "fail", Compiler.compileString(" target_size <= 0 ", BOOLEAN), this.TRUE, this.FALSE)).addAction(DeactivateAction.make("fail", "on_entity_hit")).addAction(CopyTargetsAction.make("on_block_hit", "position", (Object)BuiltinTargetGroups.BLOCK_HIT)).addAction(CopyTargetsAction.make("on_entity_hit", "position", (Object)BuiltinTargetGroups.ENTITY_HIT)).addAction(ActivateAction.make("on_block_hit", "on_hit")).addAction(ActivateAction.make("on_entity_hit", "on_hit")).addAction(BurnManaAction.make("on_hit", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("on_hit", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_151052_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(SpawnEntityAction.make("on_hit", "", SpellsUtil.objectToString(EntityType.f_20465_, ForgeRegistries.ENTITY_TYPES), "position", this.ZERO_VEC3, this.ZERO_VEC3, this.EMPTY_TAG)).addParameter(DOUBLE, "range", 20.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_LIGHTNING_STRIKE_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_151052_))));
        this.addSpell(Spells.DRAIN_FLAME, new Spell(this.modId, "drain_flame", Spells.KEY_DRAIN_FLAME, 0.0f).addAction(LookAtTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("range"), 0.0f, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, "on_block_hit", "", "")).addAction(CubeBlockTargetsAction.make("on_block_hit", (Object)BuiltinTargetGroups.BLOCK_HIT, "blocks", Compiler.compileString(" vec3(-radius, -radius, -radius) ", VEC3), Compiler.compileString(" vec3(radius, radius, radius) ", VEC3))).addAction(LabelAction.make("on_block_hit", "loop")).addAction(ClearTargetsAction.make("on_block_hit", "block_to_check")).addAction(PickTargetAction.make("on_block_hit", "block_to_check", "blocks", true, true)).addAction(GetBlockAction.make("on_block_hit", "block_to_check", "block_type", "", "")).addAction(BooleanActivationAction.make("on_block_hit", "success", Compiler.compileString(" block_type == '" + ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50083_).toString() + "' || block_type == '" + ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50084_) + "' ", BOOLEAN), this.TRUE, this.FALSE)).addAction(DeactivateAction.make("success", "on_block_hit")).addAction(JumpAction.make("on_block_hit", "loop")).addAction(RemoveBlockAction.make("success", "block_to_check")).addAction(PlaySoundAction.make("success", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11937_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(PlaySoundAction.make("success", "block_to_check", SoundEvents.f_11937_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(HomeAction.make("success", "block_to_check", (Object)BuiltinTargetGroups.OWNER, DOUBLE.immediate(1.0), INT.immediate(100), "", "owner_hit", "", "")).addAction(ApplyMobEffectAction.make("owner_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, SpellsUtil.objectToString((MobEffect)BuiltinRegistries.REPLENISHMENT_EFFECT.get(), ForgeRegistries.MOB_EFFECTS), INT.reference("replenishment_duration"), INT.immediate(0), this.FALSE, this.TRUE, this.TRUE)).addAction(PlaySoundAction.make("owner_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, SoundEvents.f_11936_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(DOUBLE, "range", 50.0).addParameter(INT, "replenishment_duration", 100).addParameter(INT, "radius", 1).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_DRAIN_FLAME_DESC)));
        this.addSpell(Spells.GROWTH, new Spell(this.modId, "growth", Spells.KEY_GROWTH, 4.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42499_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(BurnManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "success")).addAction(BooleanActivationAction.make("success", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42499_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(CubeBlockTargetsAction.make("success", (Object)BuiltinTargetGroups.OWNER, "blocks", Compiler.compileString(" vec3(-range, -1, -range) ", VEC3), Compiler.compileString(" vec3(range, 1, range) ", VEC3))).addAction(UseItemOnBlocksAction.make("success", (Object)BuiltinTargetGroups.OWNER, "blocks", new ItemStack((ItemLike)Items.f_42499_), false, Direction.UP)).addAction(SpawnParticlesAction.make("success", "blocks", (ParticleOptions)ParticleTypes.f_123759_, INT.immediate(1), DOUBLE.immediate(0.25))).addAction(PlaySoundAction.make("success", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_144074_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(INT, "range", 3).addParameter(INT, "duration", 20).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_GROWTH_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42499_))));
        this.addSpell(Spells.GHAST, new Spell((SpellIcon)AdvancedSpellIcon.make(new ResourceLocation("textures/entity/ghast/ghast_shooting.png"), 16, 16, 16, 16, 64, 32), Spells.KEY_GHAST, 4.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42613_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "success")).addAction(BurnManaAction.make("success", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("success", "consume", SpellsUtil.objectToString(Items.f_42613_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(AddDelayedSpellAction.make("success", (Object)BuiltinTargetGroups.OWNER, "sound", INT.immediate(10), STRING.immediate(""), this.EMPTY_TAG, new HashMap<String, String>())).addAction(AddDelayedSpellAction.make("success", (Object)BuiltinTargetGroups.OWNER, "shoot", INT.immediate(20), STRING.immediate(""), this.EMPTY_TAG, new HashMap<String, String>())).addAction(PlaySoundAction.make("sound", (Object)BuiltinTargetGroups.HOLDER, SoundEvents.f_11924_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(GetEntityUUIDAction.make("shoot", (Object)BuiltinTargetGroups.HOLDER, "uuid")).addAction(GetEntityPositionDirectionMotionAction.make("shoot", (Object)BuiltinTargetGroups.HOLDER, "", "direction", "")).addAction(PutVarAction.makeCompoundTag((Object)"shoot", Compiler.compileString(" put_nbt_uuid(new_tag(), 'Owner', uuid) ", TAG), (Object)"tag")).addAction(PutVarAction.makeCompoundTag((Object)"shoot", Compiler.compileString(" put_nbt_vec3(tag, 'power', direction * 2.0 * 0.1) ", TAG), (Object)"tag")).addAction(GetEntityEyePositionAction.make("shoot", (Object)BuiltinTargetGroups.HOLDER, "position")).addAction(SpawnEntityAction.make("shoot", "fire_charge", SpellsUtil.objectToString(EntityType.f_20463_, ForgeRegistries.ENTITY_TYPES), "position", VEC3.reference("direction"), this.ZERO_VEC3, TAG.reference("tag"))).addAction(PlaySoundAction.make("shoot", (Object)BuiltinTargetGroups.HOLDER, SoundEvents.f_11923_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_GHAST_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42613_))));
        this.addSpell(Spells.ENDER_ARMY, new Spell(this.modId, "ender_army", Spells.KEY_ENDER_ARMY, 20.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42683_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "success")).addAction(LookAtTargetAction.make("success", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("target_range"), 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, "", "on_entity_hit", "")).addAction(BooleanActivationAction.make("on_entity_hit", "no_pvp", Compiler.compileString(" !pvp() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(MovePlayerTargetsAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "")).addAction(GetTargetGroupSizeAction.make("no_pvp", (Object)BuiltinTargetGroups.ENTITY_HIT, "target_size")).addAction(BooleanActivationAction.make("no_pvp", "fail", Compiler.compileString(" target_size <= 0 ", BOOLEAN), this.TRUE, this.FALSE)).addAction(DeactivateAction.make("fail", "on_entity_hit")).addAction(BurnManaAction.make("on_entity_hit", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("on_entity_hit", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42683_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(RangedEntityTargetsAction.make("on_entity_hit", "targets", (Object)BuiltinTargetGroups.ENTITY_HIT, DOUBLE.reference("enderman_range"))).addAction(LabelAction.make("on_entity_hit", "loop")).addAction(ClearTargetsAction.make("on_entity_hit", "to_check")).addAction(PickTargetAction.make("on_entity_hit", "to_check", "targets", true, false)).addAction(GetEntityTypeAction.make("on_entity_hit", "to_check", "type", "", "")).addAction(BooleanActivationAction.make("on_entity_hit", "move_entity", Compiler.compileString(" type == '" + ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20566_).toString() + "' ", BOOLEAN), this.TRUE, this.FALSE)).addAction(CopyTargetsAction.make("move_entity", "endermen", "to_check")).addAction(DeactivateAction.make("move_entity", "move_entity")).addAction(GetTargetGroupSizeAction.make("on_entity_hit", "targets", "size")).addAction(BranchAction.make("on_entity_hit", "loop", Compiler.compileString(" size > 0 ", BOOLEAN))).addAction(SetMobTargetAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, "endermen")).addAction(PlaySoundAction.make("on_entity_hit", (Object)BuiltinTargetGroups.OWNER, SoundEvents.f_11850_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addAction(PlaySoundAction.make("on_entity_hit", (Object)BuiltinTargetGroups.ENTITY_HIT, SoundEvents.f_11850_, DOUBLE.immediate(1.0), DOUBLE.immediate(1.0))).addParameter(DOUBLE, "target_range", 50.0).addParameter(DOUBLE, "enderman_range", 40.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_ENDER_ARMY_DESC)).addTooltip((Component)Component.m_237119_()).addTooltip(SpellsGen.itemCostTitle(KEY_HAND_ITEM_COST_TITLE)).addTooltip(SpellsGen.itemCostComponent(new ItemStack((ItemLike)Items.f_42683_))));
        this.addSpell(Spells.EVOKER_FANGS, new Spell((SpellIcon)LayeredSpellIcon.make((List<SpellIcon>)ImmutableList.of((Object)AdvancedSpellIcon.make(new ResourceLocation("textures/entity/illager/evoker.png"), 8, 8, 8, 10, 64, 64, 0, -2), (Object)AdvancedSpellIcon.make(new ResourceLocation("textures/entity/illager/evoker.png"), 22, 26, 8, 4, 64, 64, 0, 5), (Object)AdvancedSpellIcon.make(new ResourceLocation("textures/entity/illager/evoker.png"), 6, 44, 8, 4, 64, 64, 0, 5), (Object)AdvancedSpellIcon.make(new ResourceLocation("textures/entity/illager/evoker.png"), 26, 2, 2, 4, 64, 64, 0, 2))), Spells.KEY_EVOKER_FANGS, 6.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(LookAtTargetAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference("range"), 0.5f, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, "", "", "")).addAction(GetEntityUUIDAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "owner_uuid")).addAction(PutVarAction.makeCompoundTag((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" put_nbt_uuid(new_tag(), 'Owner', owner_uuid) ", TAG), (Object)"tag")).addAction(GetPositionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.HIT_POSITION, "target_pos")).addAction(GetEntityEyePositionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "eye_position")).addAction(GetPositionAction.make((Object)BuiltinEvents.ACTIVE, "eye_position", "player_pos1")).addAction(GetPositionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "player_pos2")).addAction(GetEntityPositionDirectionMotionAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, "", "look", "")).addAction(PutVarAction.makeVec3((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" get_y(look) >= 0 ? player_pos2 : player_pos1 ", VEC3), (Object)"player_pos")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" ceil(max(get_y(player_pos), get_y(target_pos))) + 1 ", INT), (Object)"max_y")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" floor(min(get_y(player_pos), get_y(target_pos))) - 2 ", INT), (Object)"min_y")).addAction(PutVarAction.makeVec3((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" target_pos - player_pos ", VEC3), (Object)"vector")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" max(1, ceil(2 * sqrt(length(vector)))) ", INT), (Object)"fangs")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, 0, (Object)"fangs_spawned")).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, 1, (Object)"fang")).addAction(LabelAction.make((Object)BuiltinEvents.ACTIVE, "outer_loop")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "position")).addAction(PutVarAction.makeVec3((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" (vector * fang) / fangs ", VEC3), (Object)"offset")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "position")).addAction(OffsetBlockAction.make((Object)BuiltinEvents.ACTIVE, "eye_position", "position", VEC3.reference("offset"))).addAction(GetPositionAction.make((Object)BuiltinEvents.ACTIVE, "position", "position_var")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" get_x(position_var) ", DOUBLE), (Object)"x")).addAction(PutVarAction.makeDouble((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" get_z(position_var) ", DOUBLE), (Object)"z")).addAction(PutVarAction.moveInt((Object)BuiltinEvents.ACTIVE, "max_y", "y")).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "repeat")).addAction(DeactivateAction.make((Object)BuiltinEvents.ACTIVE, "success")).addAction(LabelAction.make((Object)BuiltinEvents.ACTIVE, "inner_loop")).addAction(ClearTargetsAction.make((Object)BuiltinEvents.ACTIVE, "block")).addAction(PositionToTargetAction.make((Object)BuiltinEvents.ACTIVE, "block", Compiler.compileString(" vec3(x, y, z) ", VEC3))).addAction(GetBlockAttributesAction.make((Object)BuiltinEvents.ACTIVE, "block", "", "", "has_collider")).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", BOOLEAN.reference("has_collider"), this.TRUE, this.FALSE)).addAction(ClearTargetsAction.make("success", "above")).addAction(PositionToTargetAction.make("success", "above", Compiler.compileString(" vec3(x, y + 1, z) ", VEC3))).addAction(PutVarAction.makeCompoundTag((Object)"success", Compiler.compileString(" put_nbt_int(tag, 'Warmup', fang) ", TAG), (Object)"delayed_tag")).addAction(SpawnEntityAction.make("success", "", STRING.immediate(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20569_).toString()), "above", VEC3.reference("look"), this.ZERO_VEC3, TAG.reference("delayed_tag"))).addAction(PutVarAction.makeInt((Object)"success", Compiler.compileString(" fangs_spawned + 1 ", INT), (Object)"fangs_spawned")).addAction(DeactivateAction.make("success", "repeat")).addAction(PutVarAction.makeInt((Object)"repeat", Compiler.compileString(" y - 1 ", INT), (Object)"y")).addAction(BranchAction.make("repeat", "inner_loop", Compiler.compileString(" y >= min_y ", BOOLEAN))).addAction(PutVarAction.makeInt((Object)BuiltinEvents.ACTIVE, Compiler.compileString(" fang + 1 ", INT), (Object)"fang")).addAction(BranchAction.make((Object)BuiltinEvents.ACTIVE, "outer_loop", Compiler.compileString(" fang <= fangs ", BOOLEAN))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinEvents.ACTIVE, Compiler.compileString(" fangs_spawned > 0 ", BOOLEAN), this.FALSE, this.TRUE)).addAction(BurnManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addParameter(DOUBLE, "range", 20.0).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_EVOKER_FANGS_DESC)));
        this.addSpell(Spells.POCKET_ROCKET, new Spell((SpellIcon)ItemSpellIcon.make(new ItemStack((ItemLike)Items.f_42688_)), Spells.KEY_POCKET_ROCKET, 8.0f).addAction(HasManaAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make((Object)BuiltinEvents.ACTIVE, "success", Compiler.compileString(" !item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(PlayerHasItemsAction.make((Object)BuiltinEvents.ACTIVE, (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42403_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE, this.TRUE)).addAction(ActivateAction.make((Object)BuiltinEvents.ACTIVE, "success")).addAction(BurnManaAction.make("success", (Object)BuiltinTargetGroups.OWNER, DOUBLE.reference((Object)BuiltinVariables.MANA_COST))).addAction(BooleanActivationAction.make("success", "consume", Compiler.compileString(" item_costs() ", BOOLEAN), this.TRUE, this.FALSE)).addAction(ConsumePlayerItemsAction.make("consume", (Object)BuiltinTargetGroups.OWNER, SpellsUtil.objectToString(Items.f_42403_, ForgeRegistries.ITEMS), INT.immediate(1), this.EMPTY_TAG, this.TRUE)).addAction(LabelAction.make("success", "loop")).addAction(PutVarAction.makeInt((Object)"success", Compiler.compileString(" repetitions - 1 ", INT), (Object)"repetitions")).addAction(AddDelayedSpellAction.make("success", (Object)BuiltinTargetGroups.OWNER, "fire", Compiler.compileString(" repetitions * time_delay_ticks ", INT), STRING.immediate(""), this.EMPTY_TAG, SpellsGen.eventHookMap(new String[0]))).addAction(BranchAction.make("success", "loop", Compiler.compileString(" repetitions > 1 ", BOOLEAN))).addAction(CopyTargetsAction.make("success", "player", (Object)BuiltinTargetGroups.OWNER)).addAction(CopyTargetsAction.make("fire", "player", (Object)BuiltinTargetGroups.HOLDER)).addAction(ActivateAction.make("success", "fire")).addAction(UseItemAction.make("fire", "player", new ItemStack((ItemLike)Items.f_42688_), false)).addParameter(INT, "repetitions", 4).addParameter(INT, "time_delay_ticks", 30).addEventHook((Object)BuiltinEvents.ACTIVE).addTooltip((Component)Component.m_237115_((String)Spells.KEY_POCKET_ROCKET_DESC)));
        this.addPermanentEffectSpell(Spells.PERMANENT_REPLENISHMENT, Spells.KEY_PERMANENT_REPLENISHMENT, Spells.KEY_PERMANENT_REPLENISHMENT_DESC, (MobEffect)BuiltinRegistries.REPLENISHMENT_EFFECT.get(), 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_REPLENISHMENT, Spells.KEY_TEMPORARY_REPLENISHMENT, Spells.KEY_TEMPORARY_REPLENISHMENT_DESC, (MobEffect)BuiltinRegistries.REPLENISHMENT_EFFECT.get(), 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_REPLENISHMENT, Spells.KEY_TOGGLE_REPLENISHMENT, Spells.KEY_TOGGLE_REPLENISHMENT_DESC, (MobEffect)BuiltinRegistries.REPLENISHMENT_EFFECT.get(), 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_MAGIC_IMMUNE, Spells.KEY_PERMANENT_MAGIC_IMMUNE, Spells.KEY_PERMANENT_MAGIC_IMMUNE_DESC, (MobEffect)BuiltinRegistries.MAGIC_IMMUNE_EFFECT.get(), 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_MAGIC_IMMUNE, Spells.KEY_TEMPORARY_MAGIC_IMMUNE, Spells.KEY_TEMPORARY_MAGIC_IMMUNE_DESC, (MobEffect)BuiltinRegistries.MAGIC_IMMUNE_EFFECT.get(), 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_MAGIC_IMMUNE, Spells.KEY_TOGGLE_MAGIC_IMMUNE, Spells.KEY_TOGGLE_MAGIC_IMMUNE_DESC, (MobEffect)BuiltinRegistries.MAGIC_IMMUNE_EFFECT.get(), 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_SPEED, Spells.KEY_PERMANENT_SPEED, Spells.KEY_PERMANENT_SPEED_DESC, MobEffects.f_19596_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_SPEED, Spells.KEY_TEMPORARY_SPEED, Spells.KEY_TEMPORARY_SPEED_DESC, MobEffects.f_19596_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_SPEED, Spells.KEY_TOGGLE_SPEED, Spells.KEY_TOGGLE_SPEED_DESC, MobEffects.f_19596_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_JUMP_BOOST, Spells.KEY_PERMANENT_JUMP_BOOST, Spells.KEY_PERMANENT_JUMP_BOOST_DESC, MobEffects.f_19603_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_JUMP_BOOST, Spells.KEY_TEMPORARY_JUMP_BOOST, Spells.KEY_TEMPORARY_JUMP_BOOST_DESC, MobEffects.f_19603_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_JUMP_BOOST, Spells.KEY_TOGGLE_JUMP_BOOST, Spells.KEY_TOGGLE_JUMP_BOOST_DESC, MobEffects.f_19603_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_DOLPHINS_GRACE, Spells.KEY_PERMANENT_DOLPHINS_GRACE, Spells.KEY_PERMANENT_DOLPHINS_GRACE_DESC, MobEffects.f_19593_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_DOLPHINS_GRACE, Spells.KEY_TEMPORARY_DOLPHINS_GRACE, Spells.KEY_TEMPORARY_DOLPHINS_GRACE_DESC, MobEffects.f_19593_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_DOLPHINS_GRACE, Spells.KEY_TOGGLE_DOLPHINS_GRACE, Spells.KEY_TOGGLE_DOLPHINS_GRACE_DESC, MobEffects.f_19593_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_WATER_BREATHING, Spells.KEY_PERMANENT_WATER_BREATHING, Spells.KEY_PERMANENT_WATER_BREATHING_DESC, MobEffects.f_19608_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_WATER_BREATHING, Spells.KEY_TEMPORARY_WATER_BREATHING, Spells.KEY_TEMPORARY_WATER_BREATHING_DESC, MobEffects.f_19608_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_WATER_BREATHING, Spells.KEY_TOGGLE_WATER_BREATHING, Spells.KEY_TOGGLE_WATER_BREATHING_DESC, MobEffects.f_19608_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_SLOW_FALLING, Spells.KEY_PERMANENT_SLOW_FALLING, Spells.KEY_PERMANENT_SLOW_FALLING_DESC, MobEffects.f_19591_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_SLOW_FALLING, Spells.KEY_TEMPORARY_SLOW_FALLING, Spells.KEY_TEMPORARY_SLOW_FALLING_DESC, MobEffects.f_19591_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_SLOW_FALLING, Spells.KEY_TOGGLE_SLOW_FALLING, Spells.KEY_TOGGLE_SLOW_FALLING_DESC, MobEffects.f_19591_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_HASTE, Spells.KEY_PERMANENT_HASTE, Spells.KEY_PERMANENT_HASTE_DESC, MobEffects.f_19598_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_HASTE, Spells.KEY_TEMPORARY_HASTE, Spells.KEY_TEMPORARY_HASTE_DESC, MobEffects.f_19598_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_HASTE, Spells.KEY_TOGGLE_HASTE, Spells.KEY_TOGGLE_HASTE_DESC, MobEffects.f_19598_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_REGENERATION, Spells.KEY_PERMANENT_REGENERATION, Spells.KEY_PERMANENT_REGENERATION_DESC, MobEffects.f_19605_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_REGENERATION, Spells.KEY_TEMPORARY_REGENERATION, Spells.KEY_TEMPORARY_REGENERATION_DESC, MobEffects.f_19605_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_REGENERATION, Spells.KEY_TOGGLE_REGENERATION, Spells.KEY_TOGGLE_REGENERATION_DESC, MobEffects.f_19605_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_FIRE_RESISTANCE, Spells.KEY_PERMANENT_FIRE_RESISTANCE, Spells.KEY_PERMANENT_FIRE_RESISTANCE_DESC, MobEffects.f_19607_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_FIRE_RESISTANCE, Spells.KEY_TEMPORARY_FIRE_RESISTANCE, Spells.KEY_TEMPORARY_FIRE_RESISTANCE_DESC, MobEffects.f_19607_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_FIRE_RESISTANCE, Spells.KEY_TOGGLE_FIRE_RESISTANCE, Spells.KEY_TOGGLE_FIRE_RESISTANCE_DESC, MobEffects.f_19607_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_NIGHT_VISION, Spells.KEY_PERMANENT_NIGHT_VISION, Spells.KEY_PERMANENT_NIGHT_VISION_DESC, MobEffects.f_19611_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_NIGHT_VISION, Spells.KEY_TEMPORARY_NIGHT_VISION, Spells.KEY_TEMPORARY_NIGHT_VISION_DESC, MobEffects.f_19611_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_NIGHT_VISION, Spells.KEY_TOGGLE_NIGHT_VISION, Spells.KEY_TOGGLE_NIGHT_VISION_DESC, MobEffects.f_19611_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_STRENGTH, Spells.KEY_PERMANENT_STRENGTH, Spells.KEY_PERMANENT_STRENGTH_DESC, MobEffects.f_19600_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_STRENGTH, Spells.KEY_TEMPORARY_STRENGTH, Spells.KEY_TEMPORARY_STRENGTH_DESC, MobEffects.f_19600_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_STRENGTH, Spells.KEY_TOGGLE_STRENGTH, Spells.KEY_TOGGLE_STRENGTH_DESC, MobEffects.f_19600_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_RESISTANCE, Spells.KEY_PERMANENT_RESISTANCE, Spells.KEY_PERMANENT_RESISTANCE_DESC, MobEffects.f_19606_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_RESISTANCE, Spells.KEY_TEMPORARY_RESISTANCE, Spells.KEY_TEMPORARY_RESISTANCE_DESC, MobEffects.f_19606_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_RESISTANCE, Spells.KEY_TOGGLE_RESISTANCE, Spells.KEY_TOGGLE_RESISTANCE_DESC, MobEffects.f_19606_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_INVISIBILITY, Spells.KEY_PERMANENT_INVISIBILITY, Spells.KEY_PERMANENT_INVISIBILITY_DESC, MobEffects.f_19609_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_INVISIBILITY, Spells.KEY_TEMPORARY_INVISIBILITY, Spells.KEY_TEMPORARY_INVISIBILITY_DESC, MobEffects.f_19609_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_INVISIBILITY, Spells.KEY_TOGGLE_INVISIBILITY, Spells.KEY_TOGGLE_INVISIBILITY_DESC, MobEffects.f_19609_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_GLOWING, Spells.KEY_PERMANENT_GLOWING, Spells.KEY_PERMANENT_GLOWING_DESC, MobEffects.f_19619_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_GLOWING, Spells.KEY_TEMPORARY_GLOWING, Spells.KEY_TEMPORARY_GLOWING_DESC, MobEffects.f_19619_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_GLOWING, Spells.KEY_TOGGLE_GLOWING, Spells.KEY_TOGGLE_GLOWING_DESC, MobEffects.f_19619_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_LUCK, Spells.KEY_PERMANENT_LUCK, Spells.KEY_PERMANENT_LUCK_DESC, MobEffects.f_19621_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_LUCK, Spells.KEY_TEMPORARY_LUCK, Spells.KEY_TEMPORARY_LUCK_DESC, MobEffects.f_19621_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_LUCK, Spells.KEY_TOGGLE_LUCK, Spells.KEY_TOGGLE_LUCK_DESC, MobEffects.f_19621_, 4.0f, 50, 0);
        this.addPermanentEffectSpell(Spells.PERMANENT_CONDUIT_POWER, Spells.KEY_PERMANENT_CONDUIT_POWER, Spells.KEY_PERMANENT_CONDUIT_POWER_DESC, MobEffects.f_19592_, 50, 0);
        this.addTemporaryEffectSpell(Spells.TEMPORARY_CONDUIT_POWER, Spells.KEY_TEMPORARY_CONDUIT_POWER, Spells.KEY_TEMPORARY_CONDUIT_POWER_DESC, MobEffects.f_19592_, 13.0f, 400, 0);
        this.addToggleEffectSpell(Spells.TOGGLE_CONDUIT_POWER, Spells.KEY_TOGGLE_CONDUIT_POWER, Spells.KEY_TOGGLE_CONDUIT_POWER_DESC, MobEffects.f_19592_, 4.0f, 50, 0);
    }

    public void m_213708_(CachedOutput pOutput) throws IOException {
        this.addSpells();
        JsonCodecProvider provider = JsonCodecProvider.forDatapackRegistry((DataGenerator)this.gen, (ExistingFileHelper)this.exFileHelper, (String)this.modId, this.registryOps, Spells.REGISTRY_KEY, this.spells);
        provider.m_213708_(pOutput);
    }

    public String m_6055_() {
        return "Spells & Shields Spells Files";
    }

    public static Component itemCostTitle(String key) {
        return Component.m_237115_((String)key).m_130940_(ChatFormatting.BLUE);
    }

    public static Component itemCostComponent(Item item) {
        return SpellsGen.itemCostComponent(item, 1);
    }

    public static Component itemCostComponent(Item item, int count) {
        if (count == 1) {
            return Component.m_237110_((String)KEY_ITEM_COST_SINGLE, (Object[])new Object[]{Component.m_237115_((String)item.m_5524_())}).m_130940_(ChatFormatting.YELLOW);
        }
        return Component.m_237110_((String)KEY_ITEM_COST, (Object[])new Object[]{count, Component.m_237115_((String)item.m_5524_())}).m_130940_(ChatFormatting.YELLOW);
    }

    public static Component itemCostComponent(ItemStack itemStack) {
        if (itemStack.m_41613_() == 1) {
            return Component.m_237110_((String)KEY_ITEM_COST_SINGLE, (Object[])new Object[]{itemStack.m_41786_()}).m_130940_(ChatFormatting.YELLOW);
        }
        return Component.m_237110_((String)KEY_ITEM_COST, (Object[])new Object[]{itemStack.m_41613_(), itemStack.m_41786_()}).m_130940_(ChatFormatting.YELLOW);
    }

    public static Component textItemCostComponent(Component translatable, int count) {
        return Component.m_237110_((String)KEY_ITEM_COST_TEXT, (Object[])new Object[]{translatable}).m_130940_(ChatFormatting.YELLOW);
    }

    public static Map<String, String> eventHookMap(String ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            map.put(keyValuePairs[0], keyValuePairs[1]);
        }
        return map;
    }

    public static void printBlastingRecipes(Level level) {
        System.out.println("ABCDEFG=".repeat(50));
        level.m_7465_().m_44013_(RecipeType.f_44109_).forEach(r -> {
            String out = ForgeRegistries.ITEMS.getKey((Object)r.m_8043_().m_41720_()).toString();
            r.m_7527_().forEach(i -> Arrays.stream(i.m_43908_()).map(it -> ForgeRegistries.ITEMS.getKey((Object)it.m_41720_()).toString()).forEach(item -> System.out.printf("blastRecipes.putString(\"%s\", \"%s\");\n", item, out)));
        });
    }

    public static CompoundTag blastFurnaceRecipes() {
        CompoundTag blastRecipes = new CompoundTag();
        blastRecipes.m_128359_("minecraft:golden_pickaxe", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_shovel", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_axe", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_hoe", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_sword", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_helmet", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_chestplate", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_leggings", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_boots", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:golden_horse_armor", "minecraft:gold_nugget");
        blastRecipes.m_128359_("minecraft:deepslate_copper_ore", "minecraft:copper_ingot");
        blastRecipes.m_128359_("minecraft:coal_ore", "minecraft:coal");
        blastRecipes.m_128359_("minecraft:diamond_ore", "minecraft:diamond");
        blastRecipes.m_128359_("minecraft:redstone_ore", "minecraft:redstone");
        blastRecipes.m_128359_("minecraft:deepslate_lapis_ore", "minecraft:lapis_lazuli");
        blastRecipes.m_128359_("minecraft:deepslate_diamond_ore", "minecraft:diamond");
        blastRecipes.m_128359_("minecraft:deepslate_redstone_ore", "minecraft:redstone");
        blastRecipes.m_128359_("minecraft:ancient_debris", "minecraft:netherite_scrap");
        blastRecipes.m_128359_("minecraft:deepslate_iron_ore", "minecraft:iron_ingot");
        blastRecipes.m_128359_("minecraft:copper_ore", "minecraft:copper_ingot");
        blastRecipes.m_128359_("minecraft:deepslate_emerald_ore", "minecraft:emerald");
        blastRecipes.m_128359_("minecraft:raw_gold", "minecraft:gold_ingot");
        blastRecipes.m_128359_("minecraft:iron_pickaxe", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_shovel", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_axe", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_hoe", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_sword", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_helmet", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_chestplate", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_leggings", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_boots", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:iron_horse_armor", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:chainmail_helmet", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:chainmail_chestplate", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:chainmail_leggings", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:chainmail_boots", "minecraft:iron_nugget");
        blastRecipes.m_128359_("minecraft:gold_ore", "minecraft:gold_ingot");
        blastRecipes.m_128359_("minecraft:nether_quartz_ore", "minecraft:quartz");
        blastRecipes.m_128359_("minecraft:iron_ore", "minecraft:iron_ingot");
        blastRecipes.m_128359_("minecraft:nether_gold_ore", "minecraft:gold_ingot");
        blastRecipes.m_128359_("minecraft:deepslate_gold_ore", "minecraft:gold_ingot");
        blastRecipes.m_128359_("minecraft:emerald_ore", "minecraft:emerald");
        blastRecipes.m_128359_("minecraft:raw_iron", "minecraft:iron_ingot");
        blastRecipes.m_128359_("minecraft:lapis_ore", "minecraft:lapis_lazuli");
        blastRecipes.m_128359_("minecraft:raw_copper", "minecraft:copper_ingot");
        blastRecipes.m_128359_("minecraft:deepslate_coal_ore", "minecraft:coal");
        return blastRecipes;
    }
}

