/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.enchantment;

import de.cas_ual_ty.spells.capability.ManaHolder;
import de.cas_ual_ty.spells.registers.BuiltinRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;

public class ManaBladeEnchantment
extends Enchantment {
    private static final int MIN_COST = 5;
    private static final int LEVEL_COST = 8;
    private static final int LEVEL_COST_SPAN = 20;

    public ManaBladeEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... equipmentSlots) {
        super(rarity, BuiltinRegistries.SWORD_OR_AXE_ENCHANTMENT_CATEGORY, equipmentSlots);
    }

    public int m_6183_(int level) {
        return 5 + (level - 1) * 8;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 20;
    }

    public int m_6586_() {
        return 5;
    }

    public boolean m_5975_(Enchantment enchantment) {
        return !(enchantment instanceof DamageEnchantment);
    }

    public boolean m_6081_(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof AxeItem ? true : super.m_6081_(itemStack);
    }

    public void m_7677_(LivingEntity user, Entity target, int level) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (level > 0) {
                ManaHolder.getManaHolder(user).ifPresent(manaHolder -> {
                    if (manaHolder.getMana() > 2.0f) {
                        float damage = Math.min(manaHolder.getMana(), (float)level * 2.0f);
                        manaHolder.burn(5.0f);
                        livingEntity.m_6469_(DamageSource.m_19367_((Entity)user, null), damage);
                        RandomSource random = user.m_217043_();
                        int i = 20 + random.m_188503_(10 * level);
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, i, 3));
                        Vec3 eyes = livingEntity.m_146892_();
                        Vec3 spread = new Vec3(0.5, 0.5, 0.5);
                        for (i = 0; i < 10; ++i) {
                            livingEntity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123808_, eyes.f_82479_ + random.m_188583_() * spread.f_82479_, eyes.f_82480_ + random.m_188583_() * spread.f_82480_, eyes.f_82481_ + random.m_188583_() * spread.f_82481_, 0.0, 0.0, 0.0);
                        }
                    }
                });
            }
        }
    }
}

