/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.util.SpellHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record FireSpellMessage(int spell) {
    public static void encode(FireSpellMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.spell());
    }

    public static FireSpellMessage decode(FriendlyByteBuf buf) {
        return new FireSpellMessage(buf.readInt());
    }

    public static void handle(FireSpellMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                SpellHelper.fireSpellSlot((Player)player, msg.spell());
            }
        });
        context.get().setPacketHandled(true);
    }
}

