/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public record RequestEquipSpellMessage(byte slot, SpellNodeId nodeId) {
    public static void encode(RequestEquipSpellMessage msg, FriendlyByteBuf buf) {
        buf.writeByte((int)msg.slot());
        buf.m_130085_(msg.nodeId().treeId());
        buf.writeShort(msg.nodeId().nodeId());
    }

    public static RequestEquipSpellMessage decode(FriendlyByteBuf buf) {
        return new RequestEquipSpellMessage(buf.readByte(), new SpellNodeId(buf.m_130281_(), buf.readShort()));
    }

    public static void handle(RequestEquipSpellMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1250$temp = player.f_36096_;
            if (patt1250$temp instanceof SpellProgressionMenu) {
                SpellProgressionMenu menu = (SpellProgressionMenu)patt1250$temp;
                menu.equipSpellRequest(msg.slot(), msg.nodeId());
            }
        });
        context.get().setPacketHandled(true);
    }
}

