/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.network.SpellProgressionSyncMessage;
import de.cas_ual_ty.spells.progression.SpellProgressionMenu;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.ProgressionHelper;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public record RequestSpellProgressionMenuMessage(BlockPos pos) {
    public static void encode(RequestSpellProgressionMenuMessage msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos());
    }

    public static RequestSpellProgressionMenuMessage decode(FriendlyByteBuf buf) {
        return new RequestSpellProgressionMenuMessage(buf.m_130135_());
    }

    public static void handle(RequestSpellProgressionMenuMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            try {
                if (player.f_36096_ != null && SpellsUtil.isEnchantingTable(player.f_19853_.m_8055_(msg.pos()).m_60734_())) {
                    final ContainerLevelAccess access = ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)msg.pos());
                    SpellProgressionHolder.getSpellProgressionHolder((Player)player).ifPresent(spellProgressionHolder -> access.m_39292_((level, blockPos) -> {
                        final List<SpellTree> availableSpellTrees = ProgressionHelper.getStrippedSpellTrees(spellProgressionHolder, access);
                        final HashMap<SpellNodeId, SpellStatus> progression = spellProgressionHolder.getProgression();
                        Registry<Spell> registry = Spells.getRegistry((LevelAccessor)level);
                        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                            public Component m_5446_() {
                                return SpellProgressionMenu.TITLE;
                            }

                            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                                return new SpellProgressionMenu(id, inventory, access, availableSpellTrees, progression);
                            }
                        }, buf -> {
                            SpellProgressionSyncMessage data = new SpellProgressionSyncMessage((BlockPos)blockPos, availableSpellTrees, progression, (Level)level);
                            SpellProgressionSyncMessage.encode(data, buf);
                        });
                    }));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        context.get().setPacketHandled(true);
    }
}

