/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.client.ClientMessageHandler;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.spell.action.IClientAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.SyncedSpellActionType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record RunActionOnClientMessage(SyncedSpellActionType<?, ?> actionType, IClientAction action) {
    public static void encode(RunActionOnClientMessage msg, FriendlyByteBuf buf) {
        buf.writeRegistryId(SpellActionTypes.REGISTRY.get(), msg.actionType());
        msg.action().writeToBuf(buf);
    }

    public static RunActionOnClientMessage decode(FriendlyByteBuf buf) {
        SpellActionType type = (SpellActionType)buf.readRegistryId();
        if (type instanceof SyncedSpellActionType) {
            SyncedSpellActionType syncedType = (SyncedSpellActionType)type;
            Object action = syncedType.makeClientInstance();
            action.readFromBuf(buf);
            return new RunActionOnClientMessage(syncedType, (IClientAction)action);
        }
        return new RunActionOnClientMessage(null, null);
    }

    public static void handle(RunActionOnClientMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientMessageHandler.handleSpellAction(msg));
        context.get().setPacketHandled(true);
    }
}

