/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.client.ClientMessageHandler;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.SpellTreeSerializer;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;

public record SpellProgressionSyncMessage(BlockPos blockPos, List<SpellTree> spellTrees, HashMap<SpellNodeId, SpellStatus> map, Level level) {
    public static void encode(SpellProgressionSyncMessage msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.blockPos());
        buf.writeInt(msg.spellTrees().size());
        for (SpellTree spellTree : msg.spellTrees()) {
            SpellTreeSerializer.encodeTree(spellTree, Spells.getRegistry((LevelAccessor)msg.level()), buf);
        }
        buf.writeInt(msg.map().size());
        for (Map.Entry entry : msg.map().entrySet()) {
            ((SpellNodeId)entry.getKey()).toBuf(buf);
            buf.writeByte(((SpellStatus)((Object)entry.getValue())).ordinal());
        }
    }

    public static SpellProgressionSyncMessage decode(FriendlyByteBuf buf) {
        Level level = SpellsUtil.getClientLevel();
        BlockPos blockPos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<SpellTree> spellTrees = new ArrayList<SpellTree>(size);
        for (int i = 0; i < size; ++i) {
            spellTrees.add(SpellTreeSerializer.decodeTree(Spells.getRegistry((LevelAccessor)level), buf));
        }
        size = buf.readInt();
        HashMap<SpellNodeId, SpellStatus> map = new HashMap<SpellNodeId, SpellStatus>();
        for (int i = 0; i < size; ++i) {
            SpellNodeId nodeId = SpellNodeId.fromBuf(buf);
            SpellStatus spellStatus = SpellStatus.values()[buf.readByte()];
            map.put(nodeId, spellStatus);
        }
        return new SpellProgressionSyncMessage(blockPos, spellTrees, map, level);
    }

    public static void handle(SpellProgressionSyncMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientMessageHandler.handleSpellProgressionSync(msg));
        context.get().setPacketHandled(true);
    }
}

