/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.network;

import de.cas_ual_ty.spells.client.ClientMessageHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record SpellsSyncMessage(int entityId, ResourceLocation[] spells) {
    public static void encode(SpellsSyncMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId());
        buf.writeByte(msg.spells().length);
        for (ResourceLocation spell : msg.spells()) {
            if (spell != null) {
                buf.writeBoolean(true);
                buf.m_130085_(spell);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static SpellsSyncMessage decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        ResourceLocation[] spells = new ResourceLocation[buf.readByte()];
        for (int i = 0; i < spells.length; ++i) {
            spells[i] = buf.readBoolean() ? buf.m_130281_() : null;
        }
        return new SpellsSyncMessage(entityId, spells);
    }

    public static void handle(SpellsSyncMessage msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientMessageHandler.handleSpellsSync(msg));
        context.get().setPacketHandled(true);
    }
}

