/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.progression;

import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.capability.SpellHolder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.network.SpellProgressionSyncMessage;
import de.cas_ual_ty.spells.progression.SpellStatus;
import de.cas_ual_ty.spells.registers.BuiltinRegistries;
import de.cas_ual_ty.spells.registers.SpellTrees;
import de.cas_ual_ty.spells.spelltree.SpellNode;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.ProgressionHelper;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.PacketDistributor;

public class SpellProgressionMenu
extends AbstractContainerMenu {
    public static Component TITLE = Component.m_237115_((String)"container.spells_and_shields.spell_progression");
    public final ContainerLevelAccess access;
    public final Player player;
    public List<SpellTree> spellTrees;
    public HashMap<SpellNodeId, SpellStatus> spellProgression;

    public SpellProgressionMenu(int id, Inventory inventory, ContainerLevelAccess containerLevelAccess, List<SpellTree> spellTrees, HashMap<SpellNodeId, SpellStatus> spellProgression) {
        super((MenuType)BuiltinRegistries.SPELL_PROGRESSION_MENU.get(), id);
        this.access = containerLevelAccess;
        this.player = inventory.f_35978_;
        this.spellTrees = spellTrees;
        this.spellProgression = spellProgression;
    }

    public void buySpellRequest(SpellNodeId nodeId) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SpellProgressionHolder.getSpellProgressionHolder((Player)player2).ifPresent(spellProgressionHolder -> this.access.m_39292_((level, blockPos) -> {
                if (ProgressionHelper.tryBuySpell(spellProgressionHolder, this, nodeId)) {
                    spellProgressionHolder.setSpellStatus(nodeId, SpellStatus.LEARNED);
                    level.m_5594_(null, blockPos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                }
                this.spellTrees = ProgressionHelper.getStrippedSpellTrees(spellProgressionHolder, this.access);
                this.spellProgression = spellProgressionHolder.getProgression();
                SpellsAndShields.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SpellProgressionSyncMessage((BlockPos)blockPos, this.spellTrees, this.spellProgression, (Level)level));
            }));
        }
    }

    public void equipSpellRequest(int slot, SpellNodeId nodeId) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SpellProgressionHolder.getSpellProgressionHolder((Player)player2).ifPresent(spellProgressionHolder -> SpellHolder.getSpellHolder((Player)player2).ifPresent(spellHolder -> {
                SpellNode node = nodeId.getSpellNode(SpellTrees.getRegistry((LevelAccessor)player.f_19853_));
                if (node != null && spellProgressionHolder.getSpellStatus(nodeId).isAvailable()) {
                    spellHolder.setSpell(slot, node.getSpellInstance());
                    spellHolder.sendSync();
                }
            }));
        }
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, blockPos) -> !SpellsUtil.isEnchantingTable(level.m_8055_(blockPos).m_60734_()) ? false : player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public static SpellProgressionMenu construct(int id, Inventory inventory, FriendlyByteBuf extraData) {
        try {
            SpellProgressionSyncMessage msg = SpellProgressionSyncMessage.decode(extraData);
            return new SpellProgressionMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)inventory.f_35978_.f_19853_, (BlockPos)msg.blockPos()), msg.spellTrees(), msg.map());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

