/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.registers;

import com.mojang.serialization.Codec;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class CtxVarTypes {
    public static Supplier<IForgeRegistry<CtxVarType<?>>> REGISTRY;
    private static final DeferredRegister<CtxVarType<?>> DEFERRED_REGISTER;
    public static final RegistryObject<CtxVarType<Integer>> INT;
    public static final RegistryObject<CtxVarType<Double>> DOUBLE;
    public static final RegistryObject<CtxVarType<Vec3>> VEC3;
    public static final RegistryObject<CtxVarType<BlockPos>> BLOCK_POS;
    public static final RegistryObject<CtxVarType<Boolean>> BOOLEAN;
    public static final RegistryObject<CtxVarType<CompoundTag>> TAG;
    public static final RegistryObject<CtxVarType<String>> STRING;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CtxVarTypes::newRegistry);
        DEFERRED_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CtxVarTypes::setup);
    }

    private static void newRegistry(NewRegistryEvent event) {
        REGISTRY = event.create(new RegistryBuilder().setMaxID(256).setName(new ResourceLocation("spells_and_shields", "context_variables")));
    }

    private static void setup(FMLCommonSetupEvent event) {
        ((CtxVarType)DOUBLE.get()).addConverter((CtxVarType)STRING.get(), double0 -> double0.toString());
        ((CtxVarType)INT.get()).addConverter((CtxVarType)DOUBLE.get(), integer -> integer.doubleValue());
        ((CtxVarType)INT.get()).addConverter((CtxVarType)STRING.get(), integer -> integer.toString());
        ((CtxVarType)VEC3.get()).addConverter((CtxVarType)BLOCK_POS.get(), vec3 -> new BlockPos(vec3));
        ((CtxVarType)BLOCK_POS.get()).addConverter((CtxVarType)VEC3.get(), blockPos -> Vec3.m_82512_((Vec3i)blockPos));
        ((CtxVarType)BOOLEAN.get()).addConverter((CtxVarType)STRING.get(), bool -> bool.toString());
    }

    static {
        DEFERRED_REGISTER = DeferredRegister.create((ResourceLocation)new ResourceLocation("spells_and_shields", "context_variables"), (String)"spells_and_shields");
        INT = DEFERRED_REGISTER.register("int", () -> new CtxVarType<Integer>(Integer::intValue, (Codec<Integer>)Codec.INT));
        DOUBLE = DEFERRED_REGISTER.register("double", () -> new CtxVarType<Double>(Double::doubleValue, (Codec<Double>)Codec.DOUBLE));
        VEC3 = DEFERRED_REGISTER.register("vec3", () -> new CtxVarType<Vec3>(vec3 -> vec3, Vec3.f_231074_));
        BLOCK_POS = DEFERRED_REGISTER.register("block_pos", () -> new CtxVarType<BlockPos>(blockPos -> blockPos, BlockPos.f_121852_));
        BOOLEAN = DEFERRED_REGISTER.register("boolean", () -> new CtxVarType<Boolean>(Boolean::booleanValue, (Codec<Boolean>)Codec.BOOL));
        TAG = DEFERRED_REGISTER.register("tag", () -> new CtxVarType<CompoundTag>(CompoundTag::m_6426_, CompoundTag.f_128325_));
        STRING = DEFERRED_REGISTER.register("string", () -> new CtxVarType<String>(s -> s, (Codec<String>)Codec.STRING));
    }
}

