/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.registers;

import de.cas_ual_ty.spells.requirement.AdvancementRequirement;
import de.cas_ual_ty.spells.requirement.BookshelvesRequirement;
import de.cas_ual_ty.spells.requirement.ItemRequirement;
import de.cas_ual_ty.spells.requirement.RequirementType;
import de.cas_ual_ty.spells.requirement.WrappedRequirement;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class RequirementTypes {
    public static Supplier<IForgeRegistry<RequirementType<?>>> REGISTRY;
    private static final DeferredRegister<RequirementType<?>> DEFERRED_REGISTER;
    public static final RegistryObject<RequirementType<WrappedRequirement>> WRAPPED;
    public static final RegistryObject<RequirementType<BookshelvesRequirement>> BOOKSHELVES;
    public static final RegistryObject<RequirementType<AdvancementRequirement>> ADVANCEMENT;
    public static final RegistryObject<RequirementType<ItemRequirement>> ITEM;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RequirementTypes::newRegistry);
        DEFERRED_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static void newRegistry(NewRegistryEvent event) {
        REGISTRY = event.create(new RegistryBuilder().setMaxID(256).setName(new ResourceLocation("spells_and_shields", "requirements")));
    }

    static {
        DEFERRED_REGISTER = DeferredRegister.create((ResourceLocation)new ResourceLocation("spells_and_shields", "requirements"), (String)"spells_and_shields");
        WRAPPED = DEFERRED_REGISTER.register("client_wrap", () -> new RequirementType<WrappedRequirement>(WrappedRequirement::new, type -> WrappedRequirement.CODEC));
        BOOKSHELVES = DEFERRED_REGISTER.register("bookshelves", () -> new RequirementType<BookshelvesRequirement>(BookshelvesRequirement::new, BookshelvesRequirement::makeCodec));
        ADVANCEMENT = DEFERRED_REGISTER.register("advancement", () -> new RequirementType<AdvancementRequirement>(AdvancementRequirement::new, AdvancementRequirement::makeCodec));
        ITEM = DEFERRED_REGISTER.register("item", () -> new RequirementType<ItemRequirement>(ItemRequirement::new, ItemRequirement::makeCodec));
    }
}

