/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.registers;

import de.cas_ual_ty.spells.registers.RequirementTypes;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.requirement.AdvancementRequirement;
import de.cas_ual_ty.spells.requirement.BookshelvesRequirement;
import de.cas_ual_ty.spells.requirement.ItemRequirement;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementType;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.icon.DefaultSpellIcon;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.SpellsCodecs;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

public class SpellTrees {
    private static Supplier<IForgeRegistry<SpellTree>> REGISTRY;
    public static ResourceKey<Registry<SpellTree>> REGISTRY_KEY;
    public static final String KEY_NETHER = "spell_tree.spells_and_shields.nether";
    public static final String KEY_OCEAN = "spell_tree.spells_and_shields.ocean";
    public static final String KEY_MINING = "spell_tree.spells_and_shields.mining";
    public static final String KEY_MOVEMENT = "spell_tree.spells_and_shields.movement";
    public static final String KEY_END = "spell_tree.spells_and_shields.end";

    public static Registry<SpellTree> getRegistry(LevelAccessor level) {
        return level.m_5962_().m_175515_(REGISTRY_KEY);
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SpellTrees::newRegistry);
        MinecraftForge.EVENT_BUS.addListener(SpellTrees::levelLoad);
    }

    private static void newRegistry(NewRegistryEvent event) {
        REGISTRY = event.create(new RegistryBuilder().setMaxID(1024).dataPackRegistry(SpellsCodecs.SPELL_TREE_CONTENTS).setName(new ResourceLocation("spells_and_shields", "spell_trees")).onCreate((registry, stage) -> {
            REGISTRY_KEY = registry.getRegistryKey();
        }));
    }

    private static void levelLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Registry<SpellTree> registry = SpellTrees.getRegistry(event.getLevel());
        registry.forEach(spellTree -> spellTree.assignNodeIds(registry.m_7981_(spellTree)));
    }

    public static SpellTree fireTree(Function<ResourceLocation, Holder<Spell>> spellGetter) {
        return SpellTree.builder((Component)Component.m_237115_((String)KEY_NETHER)).icon(DefaultSpellIcon.make(new ResourceLocation("textures/mob_effect/fire_resistance.png"))).add(spellGetter.apply(Spells.FIRE_BALL)).levelCost(15).learnRequirements(SpellTrees.bookshelves(28)).add(spellGetter.apply(Spells.TOGGLE_LAVA_WALKER)).levelCost(20).learnRequirements(SpellTrees.bookshelves(19)).add(spellGetter.apply(Spells.TOGGLE_FIRE_RESISTANCE)).levelCost(30).learnRequirements(SpellTrees.bookshelves(30)).leaf().add(spellGetter.apply(Spells.DRAIN_FLAME)).levelCost(20).learnRequirements(SpellTrees.bookshelves(20)).leaf().leaf().add(spellGetter.apply(Spells.GHAST)).levelCost(10).learnRequirements(SpellTrees.bookshelves(20), SpellTrees.item(Items.f_42586_, 1, true)).add(spellGetter.apply(Spells.FLAMETHROWER)).levelCost(20).learnRequirements(SpellTrees.bookshelves(24)).finish();
    }

    public static SpellTree waterTree(Function<ResourceLocation, Holder<Spell>> spellGetter) {
        return SpellTree.builder((Component)Component.m_237115_((String)KEY_OCEAN)).icon(DefaultSpellIcon.make(new ResourceLocation("textures/mob_effect/dolphins_grace.png"))).add(spellGetter.apply(Spells.TOGGLE_WATER_BREATHING)).levelCost(10).add(spellGetter.apply(Spells.TOGGLE_REGENERATION)).levelCost(20).learnRequirements(SpellTrees.bookshelves(20)).add(spellGetter.apply(Spells.GROWTH)).levelCost(20).learnRequirements(SpellTrees.bookshelves(20)).leaf().add(spellGetter.apply(Spells.PERMANENT_AQUA_AFFINITY)).levelCost(20).learnRequirements(SpellTrees.bookshelves(20)).leaf().leaf().add(spellGetter.apply(Spells.WATER_LEAP)).levelCost(5).learnRequirements(SpellTrees.bookshelves(10)).add(spellGetter.apply(Spells.TOGGLE_DOLPHINS_GRACE)).levelCost(30).learnRequirements(SpellTrees.bookshelves(30)).leaf().add(spellGetter.apply(Spells.TOGGLE_FROST_WALKER)).levelCost(10).learnRequirements(SpellTrees.bookshelves(14)).leaf().leaf().add(spellGetter.apply(Spells.WATER_WHIP)).levelCost(10).learnRequirements(SpellTrees.bookshelves(10)).add(spellGetter.apply(Spells.POTION_SHOT)).levelCost(10).learnRequirements(SpellTrees.bookshelves(10)).leaf().leaf().add(spellGetter.apply(Spells.LIGHTNING_STRIKE)).levelCost(25).learnRequirements(SpellTrees.bookshelves(24), SpellTrees.advancement("adventure/lightning_rod_with_villager_no_fire")).leaf().finish();
    }

    public static SpellTree earthTree(Function<ResourceLocation, Holder<Spell>> spellGetter) {
        return SpellTree.builder((Component)Component.m_237115_((String)KEY_MINING)).icon(DefaultSpellIcon.make(new ResourceLocation("textures/mob_effect/haste.png"))).add(spellGetter.apply(Spells.BLAST_SMELT)).levelCost(5).learnRequirements(SpellTrees.bookshelves(8)).add(spellGetter.apply(Spells.SILENCE_TARGET)).levelCost(25).learnRequirements(SpellTrees.bookshelves(26)).add(spellGetter.apply(Spells.TOGGLE_MAGIC_IMMUNE)).levelCost(25).learnRequirements(SpellTrees.bookshelves(26)).leaf().leaf().add(spellGetter.apply(Spells.INSTANT_MINE)).levelCost(15).learnRequirements(SpellTrees.bookshelves(18)).add(spellGetter.apply(Spells.TOGGLE_HASTE)).levelCost(25).learnRequirements(SpellTrees.bookshelves(24)).leaf().leaf().add(spellGetter.apply(Spells.SPIT_METAL)).levelCost(10).learnRequirements(SpellTrees.bookshelves(12)).finish();
    }

    public static SpellTree airTree(Function<ResourceLocation, Holder<Spell>> spellGetter) {
        return SpellTree.builder((Component)Component.m_237115_((String)KEY_MOVEMENT)).icon(DefaultSpellIcon.make(new ResourceLocation("textures/mob_effect/jump_boost.png"))).add(spellGetter.apply(Spells.TOGGLE_JUMP_BOOST)).levelCost(15).learnRequirements(SpellTrees.bookshelves(12)).add(spellGetter.apply(Spells.LEAP)).levelCost(10).learnRequirements(SpellTrees.bookshelves(14)).add(spellGetter.apply(Spells.TOGGLE_SPEED)).levelCost(20).learnRequirements(SpellTrees.bookshelves(20)).leaf().add(spellGetter.apply(Spells.JUMP)).levelCost(14).learnRequirements(SpellTrees.bookshelves(14)).add(spellGetter.apply(Spells.POCKET_ROCKET)).levelCost(25).learnRequirements(SpellTrees.bookshelves(20)).leaf().leaf().add(spellGetter.apply(Spells.MANA_SOLES)).levelCost(15).learnRequirements(SpellTrees.bookshelves(12)).add(spellGetter.apply(Spells.TOGGLE_SLOW_FALLING)).levelCost(15).learnRequirements(SpellTrees.bookshelves(16)).leaf().leaf().add(spellGetter.apply(Spells.BLOW_ARROW)).levelCost(10).learnRequirements(SpellTrees.bookshelves(16)).add(spellGetter.apply(Spells.PRESSURIZE)).levelCost(20).learnRequirements(SpellTrees.bookshelves(18)).leaf().leaf().finish();
    }

    public static SpellTree enderTree(Function<ResourceLocation, Holder<Spell>> spellGetter) {
        return SpellTree.builder((Component)Component.m_237115_((String)KEY_END)).icon(DefaultSpellIcon.make(new ResourceLocation("spells_and_shields", "textures/spell/teleport.png"))).add(spellGetter.apply(Spells.RANDOM_TELEPORT)).levelCost(20).learnRequirements(SpellTrees.bookshelves(28)).hiddenRequirements(SpellTrees.advancement("end/root")).add(spellGetter.apply(Spells.FORCED_TELEPORT)).levelCost(30).learnRequirements(SpellTrees.bookshelves(28)).leaf().add(spellGetter.apply(Spells.TELEPORT)).levelCost(30).learnRequirements(SpellTrees.bookshelves(28), SpellTrees.advancement("end/respawn_dragon")).add(spellGetter.apply(Spells.ENDER_ARMY)).levelCost(50).learnRequirements(SpellTrees.bookshelves(30), SpellTrees.item(Items.f_42104_, 1, false)).finish();
    }

    public static Requirement bookshelves(int bookshelves) {
        return new BookshelvesRequirement((RequirementType)RequirementTypes.BOOKSHELVES.get(), bookshelves);
    }

    public static Requirement advancement(String advancementRL) {
        return new AdvancementRequirement((RequirementType)RequirementTypes.ADVANCEMENT.get(), new ResourceLocation(advancementRL));
    }

    public static Requirement item(Item item, int count, boolean consume) {
        return new ItemRequirement((RequirementType)RequirementTypes.ITEM.get(), new ItemStack((ItemLike)item, count), consume);
    }
}

