/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.registers;

import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.target.LivingEntityTarget;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.target.PositionTarget;
import de.cas_ual_ty.spells.spell.target.StaticTarget;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class TargetTypes {
    public static Supplier<IForgeRegistry<ITargetType<?>>> REGISTRY;
    private static final DeferredRegister<ITargetType<?>> DEFERRED_REGISTER;
    public static final RegistryObject<ITargetType<EntityTarget>> ENTITY;
    public static final RegistryObject<ITargetType<LivingEntityTarget>> LIVING_ENTITY;
    public static final RegistryObject<ITargetType<PlayerTarget>> PLAYER;
    public static final RegistryObject<ITargetType<ItemTarget>> ITEM;
    public static final RegistryObject<ITargetType<PositionTarget>> POSITION;
    public static final RegistryObject<ITargetType<StaticTarget>> STATIC;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TargetTypes::newRegistry);
        DEFERRED_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static void newRegistry(NewRegistryEvent event) {
        REGISTRY = event.create(new RegistryBuilder().setMaxID(256).setName(new ResourceLocation("spells_and_shields", "targets")));
    }

    static {
        DEFERRED_REGISTER = DeferredRegister.create((ResourceLocation)new ResourceLocation("spells_and_shields", "targets"), (String)"spells_and_shields");
        ENTITY = DEFERRED_REGISTER.register("entity", () -> t -> t instanceof EntityTarget);
        LIVING_ENTITY = DEFERRED_REGISTER.register("living_entity", () -> t -> t instanceof LivingEntityTarget);
        PLAYER = DEFERRED_REGISTER.register("player", () -> t -> t instanceof PlayerTarget);
        ITEM = DEFERRED_REGISTER.register("item", () -> t -> t instanceof ItemTarget);
        POSITION = DEFERRED_REGISTER.register("position", () -> t -> t instanceof PositionTarget);
        STATIC = DEFERRED_REGISTER.register("static", () -> t -> t instanceof StaticTarget);
    }
}

