/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementType;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class AdvancementRequirement
extends Requirement {
    public static final String ERROR_SUFFIX = ".error";
    protected ResourceLocation advancementRL;

    public static Codec<AdvancementRequirement> makeCodec(RequirementType<AdvancementRequirement> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("advancement").forGetter(AdvancementRequirement::getAdvancementRL)).apply((Applicative)instance, advancementRL -> new AdvancementRequirement(type, (ResourceLocation)advancementRL)));
    }

    public AdvancementRequirement(RequirementType<?> type) {
        super(type);
    }

    public AdvancementRequirement(RequirementType<?> type, ResourceLocation advancementRL) {
        this(type);
        this.advancementRL = advancementRL;
    }

    public ResourceLocation getAdvancementRL() {
        return this.advancementRL;
    }

    @Override
    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Player player = spellProgressionHolder.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Advancement a = player2.f_8924_.m_129889_().m_136041_(this.advancementRL);
            if (a != null) {
                return player2.m_8960_().m_135996_(a).m_8193_();
            }
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Player player = spellProgressionHolder.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Advancement a = player2.f_8924_.m_129889_().m_136041_(this.advancementRL);
            if (a != null) {
                return Component.m_237110_((String)this.descriptionId, (Object[])new Object[]{a.m_138320_().m_14977_()});
            }
            return Component.m_237110_((String)(this.descriptionId + ERROR_SUFFIX), (Object[])new Object[]{this.advancementRL.toString()});
        }
        return Component.m_237119_();
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130085_(this.advancementRL);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        this.advancementRL = (ResourceLocation)buf.readRegistryId();
    }
}

