/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementType;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;

public class ItemRequirement
extends Requirement {
    public static final String CONSUMED_SUFFIX = ".consumed";
    public static final String MULTIPLE_SUFFIX = ".multiple";
    public static final String MULTIPLE_CONSUMED_SUFFIX = ".consumed.multiple";
    protected ItemStack itemStack;
    protected boolean consume;

    public static Codec<ItemRequirement> makeCodec(RequirementType<ItemRequirement> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(ItemRequirement::getItemStack), (App)Codec.BOOL.fieldOf("consume").forGetter(ItemRequirement::getConsume)).apply((Applicative)instance, (itemStack, consume) -> new ItemRequirement(type, (ItemStack)itemStack, (boolean)consume)));
    }

    public ItemRequirement(RequirementType<?> type) {
        super(type);
    }

    public ItemRequirement(RequirementType<?> type, ItemStack itemStack, boolean consume) {
        this(type);
        this.itemStack = itemStack;
        this.consume = consume;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean getConsume() {
        return this.consume;
    }

    @Override
    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Inventory inventory = spellProgressionHolder.getPlayer().m_150109_();
        return inventory.m_36022_(item -> item.m_41720_() == this.itemStack.m_41720_(), 0, SpellsUtil.EMPTY_CONTAINER) >= this.itemStack.m_41613_();
    }

    @Override
    public void onSpellLearned(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        if (this.consume && !spellProgressionHolder.getPlayer().m_7500_()) {
            Inventory inventory = spellProgressionHolder.getPlayer().m_150109_();
            inventory.m_36022_(item -> item.m_41720_() == this.itemStack.m_41720_(), this.itemStack.m_41613_(), SpellsUtil.EMPTY_CONTAINER);
        }
    }

    @Override
    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        Inventory inventory = spellProgressionHolder.getPlayer().m_150109_();
        if (this.itemStack.m_41613_() == 1) {
            if (this.consume) {
                return Component.m_237110_((String)(this.getDescriptionId() + CONSUMED_SUFFIX), (Object[])new Object[]{this.itemStack.m_41786_()});
            }
            return Component.m_237110_((String)this.getDescriptionId(), (Object[])new Object[]{this.itemStack.m_41786_()});
        }
        if (this.consume) {
            return Component.m_237110_((String)(this.getDescriptionId() + MULTIPLE_CONSUMED_SUFFIX), (Object[])new Object[]{this.itemStack.m_41613_(), this.itemStack.m_41786_()});
        }
        return Component.m_237110_((String)(this.getDescriptionId() + MULTIPLE_SUFFIX), (Object[])new Object[]{this.itemStack.m_41613_(), this.itemStack.m_41786_()});
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.writeBoolean(this.consume);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        this.itemStack = buf.m_130267_();
        this.consume = buf.readBoolean();
    }
}

