/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.registers.RequirementTypes;
import de.cas_ual_ty.spells.requirement.RequirementType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.ContainerLevelAccess;

public abstract class Requirement {
    public final RequirementType<?> type;
    protected String descriptionId;

    public Requirement(RequirementType<?> type) {
        this.type = type;
        ResourceLocation rl = RequirementTypes.REGISTRY.get().getKey(type);
        this.descriptionId = "requirement." + rl.m_135827_() + "." + rl.m_135815_();
    }

    public RequirementType<?> getType() {
        return this.type;
    }

    public abstract boolean passes(SpellProgressionHolder var1, ContainerLevelAccess var2);

    public void onSpellLearned(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
    }

    public abstract MutableComponent makeDescription(SpellProgressionHolder var1, ContainerLevelAccess var2);

    public String getDescriptionId() {
        return this.descriptionId;
    }

    public abstract void writeToBuf(FriendlyByteBuf var1);

    public abstract void readFromBuf(FriendlyByteBuf var1);
}

