/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.requirement;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import de.cas_ual_ty.spells.capability.SpellProgressionHolder;
import de.cas_ual_ty.spells.registers.RequirementTypes;
import de.cas_ual_ty.spells.requirement.Requirement;
import de.cas_ual_ty.spells.requirement.RequirementStatus;
import de.cas_ual_ty.spells.requirement.RequirementType;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.ContainerLevelAccess;

public class WrappedRequirement
extends Requirement {
    public static final Codec<WrappedRequirement> CODEC = new PrimitiveCodec<WrappedRequirement>(){

        public <T> DataResult<WrappedRequirement> read(DynamicOps<T> ops, T input) {
            return DataResult.error((String)"Can not (de)serialize a wrapped requirement");
        }

        public <T> T write(DynamicOps<T> ops, WrappedRequirement value) {
            return (T)ops.empty();
        }
    };
    protected Requirement requirement;
    protected RequirementStatus status;
    protected MutableComponent component;

    public WrappedRequirement(RequirementType<?> type) {
        super(type);
    }

    protected WrappedRequirement(RequirementType<?> type, Requirement requirement, RequirementStatus status, MutableComponent component) {
        this(type);
        this.requirement = requirement;
        this.status = status;
        this.component = component;
    }

    public WrappedRequirement(RequirementType<?> type, Requirement requirement) {
        this(type, requirement, RequirementStatus.UNDECIDED, null);
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public RequirementStatus getStatus() {
        return this.status;
    }

    public MutableComponent getComponent() {
        return this.component;
    }

    @Override
    public boolean passes(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.status.isDecided() ? this.status.passes : this.requirement.passes(spellProgressionHolder, access);
    }

    @Override
    public void onSpellLearned(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        this.requirement.onSpellLearned(spellProgressionHolder, access);
    }

    public void decide(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access, boolean hidden) {
        this.status = RequirementStatus.decide(this.passes(spellProgressionHolder, access));
        this.component = Component.m_237113_((String)"- ").m_7220_((Component)this.makeDescription(spellProgressionHolder, access).m_130940_(hidden ? ChatFormatting.DARK_GRAY : (this.status.passes ? ChatFormatting.GREEN : ChatFormatting.RED)));
    }

    @Override
    public MutableComponent makeDescription(SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access) {
        return this.component != null ? this.component : this.requirement.makeDescription(spellProgressionHolder, access);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeByte(this.status.ordinal());
        buf.m_130083_((Component)this.component);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf buf) {
        this.status = RequirementStatus.values()[buf.readByte()];
        this.component = (MutableComponent)buf.m_130238_();
    }

    public static WrappedRequirement wrap(Requirement requirement, SpellProgressionHolder spellProgressionHolder, ContainerLevelAccess access, boolean hidden) {
        WrappedRequirement w = new WrappedRequirement((RequirementType)RequirementTypes.WRAPPED.get(), requirement);
        w.decide(spellProgressionHolder, access, hidden);
        return w;
    }
}

