/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell;

import de.cas_ual_ty.spells.registers.SpellIconTypes;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.icon.DefaultSpellIcon;
import de.cas_ual_ty.spells.spell.icon.SpellIcon;
import de.cas_ual_ty.spells.spell.icon.SpellIconType;
import de.cas_ual_ty.spells.spell.variable.CtxVar;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class Spell {
    protected List<SpellAction> spellActions;
    protected SpellIcon icon;
    protected Component title;
    protected List<Component> tooltip;
    protected float manaCost;
    private List<CtxVar<?>> parameters;
    private List<String> events;

    public Spell(List<SpellAction> spellActions, SpellIcon icon, Component title, List<Component> tooltip, float manaCost, List<CtxVar<?>> parameters, List<String> events) {
        this.spellActions = spellActions;
        this.icon = icon;
        this.title = title;
        this.tooltip = tooltip;
        this.manaCost = manaCost;
        this.parameters = parameters;
        this.events = events;
    }

    public Spell(SpellIcon icon, Component title, float manaCost) {
        this(new ArrayList<SpellAction>(), icon, title, new LinkedList<Component>(), manaCost, new LinkedList(), new LinkedList<String>());
    }

    public Spell(SpellIcon icon, String titleKey, float manaCost) {
        this(icon, (Component)Component.m_237115_((String)titleKey), manaCost);
    }

    public Spell(ResourceLocation icon, Component title, float manaCost) {
        this((SpellIcon)new DefaultSpellIcon((SpellIconType)SpellIconTypes.DEFAULT.get(), icon), title, manaCost);
    }

    public Spell(String modId, String icon, String titleKey, float manaCost) {
        this(new ResourceLocation(modId, "textures/spell/" + icon + ".png"), (Component)Component.m_237115_((String)titleKey), manaCost);
    }

    public Spell addTooltip(Component component) {
        this.tooltip.add(component);
        return this;
    }

    public Spell addAction(SpellAction action) {
        this.spellActions.add(action);
        return this;
    }

    public <T> Spell addParameter(CtxVar<T> ctxVar) {
        this.parameters.add(ctxVar);
        return this;
    }

    public <T> Spell addParameter(CtxVarType<T> type, String name, T value) {
        return this.addParameter(new CtxVar<T>(type, name, value));
    }

    public Spell addEventHook(Object eventId) {
        this.events.add(eventId.toString());
        return this;
    }

    public List<SpellAction> getSpellActions() {
        return this.spellActions;
    }

    public SpellIcon getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.title;
    }

    public List<Component> getTooltip() {
        return this.tooltip;
    }

    public float getManaCost() {
        return this.manaCost;
    }

    public List<CtxVar<?>> getParameters() {
        return this.parameters;
    }

    public List<String> getEventsList() {
        return this.events;
    }

    public List<Component> makeTooltipList(@Nullable Component keyBindTooltip) {
        LinkedList<Component> tooltip = new LinkedList<Component>();
        tooltip.add((Component)MutableComponent.m_237204_((ComponentContents)this.getTitle().m_214077_()).m_130940_(ChatFormatting.YELLOW));
        if (keyBindTooltip != null) {
            tooltip.add(keyBindTooltip);
        }
        tooltip.addAll(this.getTooltip());
        return tooltip;
    }
}

