/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell;

import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.Spells;
import de.cas_ual_ty.spells.spell.Spell;
import de.cas_ual_ty.spells.spell.context.BuiltinTargetGroups;
import de.cas_ual_ty.spells.spell.context.BuiltinVariables;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVar;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spelltree.SpellNodeId;
import de.cas_ual_ty.spells.spelltree.SpellTree;
import de.cas_ual_ty.spells.util.ManaTooltipComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpellInstance {
    private Holder<Spell> spell;
    private float manaCost;
    private List<CtxVar<?>> parameters;
    private SpellNodeId nodeId;
    private Optional<TooltipComponent> tooltipComponent;

    public SpellInstance(Holder<Spell> spell, float manaCost, List<CtxVar<?>> parameters) {
        this.spell = spell;
        this.manaCost = manaCost;
        this.parameters = parameters;
        this.nodeId = null;
        this.tooltipComponent = null;
    }

    public SpellInstance(Holder<Spell> spell, float manaCost) {
        this(spell, manaCost, new LinkedList());
    }

    public SpellInstance(Holder<Spell> spell) {
        this(spell, -1.0f, new LinkedList());
    }

    public <T> SpellInstance addParameter(CtxVar<T> ctxVar) {
        this.parameters.add(ctxVar);
        return this;
    }

    public void setManaCost(float manaCost) {
        this.manaCost = manaCost;
    }

    public void initId(SpellNodeId nodeId) {
        this.nodeId = nodeId;
    }

    public Holder<Spell> getSpell() {
        return this.spell;
    }

    public float getManaCost() {
        return this.manaCost;
    }

    public List<CtxVar<?>> getParameters() {
        return this.parameters;
    }

    public SpellNodeId getNodeId() {
        return this.nodeId;
    }

    public float getAppliedManaCost() {
        return this.manaCost >= 0.0f ? this.manaCost : ((Spell)this.spell.get()).getManaCost();
    }

    public Optional<TooltipComponent> getTooltipComponent() {
        if (this.tooltipComponent == null) {
            float applied = this.getAppliedManaCost();
            this.tooltipComponent = applied != 0.0f ? Optional.of(new ManaTooltipComponent(applied)) : Optional.empty();
        }
        return this.tooltipComponent;
    }

    public boolean run(Player owner, String activation) {
        return this.run(owner.f_19853_, owner, activation);
    }

    public boolean run(Level level, @Nullable Player owner, String activation) {
        return this.run(level, owner, activation, false, ctx -> {}, ctx -> {});
    }

    public boolean run(Level level, @Nullable Player owner, String activation, Consumer<SpellContext> preRun) {
        return this.run(level, owner, activation, false, preRun, ctx -> {});
    }

    public boolean forceRun(Level level, @Nullable Player owner, String activation, Consumer<SpellContext> preRun) {
        return this.run(level, owner, activation, true, preRun, ctx -> {});
    }

    public boolean run(Player owner, String event, Consumer<SpellContext> toContext, Consumer<SpellContext> fromContext) {
        return this.run(owner.f_19853_, owner, event, false, toContext, fromContext);
    }

    public boolean run(Level level, @Nullable Player owner, String activation, boolean force, Consumer<SpellContext> preRun, Consumer<SpellContext> postRun) {
        if (((Spell)this.spell.get()).getEventsList().contains(activation) || force) {
            SpellContext ctx = this.initializeContext(level, owner, activation);
            preRun.accept(ctx);
            ctx.run();
            postRun.accept(ctx);
            return true;
        }
        return false;
    }

    public SpellContext initializeContext(Level level, @Nullable Player owner, String activation) {
        SpellContext ctx = new SpellContext(level, owner, this);
        ctx.activate(activation);
        ctx.initCtxVar(new CtxVar<Double>((CtxVarType)CtxVarTypes.DOUBLE.get(), BuiltinVariables.MANA_COST.name, Double.valueOf(this.getAppliedManaCost())));
        ctx.initCtxVar(new CtxVar<Integer>((CtxVarType)CtxVarTypes.INT.get(), BuiltinVariables.MIN_BLOCK_HEIGHT.name, level.m_141937_()));
        ctx.initCtxVar(new CtxVar<Integer>((CtxVarType)CtxVarTypes.INT.get(), BuiltinVariables.MAX_BLOCK_HEIGHT.name, level.m_151558_() - 1));
        if (owner != null) {
            ctx.getOrCreateTargetGroup(BuiltinTargetGroups.OWNER.targetGroup).addTargets((Target)Target.of((Entity)owner));
        }
        ((Spell)this.spell.get()).getParameters().forEach(ctx::initCtxVar);
        this.parameters.forEach(ctx::initCtxVar);
        return ctx;
    }

    public SpellInstance copy() {
        return new SpellInstance(this.spell, this.manaCost, new LinkedList(this.parameters));
    }

    public void toNbt(CompoundTag nbt, Registry<Spell> spellRegistry) {
        if (this.nodeId != null) {
            this.nodeId.toNbt(nbt);
        } else {
            nbt.m_128359_("spellId", ((ResourceLocation)this.spell.m_203439_().map(ResourceKey::m_135782_, arg_0 -> spellRegistry.m_7981_(arg_0))).toString());
        }
    }

    @javax.annotation.Nullable
    public static SpellInstance fromNbt(CompoundTag nbt, Registry<SpellTree> spellTreeRegistry, Registry<Spell> spellRegistry) {
        Holder holder;
        SpellNodeId nodeId = SpellNodeId.fromNbt(nbt);
        if (nodeId != null) {
            return nodeId.getSpellInstance(spellTreeRegistry);
        }
        if (nbt.m_128425_("spellId", 8) && (holder = (Holder)spellRegistry.m_203636_(ResourceKey.m_135785_(Spells.REGISTRY_KEY, (ResourceLocation)new ResourceLocation(nbt.m_128461_("spellId")))).orElse(null)) != null) {
            return new SpellInstance((Holder<Spell>)holder);
        }
        return null;
    }
}

