/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.SpellsAndShields;
import de.cas_ual_ty.spells.network.RunActionOnClientMessage;
import de.cas_ual_ty.spells.spell.action.IClientAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.SyncedSpellActionType;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsCodecs;
import net.minecraftforge.network.PacketDistributor;

public abstract class SpellAction {
    public final SpellActionType<?> type;
    protected String activation;

    public static <T extends SpellAction> RecordCodecBuilder<T, SpellActionType<?>> makeTypeCodec() {
        return SpellsCodecs.SPELL_ACTION_TYPE.fieldOf(ParamNames.actionType()).forGetter(SpellAction::getType);
    }

    public static <T extends SpellAction> RecordCodecBuilder<T, String> activationCodec() {
        return Codec.STRING.fieldOf(ParamNames.activation()).forGetter(SpellAction::getActivation);
    }

    public SpellAction(SpellActionType<?> type) {
        this.type = type;
    }

    public SpellAction(SpellActionType<?> type, String activation) {
        this(type);
        this.activation = activation;
    }

    public SpellActionType<?> getType() {
        return this.type;
    }

    public String getActivation() {
        return this.activation;
    }

    public void doAction(SpellContext ctx) {
        this.wasActivated(ctx);
    }

    public boolean doActivate(SpellContext ctx) {
        return this.activation.isEmpty() || ctx.isActivated(this.activation);
    }

    protected abstract void wasActivated(SpellContext var1);

    public void sendClientAction(PacketDistributor.PacketTarget packetTarget, IClientAction clientAction) {
        SpellActionType<?> spellActionType = this.getType();
        if (spellActionType instanceof SyncedSpellActionType) {
            SyncedSpellActionType syncedType = (SyncedSpellActionType)spellActionType;
            SpellsAndShields.CHANNEL.send(packetTarget, (Object)new RunActionOnClientMessage(syncedType, clientAction));
        }
    }
}

