/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.ai;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.GetTargetAttributeAction;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.LivingEntityTarget;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class GetMobTargetAction
extends GetTargetAttributeAction<LivingEntityTarget> {
    protected String target;
    protected String hasTarget;

    public static Codec<GetMobTargetAction> makeCodec(SpellActionType<GetMobTargetAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(GetMobTargetAction.activationCodec(), GetMobTargetAction.sourceCodec(), (App)Codec.STRING.fieldOf(ParamNames.destinationTarget("target")).forGetter(GetMobTargetAction::getTarget), (App)Codec.STRING.fieldOf(ParamNames.var("has_target")).forGetter(GetMobTargetAction::getHasTarget)).apply((Applicative)instance, (activation, source, target, hasTarget) -> new GetMobTargetAction(type, (String)activation, (String)source, (String)target, (String)hasTarget)));
    }

    public static GetMobTargetAction make(Object activation, Object source, Object target, String hasTarget) {
        return new GetMobTargetAction((SpellActionType)SpellActionTypes.GET_MOB_TARGET.get(), activation.toString(), source.toString(), target.toString(), hasTarget);
    }

    public GetMobTargetAction(SpellActionType<?> type) {
        super(type);
    }

    public GetMobTargetAction(SpellActionType<?> type, String activation, String source, String target, String hasTarget) {
        super(type, activation, source);
        this.target = target;
        this.hasTarget = hasTarget;
        if (!target.isEmpty()) {
            this.addTargetAttribute(e -> {
                EntityTarget entityTarget;
                LivingEntity patt2210$temp = e.getLivingEntity();
                if (patt2210$temp instanceof Mob) {
                    Mob mob = (Mob)patt2210$temp;
                    entityTarget = Target.of((Entity)mob.m_5448_());
                } else {
                    entityTarget = null;
                }
                return entityTarget;
            }, target);
        }
        if (!hasTarget.isEmpty()) {
            this.addVariableAttribute(e -> {
                Mob mob;
                LivingEntity patt2400$temp = e.getLivingEntity();
                return patt2400$temp instanceof Mob ? Boolean.valueOf((mob = (Mob)patt2400$temp).m_5448_() != null) : Boolean.valueOf(false);
            }, (CtxVarType)CtxVarTypes.BOOLEAN.get(), hasTarget);
        }
    }

    @Override
    public ITargetType<LivingEntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.LIVING_ENTITY.get();
    }

    public String getTarget() {
        return this.target;
    }

    public String getHasTarget() {
        return this.hasTarget;
    }
}

