/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class CheckTagAction
extends SpellAction {
    protected String registry;
    protected DynamicCtxVar<String> tag;
    protected DynamicCtxVar<String> entry;

    public static Codec<CheckTagAction> makeCodec(SpellActionType<CheckTagAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(CheckTagAction.activationCodec(), (App)Codec.STRING.fieldOf(ParamNames.paramStringImm("registry_id")).forGetter(CheckTagAction::getRegistry), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("tag")).forGetter(CheckTagAction::getTag), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("entry_id")).forGetter(CheckTagAction::getEntry)).apply((Applicative)instance, (activation, registry, tag, entry) -> new CheckTagAction(type, (String)activation, (String)registry, (DynamicCtxVar<String>)tag, (DynamicCtxVar<String>)entry)));
    }

    public static CheckTagAction make(Object activation, String registry, DynamicCtxVar<String> tag, DynamicCtxVar<String> entry) {
        return new CheckTagAction((SpellActionType)SpellActionTypes.CHECK_TAG.get(), activation.toString(), registry, tag, entry);
    }

    public CheckTagAction(SpellActionType<?> type) {
        super(type);
    }

    public CheckTagAction(SpellActionType<?> type, String activation, String registry, DynamicCtxVar<String> tag, DynamicCtxVar<String> entry) {
        super(type, activation);
        this.registry = registry;
        this.tag = tag;
        this.entry = entry;
    }

    public String getRegistry() {
        return this.registry;
    }

    public DynamicCtxVar<String> getTag() {
        return this.tag;
    }

    public DynamicCtxVar<String> getEntry() {
        return this.entry;
    }

    @Override
    protected void wasActivated(SpellContext ctx) {
        this.tag.getValue(ctx).ifPresent(tag -> this.entry.getValue(ctx).ifPresent(entry -> {
            if (!this.isTag(this.registry, (String)tag, (String)entry)) {
                ctx.deactivate(this.activation);
            }
        }));
    }

    protected <V> boolean isTag(String registryRL, String tagRL, String entryRL) {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(new ResourceLocation(registryRL));
        if (registry == null || registry.tags() == null) {
            return false;
        }
        ResourceKey registryKey = registry.getRegistryKey();
        TagKey tagKey = TagKey.m_203882_((ResourceKey)registryKey, (ResourceLocation)new ResourceLocation(tagRL));
        return registry.tags().getTag(tagKey).contains(registry.getValue(new ResourceLocation(entryRL)));
    }
}

