/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.GetTargetAttributeAction;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class GetEntityTypeAction
extends GetTargetAttributeAction<EntityTarget> {
    protected String entityType;
    protected String isLiving;
    protected String isPlayer;

    public static Codec<GetEntityTypeAction> makeCodec(SpellActionType<GetEntityTypeAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(GetEntityTypeAction.activationCodec(), GetEntityTypeAction.sourceCodec(), (App)Codec.STRING.fieldOf(ParamNames.var("entity_type")).forGetter(GetEntityTypeAction::getEntityType), (App)Codec.STRING.fieldOf(ParamNames.var("is_living")).forGetter(GetEntityTypeAction::isLiving), (App)Codec.STRING.fieldOf(ParamNames.var("is_player")).forGetter(GetEntityTypeAction::isPlayer)).apply((Applicative)instance, (activation, source, entityType, isLiving, isPlayer) -> new GetEntityTypeAction(type, (String)activation, (String)source, (String)entityType, (String)isLiving, (String)isPlayer)));
    }

    public static GetEntityTypeAction make(Object activation, Object source, String entityType, String isLiving, String isPlayer) {
        return new GetEntityTypeAction((SpellActionType)SpellActionTypes.GET_ENTITY_TYPE.get(), activation.toString(), source.toString(), entityType, isLiving, isPlayer);
    }

    public GetEntityTypeAction(SpellActionType<?> type) {
        super(type);
    }

    public GetEntityTypeAction(SpellActionType<?> type, String activation, String source, String entityType, String isLiving, String isPlayer) {
        super(type, activation, source);
        this.entityType = entityType;
        this.isLiving = isLiving;
        this.isPlayer = isPlayer;
        if (!entityType.isEmpty()) {
            this.addVariableAttribute(e -> ForgeRegistries.ENTITY_TYPES.getKey((Object)e.getEntity().m_6095_()).toString(), (CtxVarType)CtxVarTypes.STRING.get(), entityType);
        }
        if (!isLiving.isEmpty()) {
            this.addVariableAttribute(e -> e.getEntity() instanceof LivingEntity, (CtxVarType)CtxVarTypes.BOOLEAN.get(), isLiving);
        }
        if (!isPlayer.isEmpty()) {
            this.addVariableAttribute(e -> e.getEntity() instanceof Player, (CtxVarType)CtxVarTypes.BOOLEAN.get(), isPlayer);
        }
    }

    @Override
    public ITargetType<EntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ENTITY.get();
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String isLiving() {
        return this.isLiving;
    }

    public String isPlayer() {
        return this.isPlayer;
    }
}

