/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.base;

import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public abstract class GetTargetAttributeAction<T extends Target>
extends AffectSingleTypeAction<T> {
    protected List<TargetAttribute<T, ?>> targetAttributes = new LinkedList();
    protected List<VariableAttribute<T, ?>> variableAttributes = new LinkedList();

    public GetTargetAttributeAction(SpellActionType<?> type) {
        super(type);
    }

    public GetTargetAttributeAction(SpellActionType<?> type, String activation, String targets) {
        super(type, activation, targets);
    }

    protected <C extends Target> void addTargetAttribute(Function<T, C> getter, String targetGroup) {
        this.targetAttributes.add(new TargetAttribute<T, C>(getter, targetGroup));
    }

    protected <C> void addVariableAttribute(Function<T, C> getter, CtxVarType<C> varType, String varName) {
        this.variableAttributes.add(new VariableAttribute<T, C>(getter, varType, varName));
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, T t) {
        for (TargetAttribute<T, ?> targetAttribute : this.targetAttributes) {
            targetAttribute.apply(ctx, t);
        }
        for (VariableAttribute variableAttribute : this.variableAttributes) {
            variableAttribute.apply(ctx, t);
        }
    }

    protected record TargetAttribute<T extends Target, C extends Target>(Function<T, C> getter, String targetGroup) {
        public void apply(SpellContext ctx, T t) {
            Target c = (Target)this.getter.apply(t);
            if (c != null) {
                ctx.getOrCreateTargetGroup(this.targetGroup).addTargets(c);
            }
        }
    }

    protected record VariableAttribute<T extends Target, C>(Function<T, C> getter, CtxVarType<C> varType, String varName) {
        public void apply(SpellContext ctx, T t) {
            C c = this.getter.apply(t);
            if (c != null) {
                ctx.setCtxVar(this.varType, this.varName, c);
            }
        }
    }
}

