/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.control;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;

public class BooleanActivationAction
extends SpellAction {
    protected String toActivate;
    protected DynamicCtxVar<Boolean> operant;
    protected DynamicCtxVar<Boolean> activateIfTrue;
    protected DynamicCtxVar<Boolean> deactivateIfFalse;

    public static Codec<BooleanActivationAction> makeCodec(SpellActionType<BooleanActivationAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(BooleanActivationAction.activationCodec(), (App)Codec.STRING.fieldOf(ParamNames.interactedActivation("to_activate")).forGetter(BooleanActivationAction::getToActivate), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("input")).forGetter(BooleanActivationAction::getOperant), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("activate_if_true")).forGetter(BooleanActivationAction::getActivateIfTrue), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("deactivate_if_false")).forGetter(BooleanActivationAction::getDeactivateIfFalse)).apply((Applicative)instance, (activation, toActivate, operant, activateIfTrue, deactivateIfFalse) -> new BooleanActivationAction(type, (String)activation, (String)toActivate, (DynamicCtxVar<Boolean>)operant, (DynamicCtxVar<Boolean>)activateIfTrue, (DynamicCtxVar<Boolean>)deactivateIfFalse)));
    }

    public static BooleanActivationAction make(Object activation, Object toActivate, DynamicCtxVar<Boolean> operant, DynamicCtxVar<Boolean> activateIfTrue, DynamicCtxVar<Boolean> deactivateIfFalse) {
        return new BooleanActivationAction((SpellActionType)SpellActionTypes.BOOLEAN_ACTIVATION.get(), activation.toString(), toActivate.toString(), operant, activateIfTrue, deactivateIfFalse);
    }

    public BooleanActivationAction(SpellActionType<?> type) {
        super(type);
    }

    public BooleanActivationAction(SpellActionType<?> type, String activation, String toActivate, DynamicCtxVar<Boolean> operant, DynamicCtxVar<Boolean> activateIfTrue, DynamicCtxVar<Boolean> deactivateIfFalse) {
        super(type, activation);
        this.toActivate = toActivate;
        this.operant = operant;
        this.activateIfTrue = activateIfTrue;
        this.deactivateIfFalse = deactivateIfFalse;
    }

    public String getToActivate() {
        return this.toActivate;
    }

    public DynamicCtxVar<Boolean> getOperant() {
        return this.operant;
    }

    public DynamicCtxVar<Boolean> getActivateIfTrue() {
        return this.activateIfTrue;
    }

    public DynamicCtxVar<Boolean> getDeactivateIfFalse() {
        return this.deactivateIfFalse;
    }

    @Override
    protected void wasActivated(SpellContext ctx) {
        this.operant.getValue(ctx).ifPresent(operant -> {
            if (operant.booleanValue()) {
                this.activateIfTrue.getValue(ctx).ifPresent(activate -> {
                    if (activate.booleanValue()) {
                        ctx.activate(this.toActivate);
                    }
                });
            } else {
                this.deactivateIfFalse.getValue(ctx).ifPresent(deactivate -> {
                    if (deactivate.booleanValue()) {
                        ctx.deactivate(this.toActivate);
                    }
                });
            }
        });
    }
}

