/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.delayed;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.capability.DelayedSpellHolder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsCodecs;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ExtraCodecs;

public class AddDelayedSpellAction
extends AffectTypeAction<EntityTarget> {
    protected String removeActivation;
    protected DynamicCtxVar<Integer> tickTime;
    protected DynamicCtxVar<String> uuid;
    protected DynamicCtxVar<CompoundTag> tag;
    protected Map<String, String> eventsMap;

    public static Codec<AddDelayedSpellAction> makeCodec(SpellActionType<AddDelayedSpellAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(AddDelayedSpellAction.activationCodec(), AddDelayedSpellAction.multiTargetsCodec(), (App)Codec.STRING.fieldOf(ParamNames.asynchronousActivation("on_remove")).forGetter(AddDelayedSpellAction::getRemoveActivation), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("tick_time")).forGetter(AddDelayedSpellAction::getTickTime), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("uuid")).forGetter(AddDelayedSpellAction::getUuid), (App)((CtxVarType)CtxVarTypes.TAG.get()).refCodec().fieldOf(ParamNames.paramCompoundTag("extra_data")).forGetter(AddDelayedSpellAction::getTag), (App)Codec.optionalField((String)"events_map", (Codec)ExtraCodecs.m_184415_(() -> SpellsCodecs.STRING_MAP)).xmap(o -> o.orElse(new HashMap()), m -> m.isEmpty() ? Optional.empty() : Optional.of(m)).forGetter(AddDelayedSpellAction::getEventsMap)).apply((Applicative)instance, (activation, multiTargets, removeActivation, tickTime, uuid, tag, eventsMap) -> new AddDelayedSpellAction(type, (String)activation, (String)multiTargets, (String)removeActivation, (DynamicCtxVar<Integer>)tickTime, (DynamicCtxVar<String>)uuid, (DynamicCtxVar<CompoundTag>)tag, (Map<String, String>)eventsMap)));
    }

    public static AddDelayedSpellAction make(Object activation, Object multiTargets, Object removeActivation, DynamicCtxVar<Integer> tickTime, DynamicCtxVar<String> uuid, DynamicCtxVar<CompoundTag> tag, Map<String, String> eventsMap) {
        return new AddDelayedSpellAction((SpellActionType)SpellActionTypes.ADD_DELAYED_SPELL.get(), activation.toString(), multiTargets.toString(), removeActivation.toString(), tickTime, uuid, tag, eventsMap);
    }

    public AddDelayedSpellAction(SpellActionType<?> type) {
        super(type);
    }

    public AddDelayedSpellAction(SpellActionType<?> type, String activation, String multiTargets, String removeActivation, DynamicCtxVar<Integer> tickTime, DynamicCtxVar<String> uuid, DynamicCtxVar<CompoundTag> tag, Map<String, String> eventsMap) {
        super(type, activation, multiTargets);
        this.removeActivation = removeActivation;
        this.tickTime = tickTime;
        this.uuid = uuid;
        this.tag = tag;
        this.eventsMap = eventsMap;
    }

    public String getRemoveActivation() {
        return this.removeActivation;
    }

    public DynamicCtxVar<Integer> getTickTime() {
        return this.tickTime;
    }

    public DynamicCtxVar<String> getUuid() {
        return this.uuid;
    }

    public DynamicCtxVar<CompoundTag> getTag() {
        return this.tag;
    }

    public Map<String, String> getEventsMap() {
        return this.eventsMap;
    }

    @Override
    public ITargetType<EntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ENTITY.get();
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, EntityTarget target) {
        DelayedSpellHolder.getHolder(target.getEntity()).ifPresent(holder -> this.tickTime.getValue(ctx).ifPresent(tickTime -> this.tag.getValue(ctx).ifPresent(tag -> {
            if (tickTime > 0) {
                UUID uuid = this.uuid.getValue(ctx).map(SpellsUtil::uuidFromString).orElse(null);
                holder.addDelayedSpell(ctx.spell, uuid, this.removeActivation, (int)tickTime, (CompoundTag)tag, this.eventsMap);
            }
        })));
    }
}

