/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.LivingEntityTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.LinkedList;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.registries.ForgeRegistries;

public class ApplyPotionEffectAction
extends AffectTypeAction<LivingEntityTarget> {
    protected DynamicCtxVar<String> potion;

    public static Codec<ApplyPotionEffectAction> makeCodec(SpellActionType<ApplyPotionEffectAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ApplyPotionEffectAction.activationCodec(), ApplyPotionEffectAction.multiTargetsCodec(), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("potion")).forGetter(ApplyPotionEffectAction::getPotion)).apply((Applicative)instance, (activation, multiTargets, potion) -> new ApplyPotionEffectAction(type, (String)activation, (String)multiTargets, (DynamicCtxVar<String>)potion)));
    }

    public static ApplyPotionEffectAction make(Object activation, Object multiTargets, DynamicCtxVar<String> potion) {
        return new ApplyPotionEffectAction((SpellActionType)SpellActionTypes.APPLY_POTION_EFFECT.get(), activation.toString(), multiTargets.toString(), potion);
    }

    public ApplyPotionEffectAction(SpellActionType<?> type) {
        super(type);
    }

    public ApplyPotionEffectAction(SpellActionType<?> type, String activation, String multiTargets, DynamicCtxVar<String> potion) {
        super(type, activation, multiTargets);
        this.potion = potion;
    }

    public DynamicCtxVar<String> getPotion() {
        return this.potion;
    }

    @Override
    public ITargetType<LivingEntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.LIVING_ENTITY.get();
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, LivingEntityTarget target) {
        SpellsUtil.stringToObject(ctx, this.potion, ForgeRegistries.POTIONS).ifPresent(potion -> PotionUtils.m_43561_((Potion)potion, new LinkedList()).forEach(effect -> target.getLivingEntity().m_7292_(effect)));
    }
}

