/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.LivingEntityTarget;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.phys.Vec3;

public class SourcedKnockbackAction
extends AffectTypeAction<LivingEntityTarget> {
    protected DynamicCtxVar<Double> strength;
    protected String source;

    public static Codec<SourcedKnockbackAction> makeCodec(SpellActionType<SourcedKnockbackAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(SourcedKnockbackAction.activationCodec(), SourcedKnockbackAction.multiTargetsCodec(), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf(ParamNames.paramDouble("strength")).forGetter(SourcedKnockbackAction::getStrength), (App)Codec.STRING.fieldOf(ParamNames.singleTarget("source")).forGetter(SourcedKnockbackAction::getSource)).apply((Applicative)instance, (activation, multiTargets, strength, source) -> new SourcedKnockbackAction(type, (String)activation, (String)multiTargets, (DynamicCtxVar<Double>)strength, (String)source)));
    }

    public static SourcedKnockbackAction make(Object activation, Object multiTargets, DynamicCtxVar<Double> strength, Object source) {
        return new SourcedKnockbackAction((SpellActionType)SpellActionTypes.SOURCED_KNOCKBACK.get(), activation.toString(), multiTargets.toString(), strength, source.toString());
    }

    public SourcedKnockbackAction(SpellActionType<?> type) {
        super(type);
    }

    public SourcedKnockbackAction(SpellActionType<?> type, String activation, String multiTargets, DynamicCtxVar<Double> strength, String source) {
        super(type, activation, multiTargets);
        this.strength = strength;
        this.source = source;
    }

    @Override
    public ITargetType<LivingEntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.LIVING_ENTITY.get();
    }

    public DynamicCtxVar<Double> getStrength() {
        return this.strength;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, LivingEntityTarget target) {
        this.strength.getValue(ctx).ifPresent(strength -> ctx.getTargetGroup(this.source).getSingleTarget(t -> ((ITargetType)TargetTypes.POSITION.get()).ifType((Target)t, source -> {
            Vec3 vec = source.getPosition().m_82546_(target.getPosition()).m_82542_(1.0, 0.0, 1.0);
            target.getLivingEntity().m_147240_(strength.doubleValue(), vec.f_82479_, vec.f_82481_);
        })));
    }
}

