/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellAction;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnEntityAction
extends SpellAction {
    protected String entity;
    protected DynamicCtxVar<String> entityType;
    protected String position;
    protected DynamicCtxVar<Vec3> direction;
    protected DynamicCtxVar<Vec3> motion;
    protected DynamicCtxVar<CompoundTag> tag;

    public static Codec<SpawnEntityAction> makeCodec(SpellActionType<SpawnEntityAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(SpawnEntityAction.activationCodec(), (App)Codec.STRING.fieldOf(ParamNames.destinationTarget("entity")).forGetter(SpawnEntityAction::getEntity), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("entity_type")).forGetter(SpawnEntityAction::getEntityType), (App)Codec.STRING.fieldOf(ParamNames.singleTarget("position")).forGetter(SpawnEntityAction::getPosition), (App)((CtxVarType)CtxVarTypes.VEC3.get()).refCodec().fieldOf(ParamNames.paramVec3("direction")).forGetter(SpawnEntityAction::getDirection), (App)((CtxVarType)CtxVarTypes.VEC3.get()).refCodec().fieldOf(ParamNames.paramVec3("motion")).forGetter(SpawnEntityAction::getMotion), (App)((CtxVarType)CtxVarTypes.TAG.get()).refCodec().fieldOf(ParamNames.paramCompoundTag("tag")).forGetter(SpawnEntityAction::getTag)).apply((Applicative)instance, (activation, entity, entityType, position, direction, motion, tag) -> new SpawnEntityAction(type, (String)activation, (String)entity, (DynamicCtxVar<String>)entityType, (String)position, (DynamicCtxVar<Vec3>)direction, (DynamicCtxVar<Vec3>)motion, (DynamicCtxVar<CompoundTag>)tag)));
    }

    public static SpawnEntityAction make(Object activation, String entity, DynamicCtxVar<String> entityType, Object position, DynamicCtxVar<Vec3> direction, DynamicCtxVar<Vec3> motion, DynamicCtxVar<CompoundTag> tag) {
        return new SpawnEntityAction((SpellActionType)SpellActionTypes.SPAWN_ENTITY.get(), activation.toString(), entity, entityType, position.toString(), direction, motion, tag);
    }

    public SpawnEntityAction(SpellActionType<?> type) {
        super(type);
    }

    public SpawnEntityAction(SpellActionType<?> type, String activation, String entity, DynamicCtxVar<String> entityType, String position, DynamicCtxVar<Vec3> direction, DynamicCtxVar<Vec3> motion, DynamicCtxVar<CompoundTag> tag) {
        super(type, activation);
        this.entity = entity;
        this.entityType = entityType;
        this.position = position;
        this.direction = direction;
        this.motion = motion;
        this.tag = tag;
    }

    public String getEntity() {
        return this.entity;
    }

    public DynamicCtxVar<String> getEntityType() {
        return this.entityType;
    }

    public String getPosition() {
        return this.position;
    }

    public DynamicCtxVar<Vec3> getDirection() {
        return this.direction;
    }

    public DynamicCtxVar<Vec3> getMotion() {
        return this.motion;
    }

    public DynamicCtxVar<CompoundTag> getTag() {
        return this.tag;
    }

    @Override
    protected void wasActivated(SpellContext ctx) {
        SpellsUtil.stringToObject(ctx, this.entityType, ForgeRegistries.ENTITY_TYPES).ifPresent(entityType -> {
            if (entityType != EntityType.f_20532_) {
                ctx.getTargetGroup(this.position).getSingleTarget(target -> ((ITargetType)TargetTypes.POSITION.get()).ifType((Target)target, position -> {
                    Vec3 direction = this.direction.getValue(ctx).orElse(Vec3.f_82478_);
                    Vec3 motion = this.motion.getValue(ctx).orElse(Vec3.f_82478_);
                    Entity entity = entityType.m_20615_(ctx.getLevel());
                    if (entity != null) {
                        entity.m_146884_(position.getPosition());
                        entity.m_146922_((float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * 57.2957763671875));
                        entity.m_146926_((float)(Mth.m_14136_((double)direction.f_82480_, (double)direction.m_165924_()) * 57.2957763671875));
                        entity.m_20256_(motion);
                        this.tag.getValue(ctx).ifPresent(tag0 -> {
                            CompoundTag tag = entity.m_20240_(new CompoundTag());
                            for (String key : tag0.m_128431_()) {
                                Tag t = tag0.m_128423_(key);
                                if (t == null) continue;
                                tag.m_128365_(key, t);
                            }
                            entity.m_20258_(tag);
                        });
                        ctx.getLevel().m_7967_(entity);
                        ctx.getOrCreateTargetGroup(this.entity).addTargets((Target)Target.of(entity));
                    }
                }));
            }
        });
    }
}

