/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.EntityTarget;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.phys.Vec3;

public class TeleportToAction
extends AffectTypeAction<EntityTarget> {
    protected String position;

    public static Codec<TeleportToAction> makeCodec(SpellActionType<TeleportToAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(TeleportToAction.activationCodec(), TeleportToAction.multiTargetsCodec(), (App)Codec.STRING.fieldOf(ParamNames.singleTarget("position")).forGetter(TeleportToAction::getPosition)).apply((Applicative)instance, (activation, multiTargets, position) -> new TeleportToAction(type, (String)activation, (String)multiTargets, (String)position)));
    }

    public static TeleportToAction make(Object activation, Object multiTargets, String position) {
        return new TeleportToAction((SpellActionType)SpellActionTypes.TELEPORT_TO.get(), activation.toString(), multiTargets.toString(), position);
    }

    public TeleportToAction(SpellActionType<?> type) {
        super(type);
    }

    public TeleportToAction(SpellActionType<?> type, String activation, String multiTargets, String position) {
        super(type, activation, multiTargets);
        this.position = position;
    }

    @Override
    public ITargetType<EntityTarget> getAffectedType() {
        return (ITargetType)TargetTypes.ENTITY.get();
    }

    public String getPosition() {
        return this.position;
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, EntityTarget target) {
        ctx.getTargetGroup(this.position).getSingleTarget(t -> ((ITargetType)TargetTypes.POSITION.get()).ifType((Target)t, position -> {
            Vec3 pos = position.getPosition();
            target.getEntity().m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }));
    }
}

