/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.fx;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PositionTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class SpawnParticlesAction
extends AffectTypeAction<PositionTarget> {
    protected ParticleOptions particle;
    protected DynamicCtxVar<Integer> count;
    protected DynamicCtxVar<Double> spread;

    public static Codec<SpawnParticlesAction> makeCodec(SpellActionType<SpawnParticlesAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(SpawnParticlesAction.activationCodec(), SpawnParticlesAction.multiTargetsCodec(), (App)ParticleTypes.f_123791_.fieldOf("particle").forGetter(SpawnParticlesAction::getParticle), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("count")).forGetter(SpawnParticlesAction::getCount), (App)((CtxVarType)CtxVarTypes.DOUBLE.get()).refCodec().fieldOf(ParamNames.paramDouble("spread")).forGetter(SpawnParticlesAction::getSpread)).apply((Applicative)instance, (activation, multiTargets, particle, count, spread) -> new SpawnParticlesAction(type, (String)activation, (String)multiTargets, (ParticleOptions)particle, (DynamicCtxVar<Integer>)count, (DynamicCtxVar<Double>)spread)));
    }

    public static SpawnParticlesAction make(Object activation, Object multiTargets, ParticleOptions particle, DynamicCtxVar<Integer> count, DynamicCtxVar<Double> spread) {
        return new SpawnParticlesAction((SpellActionType)SpellActionTypes.SPAWN_PARTICLES.get(), activation.toString(), multiTargets.toString(), particle, count, spread);
    }

    public SpawnParticlesAction(SpellActionType<?> type) {
        super(type);
    }

    public SpawnParticlesAction(SpellActionType<?> type, String activation, String multiTargets, ParticleOptions particle, DynamicCtxVar<Integer> count, DynamicCtxVar<Double> spread) {
        super(type, activation, multiTargets);
        this.particle = particle;
        this.count = count;
        this.spread = spread;
    }

    public ParticleOptions getParticle() {
        return this.particle;
    }

    public DynamicCtxVar<Integer> getCount() {
        return this.count;
    }

    public DynamicCtxVar<Double> getSpread() {
        return this.spread;
    }

    @Override
    public ITargetType<PositionTarget> getAffectedType() {
        return (ITargetType)TargetTypes.POSITION.get();
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, PositionTarget positionTarget) {
        this.count.getValue(ctx).ifPresent(count -> this.spread.getValue(ctx).ifPresent(spread -> {
            Level patt3477$temp = positionTarget.getLevel();
            if (patt3477$temp instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt3477$temp;
                level.m_8767_(this.particle, positionTarget.getPosition().m_7096_(), positionTarget.getPosition().m_7098_(), positionTarget.getPosition().m_7094_(), count.intValue(), SpellsUtil.RANDOM.m_188583_() * spread, SpellsUtil.RANDOM.m_188583_() * spread, SpellsUtil.RANDOM.m_188583_() * spread, 0.0);
            }
        }));
    }
}

