/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectSingleTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import de.cas_ual_ty.spells.util.SpellsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ConsumePlayerItemsAction
extends AffectSingleTypeAction<PlayerTarget> {
    protected DynamicCtxVar<String> item;
    protected DynamicCtxVar<Integer> amount;
    protected DynamicCtxVar<CompoundTag> tag;
    protected DynamicCtxVar<Boolean> mustBeInHand;

    public static Codec<ConsumePlayerItemsAction> makeCodec(SpellActionType<ConsumePlayerItemsAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(ConsumePlayerItemsAction.activationCodec(), ConsumePlayerItemsAction.sourceCodec(), (App)((CtxVarType)CtxVarTypes.STRING.get()).refCodec().fieldOf(ParamNames.paramString("item")).forGetter(ConsumePlayerItemsAction::getItem), (App)((CtxVarType)CtxVarTypes.INT.get()).refCodec().fieldOf(ParamNames.paramInt("amount")).forGetter(ConsumePlayerItemsAction::getAmount), (App)((CtxVarType)CtxVarTypes.TAG.get()).refCodec().fieldOf(ParamNames.paramCompoundTag("tag")).forGetter(ConsumePlayerItemsAction::getTag), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("must_be_in_hand")).forGetter(ConsumePlayerItemsAction::getMustBeInHand)).apply((Applicative)instance, (activation, source, item, amount, tag, mustBeInHand) -> new ConsumePlayerItemsAction(type, (String)activation, (String)source, (DynamicCtxVar<String>)item, (DynamicCtxVar<Integer>)amount, (DynamicCtxVar<CompoundTag>)tag, (DynamicCtxVar<Boolean>)mustBeInHand)));
    }

    public static ConsumePlayerItemsAction make(Object activation, Object source, DynamicCtxVar<String> item, DynamicCtxVar<Integer> amount, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<Boolean> mustBeInHand) {
        return new ConsumePlayerItemsAction((SpellActionType)SpellActionTypes.CONSUME_PLAYER_ITEMS.get(), activation.toString(), source.toString(), item, amount, tag, mustBeInHand);
    }

    public ConsumePlayerItemsAction(SpellActionType<?> type) {
        super(type);
    }

    public ConsumePlayerItemsAction(SpellActionType<?> type, String activation, String source, DynamicCtxVar<String> item, DynamicCtxVar<Integer> amount, DynamicCtxVar<CompoundTag> tag, DynamicCtxVar<Boolean> mustBeInHand) {
        super(type, activation, source);
        this.item = item;
        this.amount = amount;
        this.tag = tag;
        this.mustBeInHand = mustBeInHand;
    }

    public DynamicCtxVar<String> getItem() {
        return this.item;
    }

    public DynamicCtxVar<Integer> getAmount() {
        return this.amount;
    }

    public DynamicCtxVar<CompoundTag> getTag() {
        return this.tag;
    }

    public DynamicCtxVar<Boolean> getMustBeInHand() {
        return this.mustBeInHand;
    }

    @Override
    public void affectSingleTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        Player player = playerTarget.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        SpellsUtil.stringToObject(ctx, this.item, ForgeRegistries.ITEMS).ifPresent(item -> this.amount.getValue(ctx).ifPresent(amount -> this.mustBeInHand.getValue(ctx).ifPresent(mustBeInHand -> {
            List<ItemStack> items;
            if (mustBeInHand.booleanValue()) {
                items = List.of(player.m_21205_(), player.m_21206_());
            } else {
                items = new ArrayList<ItemStack>(player.m_150109_().f_35974_.size());
                items.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
                items.addAll((Collection<ItemStack>)player.m_150109_().f_35976_);
            }
            CompoundTag tag = this.tag.getValue(ctx).orElse(null);
            int count = amount;
            for (ItemStack i : items) {
                if (i.m_41720_() == item && (tag == null || i.m_41783_() != null && tag.equals((Object)i.m_41783_()))) {
                    int c = Math.min(count, i.m_41613_());
                    i.m_41774_(c);
                    count -= c;
                }
                if (count > 0) continue;
                break;
            }
        })));
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }
}

