/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.spells.spell.action.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cas_ual_ty.spells.registers.CtxVarTypes;
import de.cas_ual_ty.spells.registers.SpellActionTypes;
import de.cas_ual_ty.spells.registers.TargetTypes;
import de.cas_ual_ty.spells.spell.action.SpellActionType;
import de.cas_ual_ty.spells.spell.action.base.AffectTypeAction;
import de.cas_ual_ty.spells.spell.context.SpellContext;
import de.cas_ual_ty.spells.spell.context.TargetGroup;
import de.cas_ual_ty.spells.spell.target.ITargetType;
import de.cas_ual_ty.spells.spell.target.ItemTarget;
import de.cas_ual_ty.spells.spell.target.PlayerTarget;
import de.cas_ual_ty.spells.spell.target.Target;
import de.cas_ual_ty.spells.spell.variable.CtxVarType;
import de.cas_ual_ty.spells.spell.variable.DynamicCtxVar;
import de.cas_ual_ty.spells.util.ParamNames;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FindItemAction
extends AffectTypeAction<PlayerTarget> {
    protected DynamicCtxVar<Boolean> mustBeInHand;
    protected ItemStack item;
    protected String foundItems;

    public static Codec<FindItemAction> makeCodec(SpellActionType<FindItemAction> type) {
        return RecordCodecBuilder.create(instance -> instance.group(FindItemAction.activationCodec(), FindItemAction.multiTargetsCodec(), (App)((CtxVarType)CtxVarTypes.BOOLEAN.get()).refCodec().fieldOf(ParamNames.paramBoolean("must_be_in_hand")).forGetter(FindItemAction::getMustBeInHand), (App)ItemStack.f_41582_.fieldOf("item").forGetter(FindItemAction::getItem), (App)Codec.STRING.fieldOf(ParamNames.destinationTarget("found_items")).forGetter(FindItemAction::getFoundItems)).apply((Applicative)instance, (activation, target, mustBeInHand, item, foundItems) -> new FindItemAction(type, (String)activation, (String)target, (DynamicCtxVar<Boolean>)mustBeInHand, (ItemStack)item, (String)foundItems)));
    }

    public static FindItemAction make(Object activation, Object multiTargets, DynamicCtxVar<Boolean> mustBeInHand, ItemStack item, String foundItems) {
        return new FindItemAction((SpellActionType)SpellActionTypes.FIND_ITEM.get(), activation.toString(), multiTargets.toString(), mustBeInHand, item, foundItems);
    }

    public FindItemAction(SpellActionType<?> type) {
        super(type);
    }

    public FindItemAction(SpellActionType<?> type, String activation, String multiTargets, DynamicCtxVar<Boolean> mustBeInHand, ItemStack item, String foundItems) {
        super(type, activation, multiTargets);
        this.mustBeInHand = mustBeInHand;
        this.item = item;
        this.foundItems = foundItems;
    }

    public DynamicCtxVar<Boolean> getMustBeInHand() {
        return this.mustBeInHand;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public String getFoundItems() {
        return this.foundItems;
    }

    @Override
    public ITargetType<PlayerTarget> getAffectedType() {
        return (ITargetType)TargetTypes.PLAYER.get();
    }

    @Override
    public void affectTarget(SpellContext ctx, TargetGroup group, PlayerTarget playerTarget) {
        this.mustBeInHand.getValue(ctx).ifPresent(mustBeInHand -> {
            Player player = playerTarget.getPlayer();
            TargetGroup foundItems = ctx.getOrCreateTargetGroup(this.foundItems);
            if (mustBeInHand.booleanValue()) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack itemStack;
                    if (slot.m_20743_() != EquipmentSlot.Type.HAND || !(itemStack = player.m_6844_(slot)).m_150930_(this.item.m_41720_()) || itemStack.m_41613_() < this.item.m_41613_() || !itemStack.areShareTagsEqual(this.item)) continue;
                    foundItems.addTargets((Target)ItemTarget.of(ctx.level, itemStack, newItem -> player.m_8061_(slot, newItem), player.m_7500_()));
                }
            } else {
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack itemStack = player.m_150109_().m_8020_(i);
                    if (!itemStack.m_150930_(this.item.m_41720_()) || itemStack.m_41613_() < this.item.m_41613_() || !itemStack.areShareTagsEqual(this.item)) continue;
                    int finalI = i;
                    foundItems.addTargets((Target)ItemTarget.of(ctx.level, itemStack, newItem -> player.m_150109_().m_6836_(finalI, newItem), player.m_7500_()));
                }
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ItemStack itemStack;
                    if (slot == EquipmentSlot.MAINHAND || !(itemStack = player.m_6844_(slot)).m_150930_(this.item.m_41720_()) || itemStack.m_41613_() < this.item.m_41613_() || !itemStack.areShareTagsEqual(this.item)) continue;
                    foundItems.addTargets((Target)ItemTarget.of(ctx.level, itemStack, newItem -> player.m_8061_(slot, newItem), player.m_7500_()));
                }
            }
        });
    }
}

